/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.util.Date;
import java.util.TimeZone;
import javax.security.auth.Subject;
import weblogic.entitlement.rules.BasePredicate;
import weblogic.entitlement.rules.DatePredicateArgument;
import weblogic.entitlement.rules.TimeZonePredicateArgument;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;
import weblogic.security.providers.authorization.PredicateArgument;
import weblogic.security.service.ContextHandler;
import weblogic.security.spi.Resource;

public final class After
extends BasePredicate {
    private static final String VERSION = "1.0";
    private static final PredicateArgument DATE_ARG = new DatePredicateArgument(86399999L);
    private static final PredicateArgument TIME_ZONE_ARG = new TimeZonePredicateArgument();
    private static PredicateArgument[] arguments = new PredicateArgument[]{DATE_ARG, TIME_ZONE_ARG};
    private long dateTime;
    private TimeZone timeZone = null;

    public After() {
        super("AfterPredicateName", "AfterPredicateDescription");
    }

    public void init(String[] stringArray) throws IllegalPredicateArgumentException {
        if (stringArray == null || stringArray.length < 1) {
            throw new IllegalPredicateArgumentException("At least one argument is expected");
        }
        if (stringArray.length > 2) {
            throw new IllegalPredicateArgumentException("Maximum two arguments are expected");
        }
        this.dateTime = this.parseDate(stringArray[0]).getTime();
        this.timeZone = stringArray.length > 1 ? this.parseTimeZone(stringArray[1]) : null;
    }

    private Date parseDate(String string) throws IllegalPredicateArgumentException {
        return (Date)DATE_ARG.parseExprValue(string);
    }

    private TimeZone parseTimeZone(String string) throws IllegalPredicateArgumentException {
        return (TimeZone)TIME_ZONE_ARG.parseExprValue(string);
    }

    public boolean evaluate(Subject subject, Resource resource, ContextHandler contextHandler) {
        long l = System.currentTimeMillis();
        if (this.timeZone == null) {
            return l > this.dateTime;
        }
        return l + (long)TimeZone.getDefault().getRawOffset() > this.dateTime + (long)this.timeZone.getRawOffset();
    }

    public String getVersion() {
        return VERSION;
    }

    public int getArgumentCount() {
        return arguments.length;
    }

    public PredicateArgument getArgument(int n) {
        return arguments[n];
    }
}

