/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.util.Locale;
import weblogic.entitlement.rules.Localizer;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;
import weblogic.security.providers.authorization.Predicate;
import weblogic.security.providers.authorization.PredicateArgument;

public abstract class BasePredicate
implements Predicate {
    private String displayNameId;
    private String descriptionId;

    public BasePredicate(String string, String string2) {
        this.displayNameId = string;
        this.descriptionId = string2;
    }

    public void init(String[] stringArray) throws IllegalPredicateArgumentException {
        if (stringArray != null && stringArray.length > 0) {
            throw new IllegalPredicateArgumentException("No arguments expected");
        }
    }

    public boolean isSupportedResource(String string) {
        return true;
    }

    public String getDisplayName(Locale locale) {
        return Localizer.getText(this.displayNameId, locale);
    }

    public String getDescription(Locale locale) {
        return Localizer.getText(this.descriptionId, locale);
    }

    public int getArgumentCount() {
        return 0;
    }

    public PredicateArgument getArgument(int n) {
        throw new IndexOutOfBoundsException("This predicate takes no arguments");
    }

    public boolean isDeprecated() {
        return false;
    }
}

