/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import weblogic.entitlement.rules.Localizer;
import weblogic.entitlement.rules.PredicateTextFormatter;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;
import weblogic.security.providers.authorization.PredicateArgument;

public abstract class BasePredicateArgument
implements PredicateArgument {
    protected String displayNameId;
    private String descriptionId;
    private Class type;
    private Object defaultValue;
    private boolean optional;
    public static final int CALENDAR_YEAR = 2006;
    public static final int CALENDAR_MONTH = 3;
    public static final int CALENDAR_DAY_OF_MONTH = 25;
    public static final int CALENDAR_HOUR = 20;
    public static final int CALENDAR_MINUTE = 45;
    public static final int CALENDAR_SECOND = 35;
    public static final int EST_HOUR_OFFSET = 5;

    public BasePredicateArgument(String string, String string2, Class clazz, Object object) {
        this(string, string2, clazz, object, false);
    }

    public BasePredicateArgument(String string, String string2, Class clazz, Object object, boolean bl) {
        this.displayNameId = string;
        this.descriptionId = string2;
        this.type = clazz;
        this.defaultValue = object;
        this.optional = bl;
    }

    public String getType() {
        return this.type.getName();
    }

    public String getDisplayName(Locale locale) {
        return Localizer.getText(this.displayNameId, locale);
    }

    public String getDescription(Locale locale) {
        return Localizer.getText(this.descriptionId, locale);
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void validateValue(Object object, Locale locale) throws IllegalPredicateArgumentException {
        if (object == null) {
            throw new IllegalPredicateArgumentException(Localizer.getText("NullArgumentValue", locale));
        }
        if (!this.type.isAssignableFrom(object.getClass())) {
            String string = new PredicateTextFormatter(locale).getInvalidArgumentTypeMessage(this.getType());
            throw new IllegalPredicateArgumentException(string);
        }
    }

    public Object parseValue(String string, Locale locale) throws IllegalPredicateArgumentException {
        return string;
    }

    public String formatValue(Object object, Locale locale) throws IllegalPredicateArgumentException {
        return object.toString();
    }

    public Object parseExprValue(String string) throws IllegalPredicateArgumentException {
        return this.parseValue(string, Locale.US);
    }

    public String formatExprValue(Object object) throws IllegalPredicateArgumentException {
        return this.formatValue(object, Locale.US);
    }

    protected static void test(PredicateArgument predicateArgument, String string) throws Exception {
        Locale locale = Locale.getDefault();
        System.out.println("Name: " + predicateArgument.getDisplayName(locale));
        System.out.println("Description: " + predicateArgument.getDescription(locale));
        System.out.println("Original string: " + string);
        Object object = predicateArgument.parseValue(string, locale);
        String string2 = predicateArgument.formatExprValue(object);
        System.out.println("Formatted expression value: " + string2);
        Object object2 = predicateArgument.parseExprValue(string2);
        if (!object.equals(object2)) {
            System.out.println("Values 1/expr are different: " + object + ", " + object2);
        }
        string = predicateArgument.formatValue(object2, locale);
        System.out.println("Formatted localized value: " + string);
        Object object3 = predicateArgument.parseValue(string, locale);
        if (!object.equals(object3)) {
            System.out.println("Values 1/2 are different: " + object + ", " + object3);
        }
    }

    public String getDatePattern(Locale locale) {
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormat;
            return simpleDateFormat.toPattern();
        }
        return new String(" ");
    }

    public String getTimePattern(Locale locale) {
        return this.getTimePattern(locale, 2);
    }

    public String getTimePattern(Locale locale, int n) {
        DateFormat dateFormat = DateFormat.getTimeInstance(n, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormat;
            return simpleDateFormat.toPattern();
        }
        return new String(" ");
    }

    public String getDateTimePattern(Locale locale) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormat;
            return simpleDateFormat.toPattern();
        }
        return new String(" ");
    }

    public String getFormatedDateTimePattern(Locale locale) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2, locale);
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormat;
        StringBuffer stringBuffer = new StringBuffer(simpleDateFormat.toPattern());
        int n = stringBuffer.indexOf("a");
        if (n >= 0) {
            stringBuffer = stringBuffer.replace(n, n + 1, Localizer.getText("AM_PM", locale));
        }
        return stringBuffer.toString();
    }

    public String getFormatedTimePattern(Locale locale) {
        return this.getFormatedTimePattern(locale, 3);
    }

    public String getFormatedTimePattern(Locale locale, int n) {
        DateFormat dateFormat = DateFormat.getTimeInstance(n, locale);
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormat;
        String string = simpleDateFormat.toPattern();
        StringBuffer stringBuffer = new StringBuffer(simpleDateFormat.toPattern());
        int n2 = stringBuffer.indexOf("a");
        if (n2 >= 0) {
            stringBuffer = stringBuffer.replace(n2, n2 + 1, Localizer.getText("AM_PM", locale));
        }
        return stringBuffer.toString();
    }

    public String getFormatedDateString(String string, Locale locale, Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
        StringBuffer stringBuffer = simpleDateFormat.format(date, new StringBuffer(), new FieldPosition(0));
        return stringBuffer.toString();
    }

    public String parseMessage(StringBuffer stringBuffer, ArrayList arrayList) {
        String string = "{";
        String string2 = "}";
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = stringBuffer.indexOf(string);
            int n2 = stringBuffer.indexOf(string2);
            String string3 = stringBuffer.substring(n, n2 + 1);
            String string4 = stringBuffer.substring(n + 1, n2);
            if (string3.length() < 0) continue;
            stringBuffer = stringBuffer.replace(n, n2 + 1, (String)arrayList.get(Integer.parseInt(string4)));
        }
        return stringBuffer.toString();
    }
}

