/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import weblogic.entitlement.rules.BasePredicateArgument;
import weblogic.entitlement.rules.Localizer;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;

public class DatePredicateArgument
extends BasePredicateArgument {
    private long defaultTime = 0L;

    public DatePredicateArgument(long l) {
        this("DatePredicateArgumentName", "DatePredicateArgumentDescription", new Date(), l);
    }

    public DatePredicateArgument(String string, String string2, Date date, long l) {
        super(string, string2, Date.class, date);
        long l2 = 86400000L;
        if (l < 0L || l > l2) {
            throw new IllegalArgumentException("Default time parameter must be > 0 and < " + l2);
        }
        this.defaultTime = l;
    }

    public Object parseValue(String string, Locale locale) throws IllegalPredicateArgumentException {
        try {
            return this.parseValueOrig(string, locale);
        }
        catch (IllegalPredicateArgumentException illegalPredicateArgumentException) {
            try {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2, locale);
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                return dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                throw illegalPredicateArgumentException;
            }
        }
    }

    private Object parseValueOrig(String string, Locale locale) throws IllegalPredicateArgumentException {
        long l;
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(timeZone);
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = dateFormat.parse(string, parsePosition);
        if (date == null) {
            String string2 = Localizer.getText("InvalidDateFormat", locale);
            throw new IllegalPredicateArgumentException(string2);
        }
        if (string.substring(parsePosition.getIndex()).trim().length() > 0) {
            DateFormat dateFormat2 = DateFormat.getTimeInstance(2, locale);
            dateFormat2.setLenient(false);
            dateFormat2.setTimeZone(timeZone);
            Date date2 = dateFormat2.parse(string, parsePosition);
            if (date2 == null) {
                String string3 = Localizer.getText("InvalidTimeFormat", locale);
                throw new IllegalPredicateArgumentException(string3);
            }
            l = date2.getTime();
        } else {
            l = this.defaultTime;
        }
        return new Date(date.getTime() + l);
    }

    public String formatValue(Object object, Locale locale) throws IllegalPredicateArgumentException {
        this.validateValue(object, locale);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2, locale);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format((Date)object);
    }

    public Object parseExprValue(String string) throws IllegalPredicateArgumentException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        simpleDateFormat.setLenient(false);
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalPredicateArgumentException(parseException.getMessage());
        }
    }

    public String formatExprValue(Object object) throws IllegalPredicateArgumentException {
        this.validateValue(object, null);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format((Date)object);
    }

    public static void main(String[] stringArray) throws Exception {
        DatePredicateArgument.test(new DatePredicateArgument(0L), stringArray[0]);
    }

    public String getDescription(Locale locale) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getDatePattern(locale);
        arrayList.add(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        gregorianCalendar.set(1, 2006);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 25);
        Date date = new Date(gregorianCalendar.getTimeInMillis());
        arrayList.add(this.getFormatedDateString(string, locale, date));
        arrayList.add(this.getFormatedDateTimePattern(locale));
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(locale);
        gregorianCalendar2.set(1, 2006);
        gregorianCalendar2.set(2, 3);
        gregorianCalendar2.set(5, 25);
        gregorianCalendar2.set(10, 20);
        gregorianCalendar2.set(12, 45);
        gregorianCalendar2.set(13, 35);
        gregorianCalendar2.set(9, 0);
        Date date2 = new Date(gregorianCalendar2.getTimeInMillis());
        arrayList.add(this.getFormatedDateString(this.getDateTimePattern(locale), locale, date2));
        StringBuffer stringBuffer = new StringBuffer(Localizer.getText("DatePredicateArgumentDescription", locale));
        return this.parseMessage(stringBuffer, arrayList);
    }
}

