/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.util.Calendar;
import java.util.TimeZone;
import weblogic.entitlement.rules.BasePredicate;
import weblogic.entitlement.rules.DayOfMonthPredicateArgument;
import weblogic.entitlement.rules.TimeZonePredicateArgument;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;
import weblogic.security.providers.authorization.PredicateArgument;

public abstract class DayOfMonthPredicate
extends BasePredicate {
    private static final String VERSION = "1.0";
    private static PredicateArgument DAY_OF_MONTH_ARG = new DayOfMonthPredicateArgument();
    private static PredicateArgument TIME_ZONE_ARG = new TimeZonePredicateArgument();
    private static PredicateArgument[] arguments = new PredicateArgument[]{DAY_OF_MONTH_ARG, TIME_ZONE_ARG};
    private int dayOfMonth = 0;
    private TimeZone timeZone = null;

    public DayOfMonthPredicate(String string, String string2) {
        super(string, string2);
    }

    public void init(String[] stringArray) throws IllegalPredicateArgumentException {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalPredicateArgumentException("At least one argument is expected");
        }
        if (stringArray.length > 2) {
            throw new IllegalPredicateArgumentException("Maximum two arguments are expected");
        }
        this.dayOfMonth = this.parseDayOfMonth(stringArray[0]);
        this.timeZone = stringArray.length > 1 ? this.parseTimeZone(stringArray[1]) : null;
    }

    protected int getDayOfMonthArgument() {
        return this.dayOfMonth;
    }

    protected TimeZone getTimeZoneArgument() {
        return this.timeZone;
    }

    protected Calendar getCurrentDate() {
        return Calendar.getInstance(this.timeZone == null ? TimeZone.getDefault() : this.timeZone);
    }

    protected int getDayOfMonth(Calendar calendar) {
        int n = this.dayOfMonth;
        if (n < 0) {
            n += 1 + calendar.getActualMaximum(5);
        }
        return n;
    }

    private int parseDayOfMonth(String string) throws IllegalPredicateArgumentException {
        return ((Number)DAY_OF_MONTH_ARG.parseExprValue(string)).intValue();
    }

    private TimeZone parseTimeZone(String string) throws IllegalPredicateArgumentException {
        return (TimeZone)TIME_ZONE_ARG.parseExprValue(string);
    }

    public String getVersion() {
        return VERSION;
    }

    public int getArgumentCount() {
        return arguments.length;
    }

    public PredicateArgument getArgument(int n) {
        return arguments[n];
    }
}

