/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.util.Locale;
import weblogic.entitlement.rules.Localizer;
import weblogic.entitlement.rules.NumberPredicateArgument;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;
import weblogic.security.providers.authorization.RangePredicateArgument;

public class DayOfMonthPredicateArgument
extends NumberPredicateArgument
implements RangePredicateArgument {
    private static final Integer MAX_VALUE = new Integer(31);
    private static final Integer MIN_VALUE = new Integer(-31);

    public DayOfMonthPredicateArgument() {
        this("DayOfMonthPredicateArgumentName", "DayOfMonthPredicateArgumentDescription", 1);
    }

    public DayOfMonthPredicateArgument(String string, String string2, int n) {
        super(string, string2, Integer.class, new Integer(n), true);
    }

    public Comparable getMinValue() {
        return MIN_VALUE;
    }

    public Comparable getMaxValue() {
        return MAX_VALUE;
    }

    public void validateValue(Object object, Locale locale) throws IllegalPredicateArgumentException {
        super.validateValue(object, locale);
        int n = (Integer)object;
        if (n < MIN_VALUE || n > MAX_VALUE) {
            String string = Localizer.getText("InvalidDayOfMonth", locale);
            throw new IllegalPredicateArgumentException(string);
        }
    }

    public Object parseValue(String string, Locale locale) throws IllegalPredicateArgumentException {
        Number number = (Number)super.parseValue(string, locale);
        number = new Integer(number.intValue());
        this.validateValue(number, locale);
        return number;
    }

    public String formatValue(Object object, Locale locale) throws IllegalPredicateArgumentException {
        this.validateValue(object, locale);
        return super.formatValue(object, locale);
    }

    public static void main(String[] stringArray) throws Exception {
        DayOfMonthPredicateArgument.test(new DayOfMonthPredicateArgument(), stringArray[0]);
    }
}

