/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.util.Locale;
import weblogic.entitlement.rules.Localizer;

public final class DayOfWeek {
    public static final DayOfWeek SUNDAY = new DayOfWeek(1, "Sunday", "Sunday");
    public static final DayOfWeek MONDAY = new DayOfWeek(2, "Monday", "Monday");
    public static final DayOfWeek TUESDAY = new DayOfWeek(3, "Tuesday", "Tuesday");
    public static final DayOfWeek WEDNESDAY = new DayOfWeek(4, "Wednesday", "Wednesday");
    public static final DayOfWeek THURSDAY = new DayOfWeek(5, "Thursday", "Thursday");
    public static final DayOfWeek FRIDAY = new DayOfWeek(6, "Friday", "Friday");
    public static final DayOfWeek SATURDAY = new DayOfWeek(7, "Saturday", "Saturday");
    private int id;
    private String name;
    private String nameId;

    private DayOfWeek(int n, String string, String string2) {
        this.id = n;
        this.name = string;
        this.nameId = string2;
    }

    public int getCalendarDayId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName(Locale locale) {
        return Localizer.getText(this.nameId, locale);
    }

    public static DayOfWeek getInstance(int n) {
        if (n == DayOfWeek.SUNDAY.id) {
            return SUNDAY;
        }
        if (n == DayOfWeek.MONDAY.id) {
            return MONDAY;
        }
        if (n == DayOfWeek.TUESDAY.id) {
            return TUESDAY;
        }
        if (n == DayOfWeek.WEDNESDAY.id) {
            return WEDNESDAY;
        }
        if (n == DayOfWeek.THURSDAY.id) {
            return THURSDAY;
        }
        if (n == DayOfWeek.FRIDAY.id) {
            return FRIDAY;
        }
        if (n == DayOfWeek.SATURDAY.id) {
            return SATURDAY;
        }
        throw new IllegalArgumentException("Unexpected day of week id: " + n);
    }
}

