/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.util.TimeZone;
import weblogic.entitlement.rules.BasePredicate;
import weblogic.entitlement.rules.DayOfWeek;
import weblogic.entitlement.rules.DayOfWeekPredicateArgument;
import weblogic.entitlement.rules.TimeZonePredicateArgument;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;
import weblogic.security.providers.authorization.PredicateArgument;

public abstract class DayOfWeekPredicate
extends BasePredicate {
    private static final String VERSION = "1.0";
    private static PredicateArgument DAY_OF_WEEK_ARG = new DayOfWeekPredicateArgument();
    private static PredicateArgument TIME_ZONE_ARG = new TimeZonePredicateArgument();
    private static PredicateArgument[] arguments = new PredicateArgument[]{DAY_OF_WEEK_ARG, TIME_ZONE_ARG};
    private DayOfWeek dayOfWeek = null;
    private TimeZone timeZone = null;

    public DayOfWeekPredicate(String string, String string2) {
        super(string, string2);
    }

    public void init(String[] stringArray) throws IllegalPredicateArgumentException {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalPredicateArgumentException("At least one argument is expected");
        }
        if (stringArray.length > 2) {
            throw new IllegalPredicateArgumentException("Maximum two arguments are expected");
        }
        this.dayOfWeek = this.parseDayOfTheWeek(stringArray[0]);
        this.timeZone = stringArray.length > 1 ? this.parseTimeZone(stringArray[1]) : null;
    }

    protected DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    protected TimeZone getTimeZone() {
        return this.timeZone;
    }

    private DayOfWeek parseDayOfTheWeek(String string) throws IllegalPredicateArgumentException {
        return (DayOfWeek)DAY_OF_WEEK_ARG.parseExprValue(string);
    }

    private TimeZone parseTimeZone(String string) throws IllegalPredicateArgumentException {
        return (TimeZone)TIME_ZONE_ARG.parseExprValue(string);
    }

    public String getVersion() {
        return VERSION;
    }

    public int getArgumentCount() {
        return arguments.length;
    }

    public PredicateArgument getArgument(int n) {
        return arguments[n];
    }
}

