/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import weblogic.entitlement.rules.BasePredicateArgument;
import weblogic.entitlement.rules.DayOfWeek;
import weblogic.entitlement.rules.PredicateTextFormatter;
import weblogic.security.providers.authorization.EnumeratedPredicateArgument;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;

public class DayOfWeekPredicateArgument
extends BasePredicateArgument
implements EnumeratedPredicateArgument {
    private static final List DAYS;

    public DayOfWeekPredicateArgument() {
        this("DayOfWeekPredicateArgumentName", "DayOfWeekPredicateArgumentDescription", DayOfWeek.MONDAY);
    }

    public DayOfWeekPredicateArgument(String string, String string2, DayOfWeek dayOfWeek) {
        super(string, string2, DayOfWeek.class, dayOfWeek);
    }

    public List getAllowedValues() {
        return DAYS;
    }

    public Object parseValue(String string, Locale locale) throws IllegalPredicateArgumentException {
        for (int i = 0; i < DAYS.size(); ++i) {
            DayOfWeek dayOfWeek = (DayOfWeek)DAYS.get(i);
            if (!dayOfWeek.getLocalizedName(locale).equals(string)) continue;
            return dayOfWeek;
        }
        String string2 = new PredicateTextFormatter(locale).getInvalidDayOfWeekMessage(string);
        throw new IllegalPredicateArgumentException(string2);
    }

    public String formatValue(Object object, Locale locale) throws IllegalPredicateArgumentException {
        this.validateValue(object, locale);
        return ((DayOfWeek)object).getLocalizedName(locale);
    }

    public Object parseExprValue(String string) throws IllegalPredicateArgumentException {
        for (int i = 0; i < DAYS.size(); ++i) {
            DayOfWeek dayOfWeek = (DayOfWeek)DAYS.get(i);
            if (!dayOfWeek.getName().equals(string)) continue;
            return dayOfWeek;
        }
        throw new IllegalPredicateArgumentException("Unknown day of the week " + string);
    }

    public String formatExprValue(Object object) throws IllegalPredicateArgumentException {
        this.validateValue(object, null);
        return ((DayOfWeek)object).getName();
    }

    public static void main(String[] stringArray) throws Exception {
        DayOfWeekPredicateArgument.test(new DayOfWeekPredicateArgument(), stringArray[0]);
    }

    static {
        ArrayList<DayOfWeek> arrayList = new ArrayList<DayOfWeek>(7);
        arrayList.add(DayOfWeek.SUNDAY);
        arrayList.add(DayOfWeek.MONDAY);
        arrayList.add(DayOfWeek.TUESDAY);
        arrayList.add(DayOfWeek.WEDNESDAY);
        arrayList.add(DayOfWeek.THURSDAY);
        arrayList.add(DayOfWeek.FRIDAY);
        arrayList.add(DayOfWeek.SATURDAY);
        DAYS = Collections.unmodifiableList(arrayList);
    }
}

