/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import weblogic.entitlement.rules.HttpRequestAttrPredicate;
import weblogic.entitlement.rules.NumberPredicateArgument;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;
import weblogic.security.providers.authorization.PredicateArgument;

public abstract class HttpRequestAttrNumberPredicate
extends HttpRequestAttrPredicate {
    private static final PredicateArgument[] arguments = new PredicateArgument[]{ATTR_NAME_ARGUMENT, new NumberPredicateArgument()};
    private double numValue = 0.0;

    public HttpRequestAttrNumberPredicate(String string, String string2) {
        super(string, string2);
    }

    public void init(String[] stringArray) throws IllegalPredicateArgumentException {
        if (stringArray == null || stringArray.length != 2) {
            throw new IllegalPredicateArgumentException("Two arguments are expected");
        }
        this.setAttributeName(stringArray[0]);
        this.numValue = HttpRequestAttrNumberPredicate.parseNumber(stringArray[1]);
    }

    private static double parseNumber(String string) throws IllegalPredicateArgumentException {
        return ((Number)arguments[1].parseExprValue(string)).doubleValue();
    }

    protected static double getAttributeNumber(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            try {
                return HttpRequestAttrNumberPredicate.parseNumber((String)object);
            }
            catch (IllegalPredicateArgumentException illegalPredicateArgumentException) {
                // empty catch block
            }
        }
        throw new RuntimeException("Attribute value is not a number");
    }

    protected double getArgumentNumber() {
        return this.numValue;
    }

    public int getArgumentCount() {
        return arguments.length;
    }

    public PredicateArgument getArgument(int n) {
        return arguments[n];
    }
}

