/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import weblogic.entitlement.rules.BasePredicate;
import weblogic.entitlement.rules.PredicateTextFormatter;
import weblogic.entitlement.rules.StringPredicateArgument;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;
import weblogic.security.providers.authorization.PredicateArgument;
import weblogic.security.service.ContextHandler;

public abstract class HttpRequestAttrPredicate
extends BasePredicate {
    private static final String VERSION = "1.0";
    protected static final PredicateArgument ATTR_NAME_ARGUMENT = new StringPredicateArgument("HttpRequestAttrPredicateAttributeArgumentName", "HttpRequestAttrPredicateAttributeArgumentDescription", null){

        public void validateValue(Object object, Locale locale) throws IllegalPredicateArgumentException {
            super.validateValue(object, locale);
            String string = (String)object;
            if (!(string.startsWith("Attribute.") || string.startsWith("Header.") || string.startsWith("Parameter.") || string.equals("Method") || string.equals("RequestURI") || string.equals("QueryString") || string.equals("Protocol") || string.equals("LocalPort") || string.equals("RemotePort") || string.equals("RemoteHost") || string.startsWith("Session.Attribute."))) {
                String string2 = new PredicateTextFormatter(locale).getInvalidAttributeNameMessage(string);
                throw new IllegalPredicateArgumentException(string2);
            }
        }
    };
    private String attrName;

    public HttpRequestAttrPredicate(String string, String string2) {
        super(string, string2);
    }

    protected String getAttributeName() {
        return this.attrName;
    }

    protected void setAttributeName(String string) throws IllegalPredicateArgumentException {
        ATTR_NAME_ARGUMENT.validateValue((Object)string, (Locale)null);
        this.attrName = string;
    }

    protected Object getAttribute(ContextHandler contextHandler) {
        if (contextHandler == null) {
            return null;
        }
        Object object = null;
        HttpServletRequest httpServletRequest = (HttpServletRequest)contextHandler.getValue("com.bea.contextelement.servlet.HttpServletRequest");
        if (httpServletRequest != null) {
            if (this.attrName.startsWith("Attribute.")) {
                object = httpServletRequest.getAttribute(this.attrName.substring("Attribute.".length()));
            } else if (this.attrName.startsWith("Header.")) {
                object = httpServletRequest.getHeader(this.attrName.substring("Header.".length()));
            } else if (this.attrName.startsWith("Parameter.")) {
                object = httpServletRequest.getParameter(this.attrName.substring("Parameter.".length()));
            } else if (this.attrName.equals("Method")) {
                object = httpServletRequest.getMethod();
            } else if (this.attrName.equals("RequestURI")) {
                object = httpServletRequest.getRequestURI();
            } else if (this.attrName.equals("QueryString")) {
                object = httpServletRequest.getQueryString();
            } else if (this.attrName.equals("Protocol")) {
                object = httpServletRequest.getProtocol();
            } else if (this.attrName.equals("LocalPort")) {
                object = new Integer(httpServletRequest.getLocalPort());
            } else if (this.attrName.equals("RemotePort")) {
                object = new Integer(httpServletRequest.getRemotePort());
            } else if (this.attrName.equals("RemoteHost")) {
                object = httpServletRequest.getRemoteHost();
            } else if (this.attrName.startsWith("Session.Attribute.")) {
                HttpSession httpSession = httpServletRequest.getSession();
                if (httpSession != null) {
                    object = httpSession.getAttribute(this.attrName.substring("Session.Attribute.".length()));
                }
            } else {
                throw new IllegalArgumentException("Not a supported attribute: " + this.attrName);
            }
        }
        return object;
    }

    public boolean isSupportedResource(String string) {
        return string.startsWith("type=<url>");
    }

    public String getVersion() {
        return VERSION;
    }
}

