/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import javax.security.auth.Subject;
import weblogic.entitlement.rules.HttpRequestAttrPredicate;
import weblogic.entitlement.rules.StringPredicateArgument;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;
import weblogic.security.providers.authorization.PredicateArgument;
import weblogic.security.service.ContextHandler;
import weblogic.security.spi.Resource;

public class HttpRequestAttrStringEquals
extends HttpRequestAttrPredicate {
    private static final PredicateArgument[] arguments = new PredicateArgument[]{ATTR_NAME_ARGUMENT, new StringPredicateArgument()};
    private String stringValue = null;

    public HttpRequestAttrStringEquals() {
        super("HttpRequestAttrStringEqualsName", "HttpRequestAttrStringEqualsDescription");
    }

    public void init(String[] stringArray) throws IllegalPredicateArgumentException {
        if (stringArray == null || stringArray.length != 2) {
            throw new IllegalPredicateArgumentException("Two arguments are expected");
        }
        this.setAttributeName(stringArray[0]);
        this.stringValue = stringArray[1];
    }

    public boolean evaluate(Subject subject, Resource resource, ContextHandler contextHandler) {
        Object object = this.getAttribute(contextHandler);
        return object != null && object.toString().equals(this.stringValue);
    }

    public int getArgumentCount() {
        return arguments.length;
    }

    public PredicateArgument getArgument(int n) {
        return arguments[n];
    }
}

