/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import weblogic.entitlement.rules.BasePredicateArgument;
import weblogic.entitlement.rules.Localizer;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;

public class NumberPredicateArgument
extends BasePredicateArgument {
    private boolean parseIntegerOnly = false;

    public NumberPredicateArgument() {
        this("NumberPredicateArgumentName", "NumberPredicateArgumentDescription", null);
    }

    public NumberPredicateArgument(String string, String string2, Number number) {
        super(string, string2, Number.class, number);
    }

    protected NumberPredicateArgument(String string, String string2, Class clazz, Number number, boolean bl) {
        super(string, string2, clazz, number);
        this.parseIntegerOnly = bl;
    }

    public Object parseValue(String string, Locale locale) throws IllegalPredicateArgumentException {
        ParsePosition parsePosition = new ParsePosition(0);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        numberFormat.setParseIntegerOnly(this.parseIntegerOnly);
        Number number = numberFormat.parse(string, parsePosition);
        if (number == null || parsePosition.getIndex() < string.length()) {
            String string2 = Localizer.getText(this.parseIntegerOnly ? "NotIntegerValue" : "NotNumericValue", locale);
            throw new IllegalPredicateArgumentException(string2);
        }
        return number;
    }

    public String formatValue(Object object, Locale locale) throws IllegalPredicateArgumentException {
        super.validateValue(object, locale);
        Number number = (Number)object;
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        if (this.parseIntegerOnly) {
            return numberFormat.format(number.longValue());
        }
        return numberFormat.format(number.doubleValue());
    }
}

