/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import javax.security.auth.Subject;
import weblogic.entitlement.rules.BasePredicate;
import weblogic.entitlement.rules.StringPredicateArgument;
import weblogic.security.SecurityLogger;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;
import weblogic.security.providers.authorization.PredicateArgument;
import weblogic.security.service.ContextHandler;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.spi.Resource;
import weblogic.security.utils.ESubjectImpl;

public class SignaturePredicate
extends BasePredicate {
    public static final String GROUP_TYPE = "group";
    public static final String USERNAME_TYPE = "user";
    private static final String VERSION = "1.0";
    private static final PredicateArgument[] arguments = new PredicateArgument[]{new StringPredicateArgument("SignaturePredicateSignerTypeArgumentName", "SignaturePredicateSignerTypeArgumentDescription", null), new StringPredicateArgument("SignaturePredicateSignedElementArgumentName", "SignaturePredicateSignedElementArgumentDescription", null), new StringPredicateArgument("SignaturePredicateSignerNameArgumentName", "SignaturePredicateSignerNameArgumentDescription", null)};
    private static LoggerWrapper log = LoggerWrapper.getInstance("SecurityPredicate");
    private String signerType = "group";
    private String signerName = null;
    private String signerElement = null;

    public SignaturePredicate() {
        super("SignaturePredicateName", "SignaturePredicateDescription");
    }

    public void init(String[] stringArray) throws IllegalPredicateArgumentException {
        if (stringArray == null || stringArray.length != 3) {
            throw new IllegalPredicateArgumentException(SecurityLogger.getThreeArgumentsRequired());
        }
        String string = stringArray[0];
        if (USERNAME_TYPE.equalsIgnoreCase(string)) {
            this.signerType = USERNAME_TYPE;
        } else if (GROUP_TYPE.equalsIgnoreCase(string)) {
            this.signerType = GROUP_TYPE;
        } else {
            throw new IllegalPredicateArgumentException(SecurityLogger.getTypeMustValueIs((String)GROUP_TYPE, (String)USERNAME_TYPE, (String)string));
        }
        if (stringArray[1] == null) {
            throw new IllegalPredicateArgumentException(SecurityLogger.getSignatureTypeCanNotBeNull());
        }
        this.signerElement = "Integrity{" + stringArray[1] + "}";
        if (stringArray[2] == null) {
            throw new IllegalPredicateArgumentException(SecurityLogger.getSignedByCanNotBeNull());
        }
        this.signerName = stringArray[2];
        if (log.isDebugEnabled()) {
            log.debug("SignaturePredicate.init: signerType=" + this.signerType + ", signerName=" + this.signerName + ", signerElement=" + this.signerElement);
        }
    }

    public boolean evaluate(Subject subject, Resource resource, ContextHandler contextHandler) {
        boolean bl;
        if (log.isDebugEnabled()) {
            log.debug("SignaturePredicate.evaluate: matching " + this.signerType + " " + this.signerName);
        }
        if (contextHandler == null) {
            if (log.isDebugEnabled()) {
                log.debug("SignaturePredicate.evaluate: context is null, returning false");
            }
            return false;
        }
        Subject subject2 = (Subject)contextHandler.getValue(this.signerElement);
        if (subject2 == null) {
            if (log.isDebugEnabled()) {
                log.debug("SignaturePredicate.evaluate: no signer, returning false");
            }
            return false;
        }
        ESubjectImpl eSubjectImpl = new ESubjectImpl(subject2);
        boolean bl2 = bl = this.signerType == USERNAME_TYPE ? eSubjectImpl.isUser(this.signerName) : eSubjectImpl.isMemberOf(this.signerName);
        if (log.isDebugEnabled()) {
            log.debug("SignaturePredicate.evaluate: returning " + bl);
        }
        return bl;
    }

    public boolean isSupportedResource(String string) {
        return string.startsWith("type=<webservices>");
    }

    public String getVersion() {
        return VERSION;
    }

    public int getArgumentCount() {
        return arguments.length;
    }

    public PredicateArgument getArgument(int n) {
        return arguments[n];
    }
}

