/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

public final class TimeOfDay
implements Comparable {
    public int MS_PER_MINUTE = 60000;
    public int MS_PER_HOUR = 60 * this.MS_PER_MINUTE;
    public int MS_PER_DAY = 24 * this.MS_PER_HOUR;
    private int time = 0;

    public TimeOfDay(int n) {
        if (n < 0 || n >= this.MS_PER_DAY) {
            throw new IllegalArgumentException("Time of day must be >= 0 and < " + this.MS_PER_DAY);
        }
        this.time = n;
    }

    public TimeOfDay(int n, int n2, int n3) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("Illegal hours value " + n);
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("Illegal minutes value " + n2);
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException("Illegal seconds value " + n3);
        }
        this.time = n * this.MS_PER_HOUR + n2 * this.MS_PER_MINUTE + n3 * 1000;
    }

    public int getTime() {
        return this.time;
    }

    public int getHours() {
        return this.time / this.MS_PER_HOUR;
    }

    public int getMinutes() {
        return this.time % this.MS_PER_HOUR / this.MS_PER_MINUTE;
    }

    public int getSeconds() {
        return this.time % this.MS_PER_MINUTE / 1000;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof TimeOfDay && this.time == ((TimeOfDay)object).getTime();
    }

    public int hashCode() {
        return this.time;
    }

    public int compareTo(Object object) {
        int n = ((TimeOfDay)object).getTime();
        return this.time < n ? -1 : (this.time > n ? 1 : 0);
    }
}

