/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.util.Calendar;
import java.util.TimeZone;
import javax.security.auth.Subject;
import weblogic.entitlement.rules.BasePredicate;
import weblogic.entitlement.rules.TimeOfDay;
import weblogic.entitlement.rules.TimePredicateArgument;
import weblogic.entitlement.rules.TimeZonePredicateArgument;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;
import weblogic.security.providers.authorization.PredicateArgument;
import weblogic.security.service.ContextHandler;
import weblogic.security.spi.Resource;

public final class TimePredicate
extends BasePredicate {
    private static final String VERSION = "1.0";
    private static PredicateArgument[] arguments = new PredicateArgument[]{new TimePredicateArgument("TimePredicateStartTimeArgumentName", "TimePredicateStartTimeArgumentDescription", null), new TimePredicateArgument("TimePredicateEndTimeArgumentName", "TimePredicateEndTimeArgumentDescription", null), new TimeZonePredicateArgument()};
    private TimeOfDay startTime = null;
    private TimeOfDay endTime = null;
    private TimeZone timeZone = null;

    public TimePredicate() {
        super("TimePredicateName", "TimePredicateDescription");
    }

    public void init(String[] stringArray) throws IllegalPredicateArgumentException {
        if (stringArray.length == 0) {
            throw new IllegalPredicateArgumentException("At least one argument is expected");
        }
        if (stringArray.length > 3) {
            throw new IllegalPredicateArgumentException("Maximum three arguments are expected");
        }
        this.startTime = this.parseTime(stringArray[0]);
        this.endTime = stringArray.length > 1 ? this.parseTime(stringArray[1]) : null;
        this.timeZone = stringArray.length > 2 ? this.parseTimeZone(stringArray[2]) : null;
    }

    private TimeOfDay parseTime(String string) throws IllegalPredicateArgumentException {
        return (TimeOfDay)arguments[0].parseExprValue(string);
    }

    private TimeZone parseTimeZone(String string) throws IllegalPredicateArgumentException {
        return (TimeZone)arguments[2].parseExprValue(string);
    }

    public boolean evaluate(Subject subject, Resource resource, ContextHandler contextHandler) {
        if (this.startTime == null && this.endTime == null) {
            return false;
        }
        TimeZone timeZone = this.timeZone == null ? TimeZone.getDefault() : this.timeZone;
        Calendar calendar = Calendar.getInstance(timeZone);
        int n = (calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13)) * 1000;
        int n2 = this.startTime.getTime();
        if (this.endTime == null) {
            return n >= n2;
        }
        int n3 = this.endTime.getTime();
        return n2 <= n3 ? n >= n2 && n < n3 : n >= n2 || n < n3;
    }

    public String getVersion() {
        return VERSION;
    }

    public int getArgumentCount() {
        return arguments.length;
    }

    public PredicateArgument getArgument(int n) {
        return arguments[n];
    }
}

