/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import weblogic.entitlement.rules.BasePredicateArgument;
import weblogic.entitlement.rules.Localizer;
import weblogic.entitlement.rules.TimeOfDay;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;

public class TimePredicateArgument
extends BasePredicateArgument {
    public static String TimePredicateArgumentName = "TimePredicateArgumentName";
    public static String TimePredicateStartTimeArgumentName = "TimePredicateStartTimeArgumentName";
    public static String TimePredicateEndTimeArgumentName = "TimePredicateEndTimeArgumentName";

    public TimePredicateArgument() {
        this("TimePredicateArgumentName", "TimePredicateArgumentDescription", null);
    }

    public TimePredicateArgument(String string, String string2, TimeOfDay timeOfDay) {
        super(string, string2, TimeOfDay.class, timeOfDay);
    }

    public Object parseValue(String string, Locale locale) throws IllegalPredicateArgumentException {
        DateFormat dateFormat = DateFormat.getTimeInstance(2, locale);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateFormat.setLenient(false);
        try {
            Date date = dateFormat.parse(string);
            return new TimeOfDay((int)date.getTime());
        }
        catch (Exception exception) {
            throw new IllegalPredicateArgumentException(exception.getMessage());
        }
    }

    public String formatValue(Object object, Locale locale) throws IllegalPredicateArgumentException {
        this.validateValue(object, locale);
        DateFormat dateFormat = DateFormat.getTimeInstance(2);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(new Date(((TimeOfDay)object).getTime()));
    }

    public Object parseExprValue(String string) throws IllegalPredicateArgumentException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        if (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken().trim());
            if (stringTokenizer.hasMoreTokens()) {
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (stringTokenizer.hasMoreTokens()) {
                    n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
                    if (stringTokenizer.hasMoreTokens()) {
                        throw new IllegalPredicateArgumentException("Unexpected time format");
                    }
                }
            }
        }
        try {
            return new TimeOfDay(n, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalPredicateArgumentException(illegalArgumentException.getMessage());
        }
    }

    public String formatExprValue(Object object) throws IllegalPredicateArgumentException {
        this.validateValue(object, null);
        TimeOfDay timeOfDay = (TimeOfDay)object;
        return timeOfDay.getHours() + ":" + timeOfDay.getMinutes() + ":" + timeOfDay.getSeconds();
    }

    public static void main(String[] stringArray) throws Exception {
        TimePredicateArgument.test(new TimePredicateArgument(), stringArray[0]);
    }

    public String getDescription(Locale locale) {
        if (this.displayNameId.equals(TimePredicateArgumentName)) {
            return this.getDescription(Localizer.getText("TimePredicateArgumentDescription", locale), locale);
        }
        if (this.displayNameId.equals(TimePredicateStartTimeArgumentName)) {
            return this.getDescription(Localizer.getText("TimePredicateStartTimeArgumentDescription", locale), locale);
        }
        return this.getDescription(Localizer.getText("TimePredicateEndTimeArgumentDescription", locale), locale);
    }

    public String getDescription(String string, Locale locale) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getFormatedTimePattern(locale, 2);
        arrayList.add(string2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        gregorianCalendar.set(10, 20);
        gregorianCalendar.set(12, 45);
        gregorianCalendar.set(13, 35);
        gregorianCalendar.set(9, 0);
        Date date = new Date(gregorianCalendar.getTimeInMillis());
        arrayList.add(this.getFormatedDateString(this.getTimePattern(locale), locale, date));
        return this.parseMessage(new StringBuffer(string), arrayList);
    }
}

