/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.rules;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import weblogic.entitlement.rules.BasePredicateArgument;
import weblogic.entitlement.rules.Localizer;
import weblogic.security.providers.authorization.IllegalPredicateArgumentException;

public class TimeZonePredicateArgument
extends BasePredicateArgument {
    public TimeZonePredicateArgument() {
        this("TimeZonePredicateArgumentName", "TimeZonePredicateArgumentDescription", (String)null, true);
    }

    public TimeZonePredicateArgument(String string, String string2, String string3, boolean bl) {
        super(string, string2, TimeZone.class, string3, bl);
    }

    public Object parseValue(String string, Locale locale) throws IllegalPredicateArgumentException {
        TimeZone timeZone = TimeZone.getTimeZone(string);
        if (timeZone.getRawOffset() == 0) {
            if (string == null || !string.startsWith("GMT")) {
                String string2 = Localizer.getText("InvalidTimeZoneFormat", locale);
                throw new IllegalPredicateArgumentException(string2);
            }
            if (string.length() > 3) {
                char c = string.charAt(3);
                if (c != '-' && c != '+') {
                    String string3 = Localizer.getText("InvalidTimeZoneFormat", locale);
                    throw new IllegalPredicateArgumentException(string3);
                }
                int n = 0;
                for (int i = 4; i < string.length(); ++i) {
                    char c2 = string.charAt(i);
                    if (c2 != '0' && c2 != ':') {
                        String string4 = Localizer.getText("InvalidTimeZoneFormat", locale);
                        throw new IllegalPredicateArgumentException(string4);
                    }
                    if (c2 != ':' || ++n <= 1) continue;
                    String string5 = Localizer.getText("InvalidTimeZoneFormat", locale);
                    throw new IllegalPredicateArgumentException(string5);
                }
            }
        }
        return timeZone;
    }

    public String formatValue(Object object, Locale locale) throws IllegalPredicateArgumentException {
        super.validateValue(object, locale);
        TimeZone timeZone = (TimeZone)object;
        return timeZone.getDisplayName(false, 0, locale);
    }

    public static void main(String[] stringArray) throws Exception {
        TimeZonePredicateArgument.test(new TimeZonePredicateArgument(), stringArray[0]);
    }

    public String getDescription(Locale locale) {
        return this.getDescription(Localizer.getText("TimeZonePredicateArgumentDescription", locale), locale);
    }

    public String getDescription(String string, Locale locale) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getFormatedTimePattern(locale);
        arrayList.add(string2);
        arrayList.add(string2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        gregorianCalendar.set(10, 5);
        gregorianCalendar.set(12, 0);
        Date date = new Date(gregorianCalendar.getTimeInMillis());
        arrayList.add(this.getFormatedDateString(string2, locale, date));
        return this.parseMessage(new StringBuffer(string), arrayList);
    }

    public String getFormatedTimePattern(Locale locale) {
        DateFormat dateFormat = DateFormat.getTimeInstance(3, locale);
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormat;
        String string = simpleDateFormat.toPattern();
        StringBuffer stringBuffer = new StringBuffer(simpleDateFormat.toPattern());
        int n = stringBuffer.indexOf("a");
        if (n > 0) {
            stringBuffer = stringBuffer.delete(n - 1, n + 1);
        }
        return stringBuffer.toString();
    }
}

