/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import weblogic.entitlement.data.EResource;
import weblogic.entitlement.data.ERole;
import weblogic.entitlement.data.ERoleId;
import weblogic.entitlement.data.ldap.EData;
import weblogic.entitlement.expression.EExpression;
import weblogic.entitlement.parser.Parser;
import weblogic.entitlement.util.Escaping;
import weblogic.entitlement.util.XMLProcessor;
import weblogic.utils.encoders.BASE64Encoder;

public class LdiftWriter {
    private static Escaping escaper = EData.escaper;
    private static BASE64Encoder b64Encoder = new BASE64Encoder();
    private static final String ROLE_TYPE = "ERole";
    private static final String RESOURCE_TYPE = "EResource";
    private static final String PREDICATE_TYPE = "EPredicate";
    private static final String PROFILE_TYPE = "EProfile";
    private static final String PROF_DEF_TYPE = "EProfileDefinition";
    private static final String PROF_INST_TYPE = "EProfileInstance";
    private static String[] TYPES = new String[]{"ERole", "EResource", "EPredicate", "EProfile", "EProfileDefinition", "EProfileInstance"};
    private Writer out;

    public LdiftWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("null writer");
        }
        this.out = writer;
    }

    public void writeHeader() throws IOException {
        this.out.write("dn: dc=@domain@\n");
        this.out.write("objectclass: top\n");
        this.out.write("objectclass: domain\n");
        this.out.write("dc: @domain@\n");
        this.out.write("\n");
        this.out.write("dn: ou=@realm@,dc=@domain@\n");
        this.out.write("objectclass: top\n");
        this.out.write("objectclass: organizationalUnit\n");
        this.out.write("ou: @realm@\n");
        for (int i = 0; i < TYPES.length; ++i) {
            this.out.write("\n");
            this.out.write("dn: ou=" + TYPES[i] + ",ou=@realm@,dc=@domain@\n");
            this.out.write("objectclass: top\n");
            this.out.write("objectclass: organizationalUnit\n");
            this.out.write("ou: " + TYPES[i] + "\n");
        }
    }

    public void write(EResource eResource) throws IOException {
        String string = escaper.escapeString(eResource.getName());
        this.write(RESOURCE_TYPE, string, eResource.getExpression(), null);
    }

    public void write(ERole eRole, String string) throws IOException {
        String string2 = EData.PK2Name((ERoleId)eRole.getPrimaryKey());
        this.write(ROLE_TYPE, string2, eRole.getExpression(), string);
    }

    public void writePredicate(String string) throws IOException {
        this.write(PREDICATE_TYPE, string);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void writeln() throws IOException {
        this.out.write(10);
    }

    private void write(String string, String string2) throws IOException {
        this.out.write("\n");
        this.out.write("dn: cn=" + string2 + ",ou=" + string + ",ou=@realm@,dc=@domain@\n");
        this.out.write("objectclass: top\n");
        this.out.write("objectclass: " + string + "\n");
        this.out.write("cn: " + string2 + "\n");
    }

    private void write(String string, String string2, EExpression eExpression, String string3) throws IOException {
        this.write(string, string2);
        this.out.write("EExpr:: " + LdiftWriter.uuEncode(eExpression) + "\n");
        if (string3 != null && string3.length() > 0) {
            this.out.write("EAux:: " + LdiftWriter.uuEncode(string3) + "\n");
        }
    }

    private static String uuEncode(EExpression eExpression) throws UnsupportedEncodingException {
        String string = eExpression == null ? "" : eExpression.serialize();
        return b64Encoder.encodeBuffer(string.getBytes("UTF8"));
    }

    private static String uuEncode(String string) throws UnsupportedEncodingException {
        String string2 = string == null ? "" : string;
        return b64Encoder.encodeBuffer(string2.getBytes("UTF8"));
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.out.println("LDIFT Writer: Convert XML doc describing resource and role policies to LDIFT used in WLS7.x bootstrap");
            System.out.println("Usage: java weblogic.entitlement.util.LdiftWriter <xml_in_file> <ldift_out_file>");
            throw new IllegalArgumentException("Number of arguments should be 2");
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        XMLProcessor xMLProcessor = null;
        FileInputStream fileInputStream = null;
        LdiftWriter ldiftWriter = null;
        try {
            fileInputStream = new FileInputStream(string);
            xMLProcessor = new XMLProcessor(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Cannot find xml file: " + string);
            throw new IllegalArgumentException("Invalid xml file: " + string);
        }
        catch (Exception exception) {
            System.out.println("Failed to read policies from xml file: " + string + ". Make sure file xml format is valid\n" + exception.getMessage());
            throw new IllegalArgumentException("Invalid xml file: " + string);
        }
        try {
            ldiftWriter = new LdiftWriter(new FileWriter(string2));
        }
        catch (Exception exception) {
            System.out.println("Failed to open output file: " + string2);
            throw new IllegalArgumentException("Invalid output file: " + string2);
        }
        try {
            ldiftWriter.writeHeader();
            xMLProcessor.writeElements(ldiftWriter);
            ldiftWriter.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to convert policies to ldift format. Make sure " + string + " contains valid policies.\n" + exception.getMessage());
            throw new IllegalArgumentException("Invalid xml file: " + string);
        }
    }

    public static void unitTest(String string) throws Exception {
        int n;
        EResource[] eResourceArray = new EResource[]{new EResource("myresource:1", null), new EResource("myresource:1", Parser.parseResourceExpression("Usr(me)"))};
        ERole[] eRoleArray = new ERole[]{new ERole("myresource:1", "myrole@1", Parser.parseRoleExpression("Grp(me)")), new ERole("myresource:1", "myrole@1", Parser.parseRoleExpression("Grp(me)"))};
        String[] stringArray = new String[]{"weblogic.entitlement.rules.TimePredicate", "weblogic.entitlement.rules.InDevelopmentMode"};
        LdiftWriter ldiftWriter = new LdiftWriter(new FileWriter(string));
        ldiftWriter.writeHeader();
        for (n = 0; n < eResourceArray.length; ++n) {
            ldiftWriter.write(eResourceArray[n]);
        }
        for (n = 0; n < eRoleArray.length; ++n) {
            ldiftWriter.write(eRoleArray[n], "aux");
        }
        for (n = 0; n < stringArray.length; ++n) {
            ldiftWriter.writePredicate(stringArray[n]);
        }
        ldiftWriter.close();
    }
}

