/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import weblogic.entitlement.util.EmptyIterator;

public class OrderedHashMap
extends HashMap {
    private Entry mFirst;
    private Entry mLast;
    private transient int modCount = 0;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;

    public OrderedHashMap() {
    }

    public OrderedHashMap(int n) {
        super(n);
    }

    public OrderedHashMap(int n, float f) {
        super(n, f);
    }

    public OrderedHashMap(Map map) {
        this(Math.max(2 * map.size(), 11));
        this.putAll(map);
    }

    public OrderedHashMap(OrderedHashMap orderedHashMap) {
        this(Math.max(2 * orderedHashMap.size(), 11));
        this.putAll((Map)orderedHashMap);
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            Entry entry = this.mFirst;
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = this.mFirst;
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Object get(Object object) {
        Entry entry = (Entry)super.get(object);
        return entry == null ? null : entry.value;
    }

    public Map.Entry getFirst() {
        return this.mFirst;
    }

    public Map.Entry getLast() {
        return this.mLast;
    }

    public Object put(Object object, Object object2) {
        return this.put(object, object2, false, false);
    }

    public Object putFirst(Object object, Object object2) {
        return this.put(object, object2, true, true);
    }

    public Object putLast(Object object, Object object2) {
        return this.put(object, object2, false, true);
    }

    public Object put(Object object, Object object2, boolean bl, boolean bl2) {
        Object object3 = null;
        Entry entry = (Entry)super.get(object);
        if (entry == null) {
            ++this.modCount;
            entry = new Entry(object, object2);
            super.put(object, entry);
            if (bl) {
                this.addFirstListEntry(entry);
            } else {
                this.addLastListEntry(entry);
            }
        } else {
            object3 = entry.value;
            entry.value = object2;
            if (bl2) {
                if (bl) {
                    this.moveListEntryToFirst(entry);
                } else {
                    this.moveListEntryToLast(entry);
                }
            }
        }
        return object3;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), false, false);
        }
    }

    public Object moveToFirst(Object object) {
        Entry entry = (Entry)super.get(object);
        if (entry != null && entry != this.mFirst) {
            ++this.modCount;
            this.moveListEntryToFirst(entry);
        }
        return entry == null ? null : entry.value;
    }

    public Object moveToLast(Object object) {
        Entry entry = (Entry)super.get(object);
        if (entry != null && entry != this.mLast) {
            ++this.modCount;
            this.moveListEntryToLast(entry);
        }
        return entry == null ? null : entry.value;
    }

    public Object remove(Object object) {
        if (super.containsKey(object)) {
            ++this.modCount;
        }
        Object object2 = null;
        Entry entry = (Entry)super.remove(object);
        if (entry != null) {
            object2 = entry.value;
            this.removeListEntry(entry);
        }
        return object2;
    }

    public Map.Entry removeFirst() {
        if (this.mFirst != null) {
            ++this.modCount;
            super.remove(this.mFirst.key);
            this.removeListEntry(this.mFirst);
        }
        return this.mFirst;
    }

    public Map.Entry removeLast() {
        if (this.mLast != null) {
            ++this.modCount;
            super.remove(this.mLast.key);
            this.removeListEntry(this.mLast);
        }
        return this.mLast;
    }

    public void clear() {
        ++this.modCount;
        super.clear();
        this.mLast = null;
        this.mFirst = null;
    }

    public Object clone() {
        return new OrderedHashMap(this);
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    if (OrderedHashMap.this.mFirst == null) {
                        return EmptyIterator.INSTANCE;
                    }
                    return new KeyIterator(OrderedHashMap.this.mFirst);
                }

                public int size() {
                    return OrderedHashMap.this.size();
                }

                public boolean contains(Object object) {
                    return OrderedHashMap.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = OrderedHashMap.this.size();
                    OrderedHashMap.this.remove(object);
                    return OrderedHashMap.this.size() != n;
                }

                public void clear() {
                    OrderedHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    if (OrderedHashMap.this.mFirst == null) {
                        return EmptyIterator.INSTANCE;
                    }
                    return new ValueIterator(OrderedHashMap.this.mFirst);
                }

                public int size() {
                    return OrderedHashMap.this.size();
                }

                public boolean contains(Object object) {
                    return OrderedHashMap.this.containsValue(object);
                }

                public void clear() {
                    OrderedHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    if (OrderedHashMap.this.mFirst == null) {
                        return EmptyIterator.INSTANCE;
                    }
                    return new EntryIterator(OrderedHashMap.this.mFirst);
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    return OrderedHashMap.this.containsKey(((Map.Entry)object).getKey());
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    int n = OrderedHashMap.this.size();
                    OrderedHashMap.this.remove(((Map.Entry)object).getKey());
                    return n != OrderedHashMap.this.size();
                }

                public int size() {
                    return OrderedHashMap.this.size();
                }

                public void clear() {
                    OrderedHashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    public Iterator iterator() {
        if (this.mFirst == null) {
            return EmptyIterator.INSTANCE;
        }
        return new EntryIterator(this.mFirst);
    }

    private void moveListEntryToLast(Entry entry) {
        if (entry != this.mLast) {
            this.removeListEntry(entry);
            this.addLastListEntry(entry);
        }
    }

    private void moveListEntryToFirst(Entry entry) {
        if (entry != this.mFirst) {
            this.removeListEntry(entry);
            this.addFirstListEntry(entry);
        }
    }

    private void addLastListEntry(Entry entry) {
        if (this.mLast == null) {
            this.mFirst = this.mLast = entry;
        } else {
            this.mLast.next = entry;
            entry.prev = this.mLast;
            this.mLast = entry;
        }
    }

    private void addFirstListEntry(Entry entry) {
        if (this.mFirst == null) {
            this.mFirst = this.mLast = entry;
        } else {
            this.mFirst.prev = entry;
            entry.next = this.mFirst;
            this.mFirst = entry;
        }
    }

    private void removeListEntry(Entry entry) {
        Entry entry2 = entry.prev;
        Entry entry3 = entry.next;
        if (entry2 == null) {
            this.mFirst = entry3;
        } else {
            entry2.next = entry3;
        }
        if (entry3 == null) {
            this.mLast = entry2;
        } else {
            entry3.prev = entry2;
        }
        entry.prev = null;
        entry.next = null;
    }

    private class Entry
    implements Map.Entry {
        Entry next;
        Entry prev;
        Object key;
        Object value;

        Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
            this.prev = null;
            this.next = null;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public Object getKey() {
            return this.key;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public int hashCode() {
            int n = 0;
            if (this.key != null) {
                n ^= this.key.hashCode();
            }
            if (this.value != null) {
                n ^= this.value.hashCode();
            }
            return n;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class ValueIterator
    extends EntryIterator {
        public ValueIterator(Entry entry) {
            super(entry);
        }

        public Object next() {
            Entry entry = (Entry)super.next();
            return entry.value;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        public KeyIterator(Entry entry) {
            super(entry);
        }

        public Object next() {
            Entry entry = (Entry)super.next();
            return entry.key;
        }
    }

    private class EntryIterator
    implements Iterator {
        private Entry entry = null;
        private Entry lastReturned = null;
        private int expectedModCount = OrderedHashMap.access$100(OrderedHashMap.this);

        public EntryIterator(Entry entry) {
            this.entry = entry;
        }

        public boolean hasNext() {
            return this.entry != null;
        }

        public Object next() {
            if (OrderedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (OrderedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ++this.expectedModCount;
            OrderedHashMap.this.remove(this.lastReturned.key);
            if (OrderedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

