/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.util;

import java.util.Iterator;
import java.util.Map;
import weblogic.entitlement.util.LRUCache;

public class TTLLRUCache
extends LRUCache {
    private long timeToLive = 0L;

    public TTLLRUCache() {
    }

    public TTLLRUCache(int n) {
        super(n);
    }

    public TTLLRUCache(int n, int n2) {
        super(n);
        this.setTimeToLive(n2);
    }

    public void setTimeToLive(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Seconds to live cannot be negative");
        }
        this.timeToLive = n * 1000;
    }

    public Object put(Object object, Object object2) {
        TTLEntry tTLEntry = (TTLEntry)super.put(object, new TTLEntry(object2));
        return tTLEntry == null ? null : tTLEntry.value;
    }

    public Object get(Object object) {
        return this.extractValue(object, (TTLEntry)super.get(object));
    }

    public Object lookup(Object object) {
        return this.extractValue(object, (TTLEntry)super.lookup(object));
    }

    private Object extractValue(Object object, TTLEntry tTLEntry) {
        Object object2 = null;
        if (tTLEntry != null) {
            if (tTLEntry.isValid()) {
                object2 = tTLEntry.value;
            } else {
                super.remove(object);
            }
        }
        return object2;
    }

    public boolean containsKey(Object object) {
        return this.lookup(object) != null;
    }

    public boolean containsValue(Object object) {
        return super.containsValue(new TTLEntry(object));
    }

    public Map.Entry remove() {
        Map.Entry entry = super.remove();
        if (entry != null) {
            entry.setValue(((TTLEntry)entry.getValue()).value);
        }
        return entry;
    }

    public Object remove(Object object) {
        TTLEntry tTLEntry = (TTLEntry)super.remove(object);
        return tTLEntry == null ? null : tTLEntry.value;
    }

    public Iterator iterator() {
        return new TTLIterator();
    }

    private class Entry
    implements Map.Entry {
        Object key;
        Object value;

        Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public Object getKey() {
            return this.key;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public int hashCode() {
            int n = 0;
            if (this.key != null) {
                n ^= this.key.hashCode();
            }
            if (this.value != null) {
                n ^= this.value.hashCode();
            }
            return n;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class TTLIterator
    implements Iterator {
        Iterator iterator;

        public TTLIterator() {
            this.iterator = TTLLRUCache.this.iterator();
        }

        public Object next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            if (entry != null) {
                entry = new Entry(entry.getKey(), ((TTLEntry)entry.getValue()).value);
            }
            return entry;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public void remove() {
            this.iterator.remove();
        }
    }

    private class TTLEntry {
        public Object value;
        public long timeStamp;

        public TTLEntry(Object object) {
            this.value = object;
            this.timeStamp = System.currentTimeMillis();
        }

        public boolean isValid() {
            return TTLLRUCache.this.timeToLive == 0L || System.currentTimeMillis() - this.timeStamp < TTLLRUCache.this.timeToLive;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof TTLEntry)) {
                return false;
            }
            TTLEntry tTLEntry = (TTLEntry)object;
            return this.value == null ? tTLEntry.value == null : this.value.equals(tTLEntry);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

