/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.entitlement.util.Escaping;

public class TextFilter {
    public static final char ALL_CHAR = '*';
    public static final char ESCAPE_CHAR = '\\';
    public static final Token ALL_STRINGS_TOKEN = new SpecialToken('*');
    private List mTokens = null;

    public TextFilter() {
        this.mTokens = new ArrayList();
    }

    public TextFilter(String string) {
        char[] cArray = string.toCharArray();
        this.mTokens = new ArrayList(TextFilter.countTokens(cArray));
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '*') {
                if (stringBuffer.length() > 0) {
                    this.mTokens.add(new Token(stringBuffer.toString()));
                }
                this.mTokens.add(ALL_STRINGS_TOKEN);
                stringBuffer.setLength(0);
                continue;
            }
            if (cArray[i] == '\\') {
                if (++i >= cArray.length) continue;
                stringBuffer.append(cArray[i]);
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        if (stringBuffer.length() > 0) {
            this.mTokens.add(new Token(stringBuffer.toString()));
        }
    }

    public int getTokenCount() {
        return this.mTokens.size();
    }

    public Token getToken(int n) {
        return (Token)this.mTokens.get(n);
    }

    public void add(Token token) {
        this.mTokens.add(token);
    }

    public void add(String string) {
        this.add(new Token(string));
    }

    public Iterator tokens() {
        return this.mTokens.iterator();
    }

    public Token remove(int n) {
        return (Token)this.mTokens.remove(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getTokenCount();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.getToken(i));
        }
        return stringBuffer.toString();
    }

    public String toString(Escaping escaping, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getTokenCount();
        for (int i = 0; i < n; ++i) {
            Token token = this.getToken(i);
            if (token == ALL_STRINGS_TOKEN) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(escaping.escapeString(token.getText()));
        }
        return stringBuffer.toString();
    }

    public boolean accept(String string) {
        return this.accept(string, 0, this.getTokenCount());
    }

    private boolean accept(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            Token token = this.getToken(i);
            if (token.isSpecial()) {
                if (token == ALL_STRINGS_TOKEN) {
                    int n3 = i + 1;
                    int n4 = string.length();
                    for (int j = 0; j < n4; ++j) {
                        if (!this.accept(string.substring(j), n3, n2)) continue;
                        return true;
                    }
                    return this.accept("", n3, n2);
                }
                throw new RuntimeException("Unknown token");
            }
            String string2 = token.getText();
            if (!string.startsWith(string2)) {
                return false;
            }
            string = string.substring(string2.length());
        }
        return string.length() == 0;
    }

    private static int countTokens(char[] cArray) {
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '*') {
                ++n;
                bl = false;
                continue;
            }
            if (cArray[i] == '\\' && cArray.length >= ++i) break;
            if (bl) continue;
            ++n;
            bl = true;
        }
        return n;
    }

    private static class SpecialToken
    extends Token {
        private SpecialToken(char c) {
            super(String.valueOf(c));
        }

        public boolean isSpecial() {
            return true;
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public String toString() {
            return this.getText();
        }
    }

    public static class Token {
        private String text = null;

        public Token(String string) {
            if (string.length() == 0) {
                throw new IllegalArgumentException("no text");
            }
            this.text = string;
        }

        public String getText() {
            return this.text;
        }

        public boolean isSpecial() {
            return false;
        }

        public boolean equals(Object object) {
            if (object instanceof Token) {
                Token token = (Token)object;
                return !token.isSpecial() && this.text.equals(token.getText());
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = null;
            char[] cArray = this.text.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '*' || cArray[i] == '\\') {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(cArray.length * 2 - i);
                        stringBuffer.append(this.text.substring(0, i));
                    }
                    stringBuffer.append('\\');
                }
                if (stringBuffer == null) continue;
                stringBuffer.append(cArray[i]);
            }
            return stringBuffer != null ? stringBuffer.toString() : this.text;
        }
    }
}

