/*
 * Decompiled with CFR 0.152.
 */
package weblogic.entitlement.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import weblogic.entitlement.data.EResource;
import weblogic.entitlement.data.ERole;
import weblogic.entitlement.expression.EExpression;
import weblogic.entitlement.parser.Parser;
import weblogic.entitlement.util.LdiftWriter;
import weblogic.security.service.MBeanResource;
import weblogic.security.spi.Resource;

public class XMLProcessor {
    private static String RESOURCE_TAG = "resource";
    private static String ROLE_TAG = "role";
    private static String PREDICATE_TAG = "predicate";
    private static String EEXPR_TAG = "eexpr";
    private static String NAME_TAG = "name";
    private static String PARAM_TAG = "param";
    private static String TYPE_TAG = "type";
    private static String VALUE_TAG = "value";
    private static String AUX_TAG = "aux";
    private Document doc = null;

    public XMLProcessor(InputStream inputStream) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setCoalescing(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ErrorHandler(){

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                throw new SAXException("Fatal Error: " + this.getParseExceptionInfo(sAXParseException));
            }

            public void error(SAXParseException sAXParseException) throws SAXException {
                throw new SAXException("Error: " + this.getParseExceptionInfo(sAXParseException));
            }

            public void warning(SAXParseException sAXParseException) throws SAXException {
            }

            private String getParseExceptionInfo(SAXParseException sAXParseException) {
                return "URI=" + sAXParseException.getSystemId() + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            }
        });
        this.doc = documentBuilder.parse(inputStream);
    }

    public void writeElements(LdiftWriter ldiftWriter) throws Exception {
        NodeList nodeList = this.doc.getElementsByTagName(RESOURCE_TAG);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            String string = XMLProcessor.getResourceId(element);
            EExpression eExpression = Parser.parseResourceExpression(element.getAttribute(EEXPR_TAG));
            if (string.length() != 0 && eExpression != null) {
                ldiftWriter.write(new EResource(string, eExpression));
            }
            NodeList nodeList2 = element.getElementsByTagName(ROLE_TAG);
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Element element2 = (Element)nodeList2.item(j);
                String string2 = element2.getAttribute(NAME_TAG);
                String string3 = element2.getAttribute(EEXPR_TAG);
                String string4 = element2.getAttribute(AUX_TAG);
                EExpression eExpression2 = Parser.parseResourceExpression(string3);
                ldiftWriter.write(new ERole(string, string2, eExpression2), string4);
            }
        }
        NodeList nodeList3 = this.doc.getElementsByTagName(PREDICATE_TAG);
        int n3 = nodeList3.getLength();
        for (n = 0; n < n3; ++n) {
            ldiftWriter.writePredicate(((Element)nodeList3.item(n)).getAttribute(NAME_TAG));
        }
    }

    private static String getResourceId(Element element) throws Exception {
        Object object;
        String string = element.getAttribute(NAME_TAG).trim();
        if (string.length() == 0) {
            return "";
        }
        NodeList nodeList = element.getElementsByTagName(PARAM_TAG);
        int n = nodeList.getLength();
        Class[] classArray = new Class[n];
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            object = (Element)nodeList.item(i);
            classArray[i] = XMLProcessor.getClass(object.getAttribute(TYPE_TAG));
            objectArray[i] = XMLProcessor.getValue(classArray[i], object.getAttribute(VALUE_TAG));
        }
        Resource resource = null;
        try {
            object = Class.forName(string);
            resource = (Resource)((Class)object).getConstructor(classArray).newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Exception("Cannot find resource class: " + string);
        }
        catch (Exception exception) {
            String string2 = objectArray.length > 0 ? String.valueOf(objectArray[0]) : "none";
            for (int i = 1; i < objectArray.length; ++i) {
                string2 = string2 + ", " + objectArray[i];
            }
            throw new Exception("Cannot instantiate resource of type: " + string + " with parameters: " + string2);
        }
        return resource.toString();
    }

    private static Class getClass(String string) throws ClassNotFoundException {
        try {
            if (string.equals("weblogic.security.service.MBeanResource.ActionType")) {
                return MBeanResource.ActionType.class;
            }
            if (string.equals("java.lang.String[]")) {
                return String[].class;
            }
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotFoundException("Cannot instantiate class with the name: " + string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object getValue(Class clazz, String string) throws Exception {
        if (string == null) return null;
        if (string.equalsIgnoreCase("null")) {
            return null;
        }
        MBeanResource.ActionType actionType = string;
        if (clazz.isArray()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            MBeanResource.ActionType actionType2 = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                actionType2[n2] = stringTokenizer.nextToken().trim();
                ++n2;
            }
            return actionType2;
        }
        if (MBeanResource.ActionType.class.isAssignableFrom(clazz)) {
            if (string.equalsIgnoreCase("find")) {
                return MBeanResource.ActionType.FIND;
            }
            if (string.equalsIgnoreCase("register")) {
                return MBeanResource.ActionType.REGISTER;
            }
            if (string.equalsIgnoreCase("unregister")) {
                return MBeanResource.ActionType.UNREGISTER;
            }
            if (string.equalsIgnoreCase("write")) {
                return MBeanResource.ActionType.WRITE;
            }
            if (string.equalsIgnoreCase("read")) {
                return MBeanResource.ActionType.READ;
            }
            if (!string.equalsIgnoreCase("execute")) throw new Exception("Unknown MBeanResource.ActionType: " + string);
            return MBeanResource.ActionType.EXECUTE;
        }
        if (!Hashtable.class.isAssignableFrom(clazz)) return actionType;
        return new Hashtable();
    }
}

