/*
 * Decompiled with CFR 0.152.
 */
package weblogic.health;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.cluster.migration.MTCustomValidator;
import weblogic.health.HealthDebug;
import weblogic.health.HealthFeedback;
import weblogic.health.HealthFeedbackCallback;
import weblogic.health.HealthLogger;
import weblogic.health.HealthState;
import weblogic.health.MonitoredSystemTableEntry;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.t3.srvr.T3Srvr;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.work.WorkManagerFactory;

public final class HealthMonitorService
extends AbstractServerService
implements TimerListener {
    private static ArrayList callbackListeners = new ArrayList();
    private static final HashMap monSysTbl = new HashMap();
    private TimerManager timerManager;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void start() {
        this.timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("HealthMonitorTask", WorkManagerFactory.getInstance().getSystem());
        int n = ManagementService.getRuntimeAccess(kernelId).getServer().getHealthCheckIntervalSeconds();
        this.timerManager.scheduleAtFixedRate((TimerListener)this, (long)(n * 1000), (long)(n * 1000));
    }

    public void stop() {
        this.shutdown();
    }

    public void halt() {
        this.shutdown();
    }

    private void shutdown() {
        if (this.timerManager != null) {
            this.timerManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String string, HealthFeedback healthFeedback, boolean bl) {
        HealthDebug.log("> HealthMonitorService::register keyArg = " + string);
        Debug.assertion((string != null && healthFeedback != null ? 1 : 0) != 0);
        if (healthFeedback instanceof RuntimeMBean) {
            HashMap hashMap = monSysTbl;
            synchronized (hashMap) {
                monSysTbl.put(string.trim(), new MonitoredSystemTableEntry(string, (RuntimeMBean)healthFeedback, bl));
            }
        }
        HashMap hashMap = monSysTbl;
        synchronized (hashMap) {
            monSysTbl.put(string.trim(), new MonitoredSystemTableEntry(string, healthFeedback, bl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerForCallback(HealthFeedbackCallback healthFeedbackCallback) {
        ArrayList arrayList = callbackListeners;
        synchronized (arrayList) {
            callbackListeners.add(healthFeedbackCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterForCallback(HealthFeedbackCallback healthFeedbackCallback) {
        ArrayList arrayList = callbackListeners;
        synchronized (arrayList) {
            callbackListeners.remove(healthFeedbackCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyListeners(HealthState healthState) {
        ArrayList arrayList = callbackListeners;
        synchronized (arrayList) {
            Iterator iterator = callbackListeners.iterator();
            while (iterator.hasNext()) {
                ((HealthFeedbackCallback)iterator.next()).healthStateChange(healthState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(String string) {
        HealthDebug.log("> HealthMonitorService::unregister keyArg = " + string);
        Debug.assertion((string != null ? 1 : 0) != 0);
        HashMap hashMap = monSysTbl;
        synchronized (hashMap) {
            monSysTbl.remove(string);
        }
    }

    public static synchronized void subsystemFailedNonFatal(final String string, final String string2) {
        if (MTCustomValidator.ASM_JMS_DISABLED) {
            HealthMonitorService.subsystemFailed(string, string2);
            return;
        }
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                HealthLogger.logNonCriticalSubsystemFailedWithReason((String)string, (String)string2);
                MonitoredSystemTableEntry monitoredSystemTableEntry = (MonitoredSystemTableEntry)monSysTbl.get(string);
                if (monitoredSystemTableEntry == null) {
                    HealthLogger.logNoRegisteredSubsystem((String)string, (String)string2);
                    return;
                }
                monSysTbl.get(string);
                HealthState healthState = monitoredSystemTableEntry.getHealthFeedback().getHealthState();
                healthState.setSubsystemName(monitoredSystemTableEntry.getKey());
                healthState.setCritical(monitoredSystemTableEntry.getIsCritical());
                healthState.setMBeanName(monitoredSystemTableEntry.getMBeanName());
                healthState.setMBeanType(monitoredSystemTableEntry.getMBeanType());
                HealthMonitorService.notifyListeners(healthState);
            }
        });
    }

    public static synchronized void subsystemFailed(final String string, final String string2) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                HealthLogger.logErrorSubsystemFailedWithReason((String)string, (String)string2);
                T3Srvr.getT3Srvr().failed("health of critical service '" + string + "' failed");
            }
        });
    }

    public static synchronized void subsystemFailedForceShutdown(final String string, final String string2) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                HealthLogger.logErrorSubsystemFailedWithReason((String)string, (String)string2);
                T3Srvr.getT3Srvr().failedForceShutdown("health of critical service '" + string + "' failed");
            }
        });
    }

    public static synchronized void panic(Throwable throwable) {
        if ("system-exit".equals(ManagementService.getRuntimeAccess(kernelId).getServer().getOverloadProtection().getPanicAction())) {
            T3Srvr.getT3Srvr().exitImmediately(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        HealthDebug.log("> HealthMonitorTask::run (10)");
        HashMap hashMap = monSysTbl;
        synchronized (hashMap) {
            if (monSysTbl.size() == 0) {
                return;
            }
            for (MonitoredSystemTableEntry monitoredSystemTableEntry : monSysTbl.values()) {
                HealthState healthState = monitoredSystemTableEntry.getHealthFeedback().getHealthState();
                healthState.setSubsystemName(monitoredSystemTableEntry.getKey());
                healthState.setCritical(monitoredSystemTableEntry.getIsCritical());
                healthState.setMBeanName(monitoredSystemTableEntry.getMBeanName());
                healthState.setMBeanType(monitoredSystemTableEntry.getMBeanType());
                HealthDebug.log("Health state of " + monitoredSystemTableEntry.getKey() + " is " + HealthState.mapToString(healthState.getState()));
                if (healthState.getState() == 3) {
                    HealthMonitorService.notifyListeners(healthState);
                }
                if (!monitoredSystemTableEntry.getIsCritical() || healthState.getState() != 3) continue;
                HealthLogger.logErrorSubsystemFailed((String)monitoredSystemTableEntry.getKey());
                T3Srvr.getT3Srvr().failed("health of critical service '" + monitoredSystemTableEntry.getKey() + "' failed");
                break;
            }
        }
        HealthDebug.log("< HealthMonitorTask::run (20)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HealthState[] getHealthStates() {
        HashMap hashMap = monSysTbl;
        synchronized (hashMap) {
            if (monSysTbl.size() == 0) {
                return null;
            }
            HealthState[] healthStateArray = new HealthState[monSysTbl.size()];
            int n = 0;
            for (MonitoredSystemTableEntry monitoredSystemTableEntry : monSysTbl.values()) {
                HealthState healthState = monitoredSystemTableEntry.getHealthFeedback().getHealthState();
                healthStateArray[n] = new HealthState(healthState.getState(), healthState.getReasonCode());
                healthStateArray[n].setSubsystemName(monitoredSystemTableEntry.getKey());
                healthStateArray[n].setCritical(monitoredSystemTableEntry.getIsCritical());
                healthStateArray[n].setMBeanName(monitoredSystemTableEntry.getMBeanName());
                healthStateArray[n].setMBeanType(monitoredSystemTableEntry.getMBeanType());
                ++n;
            }
            return healthStateArray;
        }
    }
}

