/*
 * Decompiled with CFR 0.152.
 */
package weblogic.health;

import java.io.Serializable;

public final class HealthState
implements Serializable {
    private static final long serialVersionUID = -8954060526499390055L;
    public static final int HEALTH_OK = 0;
    public static final int HEALTH_WARN = 1;
    public static final int HEALTH_CRITICAL = 2;
    public static final int HEALTH_FAILED = 3;
    public static final int HEALTH_OVERLOADED = 4;
    public static final String LOW_MEMORY_REASON = "server is low on memory";
    private static final String[] NULL_REASONS = new String[0];
    private final int state;
    private final String[] reasonCode;
    private String subsystemName;
    private static final int[] logicalSeverityOrder = new int[]{0, 1, 2, 4, 3};
    private boolean isCritical;
    private String mbeanName;
    private String mbeanType;

    public HealthState(int n) {
        this(n, NULL_REASONS);
    }

    public HealthState(int n, String string) {
        this.state = n;
        this.reasonCode = string == null ? NULL_REASONS : new String[]{string};
    }

    public HealthState(int n, String[] stringArray) {
        this.state = n;
        this.reasonCode = stringArray == null ? NULL_REASONS : stringArray;
    }

    public String getSubsystemName() {
        return this.subsystemName;
    }

    public int getState() {
        return this.state;
    }

    public int compareSeverityTo(HealthState healthState) {
        if (healthState.getState() == this.getState()) {
            return 0;
        }
        int n = logicalSeverityOrder[healthState.getState()];
        int n2 = logicalSeverityOrder[this.getState()];
        return n2 - n;
    }

    public String[] getReasonCode() {
        return this.reasonCode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Component:" + this.subsystemName + ",");
        stringBuffer.append("State:" + HealthState.mapToString(this.state) + ",");
        stringBuffer.append("MBean:" + this.mbeanName + ",");
        stringBuffer.append("ReasonCode:[");
        if (this.reasonCode != null && this.reasonCode.length > 0) {
            for (int i = 0; i < this.reasonCode.length - 1; ++i) {
                stringBuffer.append(this.reasonCode[i] + ",");
            }
            stringBuffer.append(this.reasonCode[this.reasonCode.length - 1]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String mapToString(int n) {
        switch (n) {
            case 0: {
                return "HEALTH_OK";
            }
            case 1: {
                return "HEALTH_WARN";
            }
            case 2: {
                return "HEALTH_CRITICAL";
            }
            case 3: {
                return "HEALTH_FAILED";
            }
            case 4: {
                return "HEALTH_OVERLOADED";
            }
        }
        return "UNKNOWN";
    }

    public void setSubsystemName(String string) {
        this.subsystemName = string;
    }

    public void setCritical(boolean bl) {
        this.isCritical = bl;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    public void setMBeanName(String string) {
        this.mbeanName = string;
    }

    public String getMBeanName() {
        return this.mbeanName;
    }

    public void setMBeanType(String string) {
        this.mbeanType = string;
    }

    public String getMBeanType() {
        return this.mbeanType;
    }
}

