/*
 * Decompiled with CFR 0.152.
 */
package weblogic.health;

import java.util.ArrayList;
import weblogic.health.MemoryEvent;
import weblogic.health.MemoryListener;
import weblogic.platform.GCListener;
import weblogic.platform.GarbageCollectionEvent;
import weblogic.platform.VM;

public final class LowMemoryNotificationService
implements GCListener {
    private static final boolean DEBUG = false;
    private static final int MINOR_GC_COUNT_THRESHOLD = 5;
    private static final MemoryEvent LOW_MEMORY_EVENT = new MemoryEvent(1);
    private static final MemoryEvent OK_MEMORY_EVENT = new MemoryEvent(0);
    private static final ArrayList list = new ArrayList();
    private static boolean initialized;
    private final int lowThreshold;
    private final int highThreshold;
    private boolean lowMemoryThresholdReached;
    private int consecutiveMinorGCCount;

    private LowMemoryNotificationService(int n, int n2) {
        this.lowThreshold = n;
        this.highThreshold = n2;
    }

    public static synchronized void addMemoryListener(MemoryListener memoryListener) {
        list.add(memoryListener);
    }

    public static synchronized void removeMemoryListener(MemoryListener memoryListener) {
        list.remove(memoryListener);
    }

    public static synchronized void initialize(int n, int n2) {
        if (initialized) {
            return;
        }
        VM.getVM().addGCListener((GCListener)new LowMemoryNotificationService(n, n2));
        initialized = true;
    }

    private static final synchronized void sendMemoryEvent(MemoryEvent memoryEvent) {
        for (MemoryListener memoryListener : list) {
            memoryListener.memoryChanged(memoryEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGarbageCollection(GarbageCollectionEvent garbageCollectionEvent) {
        if (garbageCollectionEvent == null) {
            return;
        }
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        int n = (int)(l * 100L / l2);
        LowMemoryNotificationService lowMemoryNotificationService = this;
        synchronized (lowMemoryNotificationService) {
            if (n < this.lowThreshold && !this.lowMemoryThresholdReached && this.acceptGCEvent(garbageCollectionEvent)) {
                this.lowMemoryThresholdReached = true;
                LowMemoryNotificationService.sendMemoryEvent(LOW_MEMORY_EVENT);
                return;
            }
            if (n > this.highThreshold) {
                this.consecutiveMinorGCCount = 0;
                if (!this.lowMemoryThresholdReached) {
                    return;
                }
                this.lowMemoryThresholdReached = false;
                LowMemoryNotificationService.sendMemoryEvent(OK_MEMORY_EVENT);
            }
        }
    }

    private boolean acceptGCEvent(GarbageCollectionEvent garbageCollectionEvent) {
        if (garbageCollectionEvent.getEventType() == 0 || this.consecutiveMinorGCCount >= 5) {
            this.consecutiveMinorGCCount = 0;
            return true;
        }
        ++this.consecutiveMinorGCCount;
        return false;
    }

    private static void debug(String string) {
        System.out.println("[LowMemoryNotificationService] " + string);
    }
}

