/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import weblogic.iiop.ConnectionKey;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.ServiceContext;
import weblogic.protocol.LocalServerIdentity;
import weblogic.rjvm.JVMID;

public final class BiDirIIOPContextImpl
extends ServiceContext {
    private ConnectionKey[] listenPoints;
    private static BiDirIIOPContextImpl context = new BiDirIIOPContextImpl();

    public BiDirIIOPContextImpl() {
        super(5);
        this.listenPoints = new ConnectionKey[]{new ConnectionKey(JVMID.localID().address().getHostAddress(), -1)};
        this.listenPoints[0].setBidirSet();
    }

    protected BiDirIIOPContextImpl(IIOPInputStream iIOPInputStream) {
        super(5);
        this.readEncapsulatedContext(iIOPInputStream);
    }

    public static final BiDirIIOPContextImpl getContext() {
        return context;
    }

    public ConnectionKey[] getListenPoints() {
        return this.listenPoints;
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        this.writeEncapsulatedContext(iIOPOutputStream);
    }

    protected void readEncapsulation(IIOPInputStream iIOPInputStream) {
        int n = iIOPInputStream.read_ulong();
        this.listenPoints = new ConnectionKey[n];
        for (int i = 0; i < n; ++i) {
            this.listenPoints[i] = new ConnectionKey(iIOPInputStream);
            this.listenPoints[i].setBidirSet();
        }
    }

    protected void writeEncapsulation(IIOPOutputStream iIOPOutputStream) {
        if (this.listenPoints == null) {
            iIOPOutputStream.write_ulong(0);
        } else {
            iIOPOutputStream.write_ulong(this.listenPoints.length);
            for (int i = 0; i < this.listenPoints.length; ++i) {
                this.listenPoints[i].writeForChannel(iIOPOutputStream, LocalServerIdentity.getIdentity());
            }
        }
    }

    public String toString() {
        return "BiDirIIOPContextImpl: " + this.listenPoints == null ? "<null>" : this.listenPoints[0].toString();
    }
}

