/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import weblogic.common.internal.PeerInfo;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IIOPRemoteRef;
import weblogic.iiop.IOR;
import weblogic.iiop.TaggedComponent;
import weblogic.iiop.VendorInfoCluster;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.cluster.Version;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;

public final class ClusterComponent
extends TaggedComponent {
    private ArrayList replicas;
    private boolean idempotent;
    private boolean stickToFirstServer;
    private String algorithm;
    private String jndiName;
    private Version version;
    private static final String NULL_STRING = "";
    private static String defaultLoadAlgorithm = null;

    ClusterComponent(boolean bl, boolean bl2, String string, String string2, ArrayList arrayList, Version version2) {
        super(1111834883);
        this.idempotent = bl;
        this.algorithm = string;
        this.replicas = arrayList;
        this.jndiName = string2;
        this.stickToFirstServer = bl2;
        this.version = version2;
    }

    ClusterComponent(ClusterComponent clusterComponent) {
        super(1111834883);
        this.idempotent = clusterComponent.idempotent;
        this.algorithm = clusterComponent.algorithm;
        this.jndiName = clusterComponent.jndiName;
        this.stickToFirstServer = clusterComponent.stickToFirstServer;
        this.version = clusterComponent.version;
    }

    ClusterComponent(IIOPInputStream iIOPInputStream) {
        super(1111834883);
        this.read(iIOPInputStream);
    }

    public final ReplicaList getReplicaList() {
        Iterator iterator = this.replicas.iterator();
        VendorInfoCluster vendorInfoCluster = new VendorInfoCluster(new IIOPRemoteRef((IOR)iterator.next()));
        while (iterator.hasNext()) {
            vendorInfoCluster.add((RemoteReference)new IIOPRemoteRef((IOR)iterator.next()));
        }
        vendorInfoCluster.setClusterInfo(this);
        if (this.version != null) {
            vendorInfoCluster.setVersion(this.version);
        }
        return vendorInfoCluster;
    }

    public final ArrayList getIORs() {
        return this.replicas;
    }

    public final Version getVersion() {
        return this.version;
    }

    final void setIORs(ArrayList arrayList) {
        this.replicas = arrayList;
    }

    public IOR findLocalIOR() {
        Debug.assertion((this.replicas != null ? 1 : 0) != 0);
        int n = this.replicas.size();
        for (int i = 0; i < n; ++i) {
            IOR iOR = (IOR)this.replicas.get(i);
            if (!iOR.isLocal()) continue;
            return iOR;
        }
        return null;
    }

    public final boolean getIdempotent() {
        return this.idempotent;
    }

    public final boolean getStickToFirstServer() {
        return this.stickToFirstServer;
    }

    public final String getClusterAlgorithm() {
        return this.algorithm;
    }

    public final String getJndiName() {
        return this.jndiName;
    }

    public final void read(IIOPInputStream iIOPInputStream) {
        long l = iIOPInputStream.startEncapsulation();
        this.algorithm = iIOPInputStream.read_string();
        this.idempotent = iIOPInputStream.read_boolean();
        this.stickToFirstServer = iIOPInputStream.read_boolean();
        this.jndiName = iIOPInputStream.read_string();
        if (this.jndiName.equals(NULL_STRING)) {
            this.jndiName = null;
        }
        int n = iIOPInputStream.read_long();
        this.replicas = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            IOR iOR = new IOR(iIOPInputStream);
            this.replicas.add(iOR);
        }
        if (iIOPInputStream.bytesLeft(l) >= 8) {
            this.version = new Version(iIOPInputStream.read_longlong());
        }
        iIOPInputStream.endEncapsulation(l);
    }

    public final void write(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_long(this.tag);
        long l = iIOPOutputStream.startEncapsulation();
        if (this.algorithm.equals("default")) {
            iIOPOutputStream.write_string(ClusterComponent.getDefaultLoadAlgorithm());
        } else {
            iIOPOutputStream.write_string(this.algorithm);
        }
        iIOPOutputStream.write_boolean(this.idempotent);
        iIOPOutputStream.write_boolean(this.stickToFirstServer);
        if (this.jndiName == null || iIOPOutputStream.getPeerInfo().compareTo((Object)PeerInfo.VERSION_81) < 0) {
            iIOPOutputStream.write_string(NULL_STRING);
        } else {
            iIOPOutputStream.write_string(this.jndiName);
        }
        int n = this.replicas.size();
        iIOPOutputStream.write_long(n);
        for (int i = 0; i < n; ++i) {
            IOR iOR = (IOR)this.replicas.get(i);
            iOR.write(iIOPOutputStream);
        }
        if (this.version != null) {
            iIOPOutputStream.write_longlong(this.version.getVersion());
        }
        iIOPOutputStream.endEncapsulation(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getDefaultLoadAlgorithm() {
        if (defaultLoadAlgorithm != null) return defaultLoadAlgorithm;
        Class<ClusterComponent> clazz = ClusterComponent.class;
        synchronized (ClusterComponent.class) {
            AuthenticatedSubject authenticatedSubject;
            ClusterMBean clusterMBean;
            defaultLoadAlgorithm = Kernel.isServer() ? ((clusterMBean = ManagementService.getRuntimeAccess(authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())).getServer().getCluster()) != null ? clusterMBean.getDefaultLoadAlgorithm() : "round-robin") : "round-robin";
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultLoadAlgorithm;
        }
    }
}

