/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterServiceActivator;
import weblogic.iiop.IIOPClientService;
import weblogic.rjvm.JVMID;

public final class ClusterServices
implements ClusterMembersChangeListener {
    private static ClusterServices singleton;
    private ClusterMemberInfo[] members;
    private final Object memberslock = new Object();
    private int current = 0;
    private JVMID secondary;
    private final Object secondarylock = new Object();
    private int lcpolicy = 1;
    private final Set serverSet = Collections.synchronizedSet(new TreeSet());
    public static final int LOCATION_FORWARD_OFF = 0;
    public static final int LOCATION_FORWARD_FAILOVER = 1;
    public static final int LOCATION_FORWARD_ROUND_ROBIN = 2;
    public static final int LOCATION_FORWARD_RANDOM = 3;

    static ClusterServices getServices() {
        return singleton;
    }

    static void initialize() {
        if (singleton == null) {
            ClusterServices.createSingleton();
        }
    }

    private static synchronized ClusterServices createSingleton() {
        if (singleton == null) {
            singleton = new ClusterServices(IIOPClientService.locationForwardPolicy);
            weblogic.cluster.ClusterServices clusterServices = ClusterServiceActivator.INSTANCE.getClusterService();
            if (clusterServices != null) {
                clusterServices.addClusterMembersListener(singleton);
            }
        }
        return singleton;
    }

    private ClusterServices(String string) {
        if (string.equals("off")) {
            this.lcpolicy = 0;
        } else if (string.equals("failover")) {
            this.lcpolicy = 1;
        } else if (string.equals("round-robin")) {
            this.lcpolicy = 2;
        } else if (string.equals("random")) {
            this.lcpolicy = 3;
        }
        this.getMembers();
    }

    public void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        this.serverSet.add(clusterMembersChangeEvent.getClusterMemberInfo().identity());
        this.getMembers();
    }

    public final int getLocationForwardPolicy() {
        return this.lcpolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JVMID getNextMember() {
        if (this.members == null || this.lcpolicy == 0) {
            return JVMID.localID();
        }
        switch (this.lcpolicy) {
            case 1: {
                return this.getNextMemberPrimarySecondary();
            }
            case 3: {
                return this.getNextMemberRandom();
            }
        }
        ClusterMemberInfo clusterMemberInfo = null;
        Object object = this.memberslock;
        synchronized (object) {
            clusterMemberInfo = this.members[this.current];
            this.current = (this.current + 1) % this.members.length;
        }
        return (JVMID)clusterMemberInfo.identity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMembers() {
        weblogic.cluster.ClusterServices clusterServices = ClusterServiceActivator.INSTANCE.getClusterService();
        if (clusterServices != null) {
            Object object = this.memberslock;
            synchronized (object) {
                Collection collection = clusterServices.getRemoteMembers();
                if (collection != null) {
                    this.members = collection.toArray(new ClusterMemberInfo[0]);
                    this.current = 0;
                }
                if (this.serverSet.size() > 0) {
                    this.secondary = (JVMID)this.serverSet.toArray()[0];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JVMID getNextMemberRandom() {
        JVMID jVMID = null;
        Object object = this.memberslock;
        synchronized (object) {
            int n = this.members.length;
            double d = Math.random() * (double)n + 0.5;
            int n2 = (int)Math.round(d) - 1;
            jVMID = (JVMID)this.members[n2].identity();
        }
        return jVMID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JVMID getNextMemberPrimarySecondary() {
        Object object = this.secondarylock;
        synchronized (object) {
            if (this.secondary != null) {
                return this.secondary;
            }
            return JVMID.localID();
        }
    }
}

