/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.ServiceContext;

public final class CodeSet
extends ServiceContext {
    private int char_data;
    private int wchar_data;
    public static final int ISO_8859_1 = 65537;
    public static final String ISO_8859_1_ENC = "iso-8859-1";
    public static final int US_ASCII = 65568;
    public static final String US_ASCII_ENC = "us-ascii";
    public static final int UTF_8 = 0x5010001;
    public static final String UTF_8_ENC = "utf-8";
    public static int DEFAULT_CHAR_NATIVE_CODE_SET = 65568;
    public static final int UTF_16 = 65801;
    public static final String UTF_16_ENC = "utf-16";
    public static final int UCS_2 = 65792;
    public static final String UCS_2_ENC = "ucs-2";
    public static final String UTF_16LE_ENC = "utf-16le";
    public static final String UTF_16BE_ENC = "utf-16be";
    public static final int UCS_4 = 65796;
    public static int DEFAULT_WCHAR_NATIVE_CODE_SET = 65792;
    public static final HashMap codeSetTable = new HashMap();
    private static final String[] charsets = new String[]{"iso-8859-1", "us-ascii", "utf-8", "utf-16", "utf-16le", "utf-16be"};
    private static Charset[] charsetTable;

    public CodeSet() {
        super(1);
        this.char_data = DEFAULT_CHAR_NATIVE_CODE_SET;
        this.wchar_data = DEFAULT_WCHAR_NATIVE_CODE_SET;
    }

    public CodeSet(int n, int n2) {
        super(1);
        this.char_data = n;
        this.wchar_data = n2;
    }

    protected CodeSet(IIOPInputStream iIOPInputStream) {
        super(1);
        this.readEncapsulatedContext(iIOPInputStream);
    }

    public int getCharCodeSet() {
        return this.char_data;
    }

    public int getWcharCodeSet() {
        return this.wchar_data;
    }

    public static final int getDefaultCharCodeSet() {
        return DEFAULT_CHAR_NATIVE_CODE_SET;
    }

    public static final int getDefaultWcharCodeSet() {
        return DEFAULT_WCHAR_NATIVE_CODE_SET;
    }

    public static boolean supportedCharCodeSet(int n) {
        return n == 0x5010001 || n == 65568 || n == 65537;
    }

    public static boolean supportedWcharCodeSet(int n) {
        return n == 0x5010001 || n == 65801 || n == 65792;
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        this.writeEncapsulatedContext(iIOPOutputStream);
    }

    protected void readEncapsulation(IIOPInputStream iIOPInputStream) {
        this.char_data = iIOPInputStream.read_ulong();
        this.wchar_data = iIOPInputStream.read_ulong();
    }

    protected void writeEncapsulation(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_ulong(this.char_data);
        iIOPOutputStream.write_ulong(this.wchar_data);
    }

    public static final void setDefaults(int n, int n2) {
        DEFAULT_CHAR_NATIVE_CODE_SET = n;
        DEFAULT_WCHAR_NATIVE_CODE_SET = n2;
    }

    public static final int getOSFCodeset(String string) {
        Integer n = (Integer)codeSetTable.get(string);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public String toString() {
        return "CodeSet Context (char_data = " + Integer.toHexString(this.char_data) + ", wchar_data = " + Integer.toHexString(this.wchar_data) + ")";
    }

    static {
        try {
            codeSetTable.put(ISO_8859_1_ENC, new Integer(65537));
            codeSetTable.put(US_ASCII_ENC, new Integer(65568));
            codeSetTable.put(UTF_8_ENC, new Integer(0x5010001));
            codeSetTable.put(UTF_16_ENC, new Integer(65801));
            codeSetTable.put(UCS_2_ENC, new Integer(65792));
            codeSetTable.put(ISO_8859_1_ENC.toUpperCase(), new Integer(65537));
            codeSetTable.put(US_ASCII_ENC.toUpperCase(), new Integer(65568));
            codeSetTable.put(UTF_8_ENC.toUpperCase(), new Integer(0x5010001));
            codeSetTable.put(UTF_16_ENC.toUpperCase(), new Integer(65801));
            codeSetTable.put(UCS_2_ENC.toUpperCase(), new Integer(65792));
            charsetTable = new Charset[codeSetTable.size()];
            codeSetTable.put(ISO_8859_1_ENC, new Integer(65537));
            codeSetTable.put(US_ASCII_ENC, new Integer(65568));
            codeSetTable.put(UTF_8_ENC, new Integer(0x5010001));
            codeSetTable.put(UTF_16_ENC, new Integer(65801));
            codeSetTable.put(UCS_2_ENC, new Integer(65792));
            for (int i = 0; i < charsets.length; ++i) {
                CodeSet.charsetTable[i] = Charset.forName(charsets[i]);
            }
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
    }
}

