/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.UnsupportedEncodingException;
import weblogic.iiop.CodeSet;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.TaggedComponent;

final class CodeSetsComponent
extends TaggedComponent {
    private static final int[] DEFAULT_CHAR_CONVERSION_CODE_SETS = new int[]{65568, 65537, 0x5010001};
    private static final int[] DEFAULT_WCHAR_CONVERSION_CODE_SETS = new int[]{65792, 65801, 0x5010001};
    private static CodeSetsComponent DEFAULT;
    private int charNativeCodeSet;
    private int[] charConversionCodeSets;
    private int wcharNativeCodeSet;
    private int[] wcharConversionCodeSets;

    public int negotiatedCharCodeSet() throws UnsupportedEncodingException {
        if (CodeSet.supportedCharCodeSet(this.charNativeCodeSet)) {
            return this.charNativeCodeSet;
        }
        for (int i = 0; i < this.charConversionCodeSets.length; ++i) {
            if (!CodeSet.supportedCharCodeSet(this.charConversionCodeSets[i])) continue;
            return this.charConversionCodeSets[i];
        }
        throw new UnsupportedEncodingException();
    }

    public int negotiatedWcharCodeSet() throws UnsupportedEncodingException {
        if (this.supportedWcharCodeSet(0x5010001)) {
            return 0x5010001;
        }
        if (CodeSet.supportedWcharCodeSet(this.wcharNativeCodeSet)) {
            return this.wcharNativeCodeSet;
        }
        for (int i = 0; i < this.wcharConversionCodeSets.length; ++i) {
            if (!CodeSet.supportedWcharCodeSet(this.wcharConversionCodeSets[i])) continue;
            return this.wcharConversionCodeSets[i];
        }
        throw new UnsupportedEncodingException();
    }

    private CodeSetsComponent() {
        super(1);
        this.charNativeCodeSet = CodeSet.DEFAULT_CHAR_NATIVE_CODE_SET;
        this.charConversionCodeSets = DEFAULT_CHAR_CONVERSION_CODE_SETS;
        this.wcharNativeCodeSet = CodeSet.DEFAULT_WCHAR_NATIVE_CODE_SET;
        this.wcharConversionCodeSets = DEFAULT_WCHAR_CONVERSION_CODE_SETS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final CodeSetsComponent getDefault() {
        if (DEFAULT != null) return DEFAULT;
        Class<CodeSetsComponent> clazz = CodeSetsComponent.class;
        synchronized (CodeSetsComponent.class) {
            DEFAULT = new CodeSetsComponent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return DEFAULT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void resetDefault() {
        Class<CodeSetsComponent> clazz = CodeSetsComponent.class;
        synchronized (CodeSetsComponent.class) {
            DEFAULT = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public CodeSetsComponent(IIOPInputStream iIOPInputStream) {
        super(1);
        this.read(iIOPInputStream);
    }

    public final boolean supportedCharCodeSet(int n) {
        if (this.charNativeCodeSet == n) {
            return true;
        }
        for (int i = 0; i < this.charConversionCodeSets.length; ++i) {
            if (this.charConversionCodeSets[i] != n) continue;
            return true;
        }
        return false;
    }

    public final boolean supportedWcharCodeSet(int n) {
        if (this.wcharNativeCodeSet == n) {
            return true;
        }
        for (int i = 0; i < this.wcharConversionCodeSets.length; ++i) {
            if (this.wcharConversionCodeSets[i] != n) continue;
            return true;
        }
        return false;
    }

    public final void read(IIOPInputStream iIOPInputStream) {
        int n;
        long l = iIOPInputStream.startEncapsulation();
        this.charNativeCodeSet = iIOPInputStream.read_long();
        int n2 = iIOPInputStream.read_long();
        this.charConversionCodeSets = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.charConversionCodeSets[n] = iIOPInputStream.read_long();
        }
        this.wcharNativeCodeSet = iIOPInputStream.read_long();
        n2 = iIOPInputStream.read_long();
        this.wcharConversionCodeSets = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.wcharConversionCodeSets[n] = iIOPInputStream.read_long();
        }
        iIOPInputStream.endEncapsulation(l);
    }

    public final void write(IIOPOutputStream iIOPOutputStream) {
        int n;
        iIOPOutputStream.write_long(this.tag);
        long l = iIOPOutputStream.startEncapsulation();
        iIOPOutputStream.write_long(this.charNativeCodeSet);
        iIOPOutputStream.write_long(this.charConversionCodeSets.length);
        for (n = 0; n < this.charConversionCodeSets.length; ++n) {
            iIOPOutputStream.write_long(this.charConversionCodeSets[n]);
        }
        iIOPOutputStream.write_long(this.wcharNativeCodeSet);
        iIOPOutputStream.write_long(this.wcharConversionCodeSets.length);
        for (n = 0; n < this.wcharConversionCodeSets.length; ++n) {
            iIOPOutputStream.write_long(this.wcharConversionCodeSets[n]);
        }
        iIOPOutputStream.endEncapsulation(l);
    }
}

