/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.ProtocolHandlerIIOP;
import weblogic.iiop.TaggedComponent;
import weblogic.kernel.Kernel;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.rjvm.JVMID;
import weblogic.rmi.spi.HostID;
import weblogic.servlet.internal.WebService;
import weblogic.utils.http.HttpParsing;

public final class CodebaseComponent
extends TaggedComponent {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private String codebase = null;
    private String applicationName;
    private ConnectionKey key;
    private ServerIdentity target;

    CodebaseComponent(ServerIdentity serverIdentity) {
        this(serverIdentity, null);
    }

    CodebaseComponent(ServerIdentity serverIdentity, String string) {
        super(25);
        this.applicationName = string;
        ServerChannel serverChannel = ServerChannelManager.findServerChannel((HostID)serverIdentity, (Protocol)ProtocolHandlerIIOP.PROTOCOL_IIOP);
        this.key = serverChannel != null ? new ConnectionKey(serverChannel.getAddress(), serverChannel.getPort()) : ConnectionKey.NULL_KEY;
        this.target = serverIdentity;
    }

    CodebaseComponent(String string) {
        this(LocalServerIdentity.getIdentity(), string);
    }

    CodebaseComponent(IIOPInputStream iIOPInputStream) {
        super(25);
        this.read(iIOPInputStream);
    }

    public String getCodebase() {
        return this.codebase;
    }

    public static String getCodebase(ConnectionKey connectionKey, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            CodebaseComponent.p("getCodebase(" + connectionKey + ", " + string + ", " + bl + ")");
        }
        if (bl) {
            stringBuffer.append("https://");
        } else {
            stringBuffer.append("http://");
        }
        stringBuffer.append(connectionKey.getAddress()).append(":").append(connectionKey.getPort());
        if (!WebService.getInternalWebAppContextPath().startsWith("/")) {
            stringBuffer.append('/');
        }
        stringBuffer.append(WebService.getInternalWebAppContextPath()).append("/classes").append('/');
        if (string != null) {
            stringBuffer.append(string).append('/');
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            CodebaseComponent.p("getCodebase(" + string + ") == " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public final void read(IIOPInputStream iIOPInputStream) {
        long l = iIOPInputStream.startEncapsulation();
        this.codebase = HttpParsing.unescape((String)iIOPInputStream.read_string());
        iIOPInputStream.endEncapsulation(l);
    }

    public final void write(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_long(this.tag);
        long l = iIOPOutputStream.startEncapsulation();
        if (this.codebase != null) {
            iIOPOutputStream.write_string(HttpParsing.escape((String)this.codebase));
        } else {
            ServerChannel serverChannel = iIOPOutputStream.getServerChannel();
            if (serverChannel instanceof JVMID) {
                ServerChannel serverChannel2 = serverChannel;
                ConnectionKey connectionKey = new ConnectionKey(serverChannel2.getPublicAddress(), serverChannel2.getPublicPort());
                iIOPOutputStream.write_string(HttpParsing.escape((String)CodebaseComponent.getCodebase(connectionKey, this.applicationName, iIOPOutputStream.isSecure())));
            } else {
                iIOPOutputStream.write_string(HttpParsing.escape((String)CodebaseComponent.getCodebase(this.key.writeReplace(iIOPOutputStream, this.target), this.applicationName, iIOPOutputStream.isSecure())));
            }
        }
        iIOPOutputStream.endEncapsulation(l);
    }

    protected static void p(String string) {
        System.err.println("<CodebaseComponent> " + string);
    }
}

