/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.rmi.Remote;
import java.security.AccessController;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import weblogic.common.internal.PeerInfo;
import weblogic.iiop.CodeSet;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.EndPointFactory;
import weblogic.iiop.IOR;
import weblogic.iiop.MuxableSocketIIOP;
import weblogic.kernel.Kernel;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.AsyncMessageSender;
import weblogic.protocol.ServerChannel;
import weblogic.rmi.spi.Channel;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;

public abstract class Connection
implements AsyncMessageSender,
EndPointFactory {
    public static final String CONN_BIDIR_KEYS = "weblogic.iiop.BiDirKeys";
    public static final int SENT_CODE_SET = 1;
    public static final int SENT_CODEBASE = 2;
    public static final int SENT_VERSION = 4;
    public static final int SENT_BIDIR = 8;
    public static final int CONN_NEGOTIATED = 16;
    public static final int RECV_CODE_SET = 32;
    public static final int RECV_BIDIR = 64;
    private int flags = 0;
    private Remote hbStub;
    private int minorVersion;
    private PeerInfo peerinfo = null;
    private int char_codeset = CodeSet.getDefaultCharCodeSet();
    private int wchar_codeset = CodeSet.getDefaultWcharCodeSet();
    private IOR remoteCodeBase = null;
    private static AuthenticatedSubject defaultSubject = null;
    private ConcurrentHashMap properties = new ConcurrentHashMap();

    public abstract void close();

    public abstract boolean isClosed();

    public boolean isDead() {
        return false;
    }

    public abstract ConnectionKey getConnectionKey();

    public abstract void setConnectionKey(ConnectionKey var1);

    final void setHeartbeatStub(Remote remote) {
        this.hbStub = remote;
    }

    protected final Remote getHeartbeatStub() {
        return this.hbStub;
    }

    public abstract AuthenticatedSubject getUser();

    public abstract void authenticate(UserInfo var1);

    public abstract Object getTxContext();

    public abstract void setTxContext(Object var1);

    public abstract ServerChannel getChannel();

    public abstract Channel getRemoteChannel();

    public boolean isStateful() {
        return true;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public void setFlag(int n) {
        this.flags |= n;
    }

    public boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    public int getWcharCodeSet() {
        return this.wchar_codeset;
    }

    public int getCharCodeSet() {
        return this.char_codeset;
    }

    public void setCodeSets(int n, int n2) {
        this.char_codeset = n;
        this.wchar_codeset = n2;
    }

    public IOR getRemoteCodeBase() {
        return this.remoteCodeBase;
    }

    public void setRemoteCodeBase(IOR iOR) {
        this.remoteCodeBase = iOR;
    }

    public PeerInfo getPeerInfo() {
        return this.peerinfo;
    }

    public void setPeerInfo(PeerInfo peerInfo) {
        this.peerinfo = peerInfo;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    protected abstract boolean isSecure();

    public ContextHandler getContextHandler() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthenticatedSubject getDefaultSubject() {
        if (defaultSubject != null) {
            return defaultSubject;
        }
        if (!Kernel.isServer()) {
            return SubjectUtils.getAnonymousSubject();
        }
        Class<MuxableSocketIIOP> clazz = MuxableSocketIIOP.class;
        synchronized (MuxableSocketIIOP.class) {
            if (defaultSubject == null) {
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                if (ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getDefaultIIOPUser() == null) {
                    defaultSubject = SubjectUtils.getAnonymousSubject();
                } else {
                    try {
                        SimpleCallbackHandler simpleCallbackHandler = new SimpleCallbackHandler(ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getDefaultIIOPUser(), ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getDefaultIIOPPassword());
                        defaultSubject = Connection.getPrincipalAuthenticator().authenticate((CallbackHandler)simpleCallbackHandler);
                    }
                    catch (LoginException loginException) {
                        defaultSubject = SubjectUtils.getAnonymousSubject();
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultSubject;
        }
    }

    protected static PrincipalAuthenticator getPrincipalAuthenticator() {
        return PrincipalAuthenticatorMaker.AUTHENTICATOR;
    }

    public static boolean isValidDefaultUser() {
        return Connection.getDefaultSubject() != null;
    }

    private static class PrincipalAuthenticatorMaker {
        private static final PrincipalAuthenticator AUTHENTICATOR = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())), (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);

        private PrincipalAuthenticatorMaker() {
        }
    }
}

