/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.net.InetSocketAddress;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.EndPoint;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.ProtocolHandlerIIOP;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.spi.HostID;
import weblogic.utils.net.InetAddressHelper;

public final class ConnectionKey {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    public static final int PORT_DISABLED = 0;
    private String address;
    private int port;
    private int connectedPort;
    private boolean isUsingBidir;
    private InetSocketAddress inAddr;
    public static final ConnectionKey NULL_KEY = new ConnectionKey(null, -1);

    public ConnectionKey(String string, int n) {
        if (InetAddressHelper.isIPV6Address((String)string) && string.indexOf("[") == -1) {
            string = "[" + string + "]";
        }
        this.address = string;
        this.connectedPort = this.port = n;
        if (n > 0 && string != null) {
            this.inAddr = new InetSocketAddress(string, n);
        }
    }

    public ConnectionKey(String string, int n, int n2) {
        if (InetAddressHelper.isIPV6Address((String)string) && string.indexOf("[") == -1) {
            string = "[" + string + "]";
        }
        this.address = string;
        this.connectedPort = n2;
        this.port = n;
        if (n > 0 && string != null) {
            this.inAddr = new InetSocketAddress(string, n);
        }
    }

    public ConnectionKey(IIOPInputStream iIOPInputStream) {
        this.read(iIOPInputStream);
    }

    public boolean isBidirSet() {
        return this.isUsingBidir;
    }

    public void setBidirSet() {
        this.isUsingBidir = true;
    }

    public int getPort() {
        return this.port;
    }

    public int getConnectedPort() {
        return this.connectedPort;
    }

    public String getAddress() {
        return this.address;
    }

    public int hashCode() {
        return this.inAddr != null ? this.inAddr.hashCode() : this.address.hashCode() ^ this.port;
    }

    public boolean equals(Object object) {
        if (object instanceof ConnectionKey) {
            ConnectionKey connectionKey = (ConnectionKey)object;
            return this.inAddr != null && this.inAddr.equals(connectionKey.inAddr) || connectionKey.port == this.port & connectionKey.address.equals(this.address);
        }
        return false;
    }

    private void read(IIOPInputStream iIOPInputStream) {
        this.address = iIOPInputStream.read_string();
        this.port = iIOPInputStream.read_unsigned_short();
        if (this.port > 0 && this.address != null) {
            this.inAddr = new InetSocketAddress(this.address, this.port);
        }
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_string(this.address);
        iIOPOutputStream.write_unsigned_short(this.port < 0 ? 0 : this.port);
    }

    public ConnectionKey writeReplace(IIOPOutputStream iIOPOutputStream, ServerIdentity serverIdentity) {
        EndPoint endPoint = iIOPOutputStream.getEndPoint();
        ServerChannel serverChannel = iIOPOutputStream.getServerChannel();
        ConnectionKey connectionKey = this;
        if (this.port == -1 && endPoint != null && !KernelStatus.isServer()) {
            connectionKey = new ConnectionKey(this.address, endPoint.getConnection().getConnectionKey().getConnectedPort());
        } else if (KernelStatus.isServer() && endPoint != null && endPoint.getConnection() != null && serverIdentity.isLocal()) {
            if (serverChannel != null) {
                connectionKey = new ConnectionKey(serverChannel.getPublicAddress(), this.port > 0 || this.port == -1 ? serverChannel.getPublicPort() : 0);
            }
        } else if (KernelStatus.isServer() && serverIdentity != null && serverChannel != null && !serverIdentity.isLocal()) {
            ServerChannel serverChannel2 = ServerChannelManager.findServerChannel((HostID)serverIdentity, (Protocol)serverChannel.getProtocol(), (String)serverChannel.getChannelName());
            if (serverChannel2 != null) {
                connectionKey = new ConnectionKey(serverChannel2.getPublicAddress(), this.port > 0 || this.port == -1 ? serverChannel2.getPublicPort() : 0);
            }
        } else if (KernelStatus.isServer() && this.address == null && serverIdentity != null && serverIdentity.isLocal()) {
            ServerChannel serverChannel3 = ServerChannelManager.findLocalServerChannel((Protocol)ProtocolHandlerIIOP.PROTOCOL_IIOP);
            connectionKey = serverChannel3 != null ? new ConnectionKey(serverChannel3.getPublicAddress(), this.port > 0 || this.port == -1 ? serverChannel3.getPublicPort() : 0) : new ConnectionKey("", 0);
        }
        if (KernelStatus.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ConnectionKey.p("mapped " + this + " => " + connectionKey + " for " + serverIdentity);
        }
        return connectionKey;
    }

    public void writeForChannel(IIOPOutputStream iIOPOutputStream, ServerIdentity serverIdentity) {
        this.writeReplace(iIOPOutputStream, serverIdentity).write(iIOPOutputStream);
    }

    public void writeForChannel(IIOPOutputStream iIOPOutputStream) {
        EndPoint endPoint = iIOPOutputStream.getEndPoint();
        ConnectionKey connectionKey = this;
        if (this.port == -1 && !KernelStatus.isServer() && endPoint != null) {
            connectionKey = new ConnectionKey(this.address, endPoint.getConnection().getConnectionKey().getConnectedPort());
        }
        connectionKey.write(iIOPOutputStream);
    }

    public ConnectionKey readResolve(IIOPInputStream iIOPInputStream) {
        EndPoint endPoint = iIOPInputStream.getEndPoint();
        if (endPoint != null && !KernelStatus.isServer() && this.port == endPoint.getConnection().getConnectionKey().getConnectedPort()) {
            return new ConnectionKey(this.address, -1);
        }
        return this;
    }

    public String toString() {
        return this.address + ":" + this.port + "(" + this.connectedPort + ")";
    }

    private static void p(String string) {
        System.err.println("<ConnectionKey>: " + string);
    }
}

