/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.Connection;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointManager;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.MessageDispatcher;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.Kernel;
import weblogic.rmi.spi.EndPointFinder;
import weblogic.rmi.spi.RMIRuntime;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.io.Chunk;

public final class ConnectionManager
implements MessageDispatcher {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");

    static void p(String string) {
        System.err.println("<ConnectionManager: " + System.currentTimeMillis() + ">: " + string);
    }

    private static ConnectionManager createDispatcher() {
        RMIRuntime.getRMIRuntime().addEndPointFinder((EndPointFinder)new EndPointManager());
        return new ConnectionManager();
    }

    public static ConnectionManager getConnectionManager() {
        return DispatcherMaker.dispatcher;
    }

    private ConnectionManager() {
    }

    public void dispatch(Connection connection, Chunk chunk) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ConnectionManager.p("dispatch");
        }
        try {
            EndPoint endPoint = EndPointManager.findOrCreateEndPoint(connection);
            endPoint.dispatch(chunk);
        }
        catch (Throwable throwable) {
            this.gotExceptionReceiving(connection, throwable);
        }
    }

    public void gotExceptionReceiving(Connection connection, Throwable throwable) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled() || Kernel.getDebug().getDebugIIOP()) {
            IIOPLogger.logExceptionReceiving((Throwable)throwable);
        }
        this.handleConnectionShutdown(connection, throwable);
    }

    public void gotExceptionSending(Connection connection, IOException iOException) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled() || Kernel.getDebug().getDebugIIOP()) {
            IIOPLogger.logExceptionSending((IOException)iOException);
        }
        this.handleConnectionShutdown(connection, iOException);
    }

    synchronized void handleConnectionShutdown(Connection connection, Throwable throwable) {
        EndPoint endPoint = EndPointManager.removeConnection(connection);
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ConnectionManager.p("shutting down " + connection + " because <" + StackTraceUtils.throwable2StackTrace((Throwable)throwable) + "\n>");
        }
        if (endPoint != null) {
            endPoint.cleanupPendingResponses(throwable);
        }
        connection.close();
        if (throwable instanceof Error) {
            if (throwable instanceof OutOfMemoryError) {
                IIOPLogger.logOutOfMemory((Throwable)throwable);
                throw (OutOfMemoryError)throwable;
            }
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
        }
    }

    synchronized void forceConnectionShutdown(Connection connection, Throwable throwable) {
        EndPoint endPoint = EndPointManager.removeConnection(connection);
        if (endPoint != null) {
            endPoint.cleanupPendingResponses(throwable);
        }
        connection.close();
    }

    public void handleExceptionSending(final Connection connection, final IOException iOException) {
        Kernel.execute(new ExecuteRequest(){

            public void execute(ExecuteThread executeThread) throws Exception {
                ConnectionManager.this.gotExceptionSending(connection, iOException);
            }
        });
    }

    static /* synthetic */ ConnectionManager access$000() {
        return ConnectionManager.createDispatcher();
    }

    private static final class DispatcherMaker {
        private static final ConnectionManager dispatcher = ConnectionManager.access$000();

        private DispatcherMaker() {
        }
    }
}

