/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.CloseConnectionMessage;
import weblogic.iiop.Connection;
import weblogic.iiop.ConnectionManager;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointManager;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.net.SocketResetException;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public final class ConnectionShutdownHandler
extends WorkAdapter {
    private static final DebugCategory debugMarshal = Debug.getCategory((String)"weblogic.iiop.marshal");
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private static final DebugLogger debugIIOPMarshal = DebugLogger.getDebugLogger((String)"DebugIIOPMarshal");
    private static final DebugLogger debugIIOPTransport = DebugLogger.getDebugLogger((String)"DebugIIOPTransport");
    private final Connection c;
    private final Throwable th;
    private final boolean sendClose;

    public ConnectionShutdownHandler(Connection connection, Throwable throwable) {
        this(connection, throwable, true);
    }

    public ConnectionShutdownHandler(Connection connection, Throwable throwable, boolean bl) {
        this.c = connection;
        this.th = throwable;
        this.sendClose = bl;
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)this));
    }

    public void run() {
        if (this.sendClose) {
            this.closeConnection();
        }
        ConnectionManager.getConnectionManager().handleConnectionShutdown(this.c, this.th);
    }

    private void closeConnection() {
        EndPoint endPoint = EndPointManager.removeConnection(this.c);
        if (endPoint != null) {
            endPoint.cleanupPendingResponses(this.th);
        }
        if (!(endPoint == null || endPoint.getMinorVersion() <= 0 || this.th instanceof IOException && SocketResetException.isResetException((IOException)((IOException)this.th)))) {
            IIOPOutputStream iIOPOutputStream;
            block5: {
                CloseConnectionMessage closeConnectionMessage = new CloseConnectionMessage(endPoint);
                iIOPOutputStream = closeConnectionMessage.getOutputStream();
                closeConnectionMessage.write(iIOPOutputStream);
                try {
                    endPoint.send(iIOPOutputStream);
                }
                catch (Exception exception) {
                    if (!debugMarshal.isEnabled() && !debugIIOPMarshal.isDebugEnabled() || this.th == null) break block5;
                    IIOPLogger.logDebugMarshalError((String)"cannot deliver", (Throwable)this.th);
                }
            }
            iIOPOutputStream.close();
            if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                IIOPLogger.logDebugTransport((String)"CLOSE_CONNECTION: sent");
            }
        }
    }
}

