/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.rmi.Remote;
import org.omg.CORBA.portable.ObjectImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointManager;
import weblogic.iiop.IIOPRemoteRef;
import weblogic.kernel.Kernel;
import weblogic.rmi.cluster.ClusterableRemoteRef;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.server.DisconnectMonitorProvider;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.StubReference;
import weblogic.rmi.internal.StubInfoIntf;

public class DisconnectMonitorImpl
implements DisconnectMonitorProvider {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");

    public boolean addDisconnectListener(Remote remote, DisconnectListener disconnectListener) {
        IIOPRemoteRef iIOPRemoteRef = this.getRefFromStub(remote);
        if (iIOPRemoteRef != null) {
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                DisconnectMonitorImpl.p("registering: " + remote + ", hashcode: " + remote.hashCode());
            }
            try {
                block8: {
                    try {
                        if (((ObjectImpl)remote)._non_existent()) {
                            throw new IllegalArgumentException("The remote peer is alive but does not have the object: " + remote);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!Kernel.DEBUG || !debugIIOPDetail.isDebugEnabled()) break block8;
                        throwable.printStackTrace();
                        EndPoint endPoint = EndPointManager.findEndPoint(iIOPRemoteRef.getIOR());
                        if (endPoint == null) break block8;
                        DisconnectMonitorImpl.p("There is still an EndPoint: " + endPoint + ", it should be null!");
                    }
                }
                EndPoint endPoint = EndPointManager.findOrCreateEndPoint(iIOPRemoteRef.getIOR());
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    DisconnectMonitorImpl.p("Registering on EndPoint: " + endPoint);
                }
                endPoint.addDisconnectListener(remote, disconnectListener);
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean removeDisconnectListener(Remote remote, DisconnectListener disconnectListener) {
        IIOPRemoteRef iIOPRemoteRef = this.getRefFromStub(remote);
        if (iIOPRemoteRef != null) {
            EndPoint endPoint = EndPointManager.findEndPoint(iIOPRemoteRef.getIOR());
            if (endPoint != null) {
                endPoint.removeDisconnectListener(remote, disconnectListener);
            }
            return true;
        }
        return false;
    }

    private IIOPRemoteRef getRefFromStub(Object object) {
        RemoteReference remoteReference = null;
        if (object instanceof StubInfoIntf) {
            remoteReference = ((StubInfoIntf)object).getStubInfo().getRemoteRef();
        } else if (object instanceof StubReference) {
            remoteReference = ((StubReference)object).getRemoteRef();
        }
        if (remoteReference instanceof ClusterableRemoteRef) {
            ClusterableRemoteRef clusterableRemoteRef = (ClusterableRemoteRef)remoteReference;
            remoteReference = clusterableRemoteRef.getCurrentReplica();
        }
        if (remoteReference instanceof IIOPRemoteRef) {
            return (IIOPRemoteRef)remoteReference;
        }
        return null;
    }

    private static void p(String string) {
        System.out.println("<HeartbeatMonitorDelegate>: " + string);
    }
}

