/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.PropagationContext;
import org.omg.SendingContext.RunTime;
import weblogic.common.internal.PeerInfo;
import weblogic.corba.cos.naming.NamingContextImpl;
import weblogic.corba.cos.naming.RootNamingContextImpl;
import weblogic.corba.cos.transactions.OTSHelper;
import weblogic.corba.cos.transactions.PropagationContextImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.CancelRequestMessage;
import weblogic.iiop.CloseConnectionMessage;
import weblogic.iiop.ClusterServices;
import weblogic.iiop.Connection;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.ConnectionManager;
import weblogic.iiop.ConnectionShutdownHandler;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointManager;
import weblogic.iiop.ForwardingContext;
import weblogic.iiop.FragmentMessage;
import weblogic.iiop.HostIDImpl;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IIOPReplacer;
import weblogic.iiop.IIOPService;
import weblogic.iiop.IOR;
import weblogic.iiop.InboundRequestImpl;
import weblogic.iiop.InitialReferences;
import weblogic.iiop.LocateReplyMessage;
import weblogic.iiop.LocateRequestMessage;
import weblogic.iiop.Message;
import weblogic.iiop.MessageErrorMessage;
import weblogic.iiop.MessageForwardingHandler;
import weblogic.iiop.MessageHeader;
import weblogic.iiop.ObjectKey;
import weblogic.iiop.OutboundResponseImpl;
import weblogic.iiop.ReplyHandler;
import weblogic.iiop.ReplyMessage;
import weblogic.iiop.RequestMessage;
import weblogic.iiop.SequencedRequestMessage;
import weblogic.iiop.ServiceContext;
import weblogic.iiop.ServiceContextList;
import weblogic.iiop.Utils;
import weblogic.iiop.VendorInfoSecurity;
import weblogic.iiop.VendorInfoTx;
import weblogic.iiop.csi.ClientSecurityContext;
import weblogic.iiop.csi.CompoundSecMechList;
import weblogic.iiop.csi.SASServiceContext;
import weblogic.iiop.csi.SecurityContext;
import weblogic.kernel.Kernel;
import weblogic.protocol.Identity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectEventImpl;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.NotImplementedException;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.RequestTimeoutException;
import weblogic.rmi.extensions.ServerDisconnectEventImpl;
import weblogic.rmi.extensions.server.Collectable;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.ReplyOnError;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.OutboundRequest;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.auth.login.PasswordCredential;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.SyncKeyTable;
import weblogic.utils.collections.NumericKeyHashMap;
import weblogic.utils.collections.NumericKeyHashtable;
import weblogic.utils.io.Chunk;
import weblogic.work.WorkManagerFactory;

public class EndPointImpl
implements EndPoint {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private static final boolean DEBUG = false;
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private static final DebugCategory debugMarshal = Debug.getCategory((String)"weblogic.iiop.marshal");
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.iiop.security");
    private static final DebugLogger debugIIOPTransport = DebugLogger.getDebugLogger((String)"DebugIIOPTransport");
    private static final DebugLogger debugIIOPMarshal = DebugLogger.getDebugLogger((String)"DebugIIOPMarshal");
    private static final DebugLogger debugIIOPSecurity = DebugLogger.getDebugLogger((String)"DebugIIOPSecurity");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    protected final boolean secure;
    protected final ConnectionManager conMan;
    protected final Connection c;
    private int bootstrapFlags = 0;
    private int negotiatedRequestId = 0;
    private Object bootstrapLock = new Object();
    private long nextClientContextId = 0L;
    private int nextRequestID = 1;
    private int pendingCount = 0;
    private final NumericKeyHashtable fragmentTable = new NumericKeyHashtable();
    private final NumericKeyHashtable securityContextTable = new NumericKeyHashtable();
    private final NumericKeyHashMap statefulClientContextIdTable = new NumericKeyHashMap();
    private final HashMap statefulClientContextTable = new HashMap();
    private final SyncKeyTable pendingResponses = new SyncKeyTable();
    private final long creationTime;
    private RunTime codebase = null;
    private HostID hostID;
    private final HashMap disconnectListeners = new HashMap();

    private final void p(String string) {
        System.err.println("<EndPointImpl(" + Integer.toHexString(this.hashCode()) + ")>: " + string);
    }

    private final void pfull(String string) {
        this.p("@" + System.currentTimeMillis() + ", connected to: " + this.c.getConnectionKey().toString() + ": " + string);
    }

    protected boolean isSecure(Connection connection) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p(" +++ connection isSecure : " + connection.isSecure());
        }
        return connection.isSecure();
    }

    public boolean supportsForwarding() {
        return true;
    }

    public final Connection getConnection() {
        return this.c;
    }

    public final void setCodeSets(int n, int n2) {
        this.c.setCodeSets(n, n2);
    }

    public final int getWcharCodeSet() {
        return this.c.getWcharCodeSet();
    }

    public final int getCharCodeSet() {
        return this.c.getCharCodeSet();
    }

    public final boolean getFlag(int n) {
        return this.c.getFlag(n);
    }

    public final void setFlag(int n) {
        this.c.setFlag(n);
    }

    public final RunTime getRemoteCodeBase() {
        if (this.codebase == null && this.c.getRemoteCodeBase() != null && !this.c.getRemoteCodeBase().getProfile().getObjectKey().isLocalKey()) {
            try {
                IIOPReplacer.getIIOPReplacer();
                this.codebase = (RunTime)PortableRemoteObject.narrow((Object)IIOPReplacer.resolveObject(this.c.getRemoteCodeBase()), RunTime.class);
            }
            catch (ClassCastException classCastException) {
                IIOPLogger.logBadRuntime((Exception)classCastException);
            }
            catch (IOException iOException) {
                IIOPLogger.logBadRuntime((Exception)iOException);
            }
        }
        return this.codebase;
    }

    public final void setRemoteCodeBase(IOR iOR) {
        if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
            IIOPLogger.logDebugTransport((String)(this + " setting remote codebase to " + iOR));
        }
        this.c.setRemoteCodeBase(iOR);
    }

    public PeerInfo getPeerInfo() {
        return this.c.getPeerInfo();
    }

    public void setPeerInfo(PeerInfo peerInfo) {
        if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
            IIOPLogger.logDebugTransport((String)("peer is " + peerInfo));
        }
        this.c.setPeerInfo(peerInfo);
    }

    public EndPointImpl(Connection connection, ConnectionManager connectionManager) {
        this.c = connection;
        this.secure = this.isSecure(connection);
        this.conMan = connectionManager;
        this.creationTime = System.currentTimeMillis();
    }

    public final ConnectionManager getConnectionManager() {
        return this.conMan;
    }

    public SequencedRequestMessage getPendingResponse(int n) {
        return (SequencedRequestMessage)this.pendingResponses.get(n);
    }

    public SequencedRequestMessage removePendingResponse(int n) {
        return (SequencedRequestMessage)this.pendingResponses.remove(n);
    }

    public void registerPendingResponse(SequencedRequestMessage sequencedRequestMessage) {
        this.pendingResponses.put((Object)sequencedRequestMessage);
    }

    private final Message createMsgFromStream(Chunk chunk) throws IOException {
        IIOPInputStream iIOPInputStream = new IIOPInputStream(chunk, this.isSecure(), (EndPoint)this);
        if (Kernel.getDebug().getDebugIIOP() || debugMarshal.isEnabled() || debugIIOPMarshal.isDebugEnabled()) {
            IIOPLogger.logDebugMarshal((String)("received [" + this.getServerChannel().getProtocol() + "] from " + this.getConnection().getConnectionKey() + " on " + this.getServerChannel() + "\n" + iIOPInputStream.dumpBuf()));
        }
        MessageHeader messageHeader = new MessageHeader(iIOPInputStream);
        if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
            IIOPLogger.logDebugTransport((String)("received " + messageHeader.getMsgTypeAsString() + " message"));
        }
        if (messageHeader.getMinorVersion() > this.c.getMinorVersion()) {
            this.c.setMinorVersion(messageHeader.getMinorVersion());
        }
        iIOPInputStream.setSupportsJDK13Chunking(messageHeader.getMinorVersion() < 2);
        switch (messageHeader.getMsgType()) {
            case 0: {
                return new RequestMessage(this, messageHeader, iIOPInputStream);
            }
            case 2: {
                return new CancelRequestMessage(this, messageHeader, iIOPInputStream);
            }
            case 3: {
                return new LocateRequestMessage(this, messageHeader, iIOPInputStream);
            }
            case 5: {
                return new CloseConnectionMessage(this, messageHeader, iIOPInputStream);
            }
            case 6: {
                return new MessageErrorMessage(this, messageHeader, iIOPInputStream);
            }
            case 1: {
                return new ReplyMessage((EndPoint)this, messageHeader, iIOPInputStream);
            }
            case 4: {
                return new LocateReplyMessage(this, messageHeader, iIOPInputStream);
            }
            case 7: {
                return new FragmentMessage(this, messageHeader, iIOPInputStream);
            }
        }
        IIOPLogger.logGarbageMessage();
        throw new UnmarshalException("Recieved unknown message type: " + messageHeader.getMsgType());
    }

    public final void dispatch(Chunk chunk) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.pfull("dispatch()");
        }
        Message message = null;
        try {
            message = this.createMsgFromStream(chunk);
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                this.p("Message type: " + message.getMsgType());
            }
            this.handleMessage(message);
        }
        catch (IOException iOException) {
            this.handleProtocolException(message, iOException);
        }
        catch (SystemException systemException) {
            this.handleProtocolException(message, systemException);
        }
        catch (RuntimeException runtimeException) {
            this.handleProtocolException(message, runtimeException);
        }
        catch (Throwable throwable) {
            UNKNOWN uNKNOWN = new UNKNOWN("Unhandled error: " + throwable.getMessage());
            uNKNOWN.initCause(throwable);
            this.handleProtocolException(message, uNKNOWN);
        }
    }

    public void handleProtocolException(Message message, Throwable throwable) {
        if (debugMarshal.isEnabled() || debugIIOPMarshal.isDebugEnabled()) {
            IIOPLogger.logDebugMarshalError((String)"got protocol exception", (Throwable)throwable);
        }
        if (message == null) {
            this.gotExceptionReceiving(throwable);
            return;
        }
        if (message.isFragmented() || message.getMsgType() == 7) {
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                this.p("message fragment error");
            }
            message = this.purgeFragment(message);
        }
        switch (message.getMsgType()) {
            case 3: 
            case 4: {
                new ConnectionShutdownHandler(this.c, throwable);
                return;
            }
            case 0: {
                this.replyErrorToOutstandingRequest((RequestMessage)message, throwable);
                return;
            }
            case 1: {
                this.notifySender((ReplyMessage)message, throwable);
                return;
            }
        }
        this.gotExceptionReceiving(throwable);
    }

    private final void replyErrorToOutstandingRequest(RequestMessage requestMessage, Throwable throwable) {
        ServiceContextList serviceContextList = null;
        try {
            serviceContextList = requestMessage.getOutboundServiceContexts();
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        ReplyMessage replyMessage = new ReplyMessage((EndPoint)this, requestMessage, serviceContextList, 0);
        OutboundResponseImpl outboundResponseImpl = new OutboundResponseImpl(this, replyMessage);
        if (throwable instanceof SystemException || throwable instanceof RemoteException) {
            new ReplyOnError((OutboundResponse)outboundResponseImpl, throwable);
        } else if (throwable instanceof Exception) {
            new ReplyOnError((OutboundResponse)outboundResponseImpl, (Throwable)new MarshalException("GIOP protocol error", (Exception)throwable));
        } else {
            new ReplyOnError((OutboundResponse)outboundResponseImpl, (Throwable)new MarshalException("GIOP protocol error: " + throwable.getMessage()));
        }
    }

    private final OBJECT_NOT_EXIST replyNoSuchObject(String string) {
        return new OBJECT_NOT_EXIST(string, 1330446337, CompletionStatus.COMPLETED_NO);
    }

    final void notifySender(ReplyMessage replyMessage, Throwable throwable) {
        int n = replyMessage.getRequestID();
        SequencedRequestMessage sequencedRequestMessage = this.removePendingResponse(n);
        if (sequencedRequestMessage == null) {
            return;
        }
        UnmarshalException unmarshalException = new UnmarshalException("GIOP protocol failure");
        unmarshalException.detail = throwable;
        replyMessage.setThrowable(unmarshalException);
        sequencedRequestMessage.notify(replyMessage);
    }

    private final void handleMessage(Message message) throws IOException {
        if (message.isFragmented()) {
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                this.p("message is fragmented");
            }
            this.collectFragment(message);
            return;
        }
        this.processMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void processMessage(Message message) throws IOException {
        switch (message.getMsgType()) {
            case 0: {
                this.handleIncomingRequest(message);
                return;
            }
            case 1: {
                if (this.negotiatedRequestId >= 0) {
                    Object object = this.bootstrapLock;
                    synchronized (object) {
                        if (this.negotiatedRequestId >= 0 && this.negotiatedRequestId == message.getRequestID()) {
                            this.setFlag(this.bootstrapFlags);
                            this.negotiatedRequestId = -1;
                        }
                    }
                }
                this.handleIncomingResponse(message);
                return;
            }
            case 2: {
                return;
            }
            case 3: {
                this.handleLocateRequest(message);
                return;
            }
            case 4: {
                this.handleLocateReply(message);
                return;
            }
            case 6: {
                if (Kernel.getDebug().getDebugIIOP()) {
                    this.p("handling message error");
                }
                this.handleMessageError(message);
                return;
            }
            case 5: {
                this.handleCloseConnection(message);
                return;
            }
            case 7: {
                this.processFragment(message);
                return;
            }
        }
        if (Kernel.getDebug().getDebugIIOP()) {
            this.p("handling unknown message");
        }
        this.gotExceptionReceiving(Utils.mapToCORBAException(new UnmarshalException("Unkown message type: " + message.getMsgType())));
    }

    final void gotExceptionReceiving(Throwable throwable) {
        this.conMan.gotExceptionReceiving(this.c, throwable);
    }

    private final void handleMessageError(Message message) {
        new ConnectionShutdownHandler(this.c, new EOFException("GIOP protocol error"));
    }

    final void handleCloseConnection(Message message) {
        new ConnectionShutdownHandler(this.c, new EOFException("Connection closed by peer"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void collectFragment(Message message) throws IOException {
        Message message2 = message;
        int n = message2.getRequestID();
        ArrayList<Message> arrayList = null;
        NumericKeyHashtable numericKeyHashtable = this.fragmentTable;
        synchronized (numericKeyHashtable) {
            arrayList = (ArrayList<Message>)this.fragmentTable.get((long)n);
            if (arrayList == null) {
                if (message.getMsgType() == 7) {
                    throw new UnmarshalException("Message Fragment out of order");
                }
                arrayList = new ArrayList<Message>();
                this.fragmentTable.put((long)n, arrayList);
            } else if (message.getMsgType() != 7) {
                throw new UnmarshalException("Message Fragment out of order");
            }
        }
        arrayList.add(message);
        if (debugMarshal.isEnabled() || debugIIOPMarshal.isDebugEnabled()) {
            IIOPLogger.logDebugMarshal((String)("collected fragment " + arrayList.size() + " for request " + message2.getRequestID()));
        }
    }

    final void processFragment(Message message) throws IOException {
        ArrayList arrayList = (ArrayList)this.fragmentTable.remove((long)message.getRequestID());
        arrayList.add(message);
        message = (Message)arrayList.remove(0);
        IIOPInputStream iIOPInputStream = message.getInputStream();
        while (!arrayList.isEmpty()) {
            Message message2 = (Message)arrayList.remove(0);
            iIOPInputStream.addChunks(message2.getInputStream());
        }
        message.flush();
        this.processMessage(message);
    }

    final Message purgeFragment(Message message) {
        ArrayList arrayList = (ArrayList)this.fragmentTable.remove((long)message.getRequestID());
        if (arrayList == null) {
            return message;
        }
        message = (Message)arrayList.remove(0);
        IIOPInputStream iIOPInputStream = message.getInputStream();
        try {
            while (!arrayList.isEmpty()) {
                Message message2 = (Message)arrayList.remove(0);
                iIOPInputStream.addChunks(message2.getInputStream());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return message;
    }

    final void handleIncomingRequest(Message message) throws IOException {
        block32: {
            ObjectKey objectKey;
            IOR iOR;
            Object object;
            RequestMessage requestMessage;
            block31: {
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    this.pfull("handleIncomingRequest");
                }
                requestMessage = (RequestMessage)message;
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    this.p("handleIncomingRequest:  GIOP 1." + requestMessage.getMinorVersion() + " (Connection GIOP 1." + this.getMinorVersion());
                }
                ServiceContext serviceContext = requestMessage.getServiceContext(15);
                serviceContext = requestMessage.getServiceContext(15);
                if (serviceContext != null) {
                    boolean bl;
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        this.p("handling SAS request");
                    }
                    if (bl = ((SASServiceContext)(object = (SASServiceContext)serviceContext)).handleSASRequest(requestMessage, this)) {
                        return;
                    }
                }
                object = null;
                try {
                    iOR = null;
                    objectKey = requestMessage.getObjectKey();
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        this.p("ObjectKey = " + objectKey);
                    }
                    if (objectKey.isWLSKey()) {
                        if (!objectKey.isLocalKey() && objectKey.getObjectID() > 256) {
                            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                                this.p("Request throws OBJECT_NOT_EXIST: " + objectKey);
                            }
                            throw this.replyNoSuchObject("Transient reference expired.");
                        }
                        object = new InboundRequestImpl(this, requestMessage);
                        break block31;
                    }
                    if (objectKey.isNamingKey()) {
                        if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                            IIOPLogger.logDebugTransport((String)"REQUEST: NameService");
                        }
                        if (!this.supportsForwarding()) {
                            object = new InboundRequestImpl(this, requestMessage, 8);
                            break block31;
                        }
                        this.handleNamingRequest(requestMessage);
                        return;
                    }
                    iOR = objectKey.getInitialReference();
                    if (iOR != null) {
                        this.handleInitialReference(requestMessage, iOR);
                        return;
                    }
                    if (objectKey.isBootstrapKey()) {
                        this.handleBootstrapRequest(requestMessage);
                        return;
                    }
                    if (objectKey.getTarget() == null) {
                        this.routeRequest(requestMessage);
                        return;
                    }
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        this.p("Request gets object not found");
                    }
                    throw this.replyNoSuchObject("Object not exported");
                }
                catch (RemoteException remoteException) {
                    throw this.replyNoSuchObject("Object not exported");
                }
            }
            if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                IIOPLogger.logDebugTransport((String)("REQUEST(" + requestMessage.getRequestID() + "): for object " + ((InboundRequestImpl)object).getObjectID() + ", " + requestMessage.getOperationName() + "()"));
            }
            try {
                PropagationContextImpl propagationContextImpl;
                iOR = ((InboundRequestImpl)object).getServerReference();
                if (iOR instanceof Collectable) {
                    ((Collectable)iOR).renewLease();
                }
                if ((objectKey = ((InboundRequestImpl)object).getRuntimeMethodDescriptor(iOR.getDescriptor())) == null) {
                    String string = requestMessage.getOperationName();
                    IIOPLogger.logMethodParseFailure((String)string);
                    if (!((InboundRequestImpl)object).isOneWay()) {
                        new ReplyOnError(((InboundRequestImpl)object).getOutboundResponse(), (Throwable)new BAD_OPERATION("Could not dispatch to method name: " + string, 0, CompletionStatus.COMPLETED_NO));
                    }
                    return;
                }
                if (objectKey.requiresTransaction() && (propagationContextImpl = (PropagationContextImpl)requestMessage.getServiceContext(0)) != null && (propagationContextImpl.isNull() || IIOPService.txMechanism == 0)) {
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        this.p("null tx when one was required or not allowed.");
                    }
                    new ReplyOnError(((InboundRequestImpl)object).getOutboundResponse(), (Throwable)new UnmarshalException("A transaction is required or not allowed"));
                    return;
                }
                ((InboundRequestImpl)object).registerAsPending();
                iOR.dispatch((InboundRequest)object);
                if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                    IIOPLogger.logDebugTransport((String)("REQUEST(" + requestMessage.getRequestID() + "): dispatched"));
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    noSuchObjectException.printStackTrace();
                }
                if (!((InboundRequestImpl)object).isOneWay()) {
                    new ReplyOnError(((InboundRequestImpl)object).getOutboundResponse(), (Throwable)this.replyNoSuchObject("No such oid: " + ((InboundRequestImpl)object).getObjectID()));
                }
            }
            catch (RemoteException remoteException) {
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    remoteException.printStackTrace();
                }
                if (((InboundRequestImpl)object).isOneWay()) break block32;
                new ReplyOnError(((InboundRequestImpl)object).getOutboundResponse(), (Throwable)new INV_OBJREF("Could not dispatch to oid: " + ((InboundRequestImpl)object).getObjectID(), 0, CompletionStatus.COMPLETED_NO));
            }
        }
    }

    final void routeRequest(RequestMessage requestMessage) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.pfull("routeRequest()");
        }
        ObjectKey objectKey = requestMessage.getObjectKey();
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("routeRequest(): route based on: " + objectKey);
        }
        Identity identity = objectKey.getTransientIdentity();
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("routeRequest(): identity = " + identity);
        }
        EndPoint endPoint = EndPointManager.getRoute(identity);
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("got route... " + endPoint);
        }
        if (endPoint == null) {
            throw this.replyNoSuchObject("Object not exported");
        }
        new MessageForwardingHandler(endPoint, requestMessage, identity, this.getConnection().getConnectionKey());
    }

    final void handleBootstrapRequest(RequestMessage requestMessage) throws IOException {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("handleBoostrapRequest");
        }
        ReplyMessage replyMessage = new ReplyMessage((EndPoint)this, requestMessage, requestMessage.getOutboundServiceContexts(), 0);
        IIOPOutputStream iIOPOutputStream = replyMessage.getOutputStream();
        replyMessage.write(iIOPOutputStream);
        String string = requestMessage.getOperationName();
        if (string.equals("get")) {
            String string2 = requestMessage.getInputStream().read_string();
            if (string2.equals("NameService")) {
                ClusterServices clusterServices = ClusterServices.getServices();
                IOR iOR = null;
                iOR = !this.supportsForwarding() || clusterServices.getLocationForwardPolicy() == 0 ? RootNamingContextImpl.getRootNamingContext().getIOR() : NamingContextImpl.getBootstrapIOR(clusterServices.getNextMember());
                iOR.write(iIOPOutputStream);
                if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                    IIOPLogger.logDebugTransport((String)("LOCATION_FORWARD(" + requestMessage.getRequestID() + "): to " + iOR));
                }
            } else {
                IOR iOR = InitialReferences.getInitialReference(string2);
                if (iOR == null) {
                    throw this.replyNoSuchObject("Object not exported");
                }
                iOR.write(iIOPOutputStream);
            }
        } else if (string.equals("list")) {
            String[] stringArray = InitialReferences.getServiceList();
            iIOPOutputStream.write_long(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                iIOPOutputStream.write_string(stringArray[i]);
            }
        }
        new ReplyHandler(this, replyMessage);
    }

    private final void handleNamingRequest(RequestMessage requestMessage) throws IOException {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("handleNamingRequest");
        }
        ClusterServices clusterServices = ClusterServices.getServices();
        IOR iOR = null;
        iOR = clusterServices == null || ClusterServices.getServices().getLocationForwardPolicy() == 0 ? RootNamingContextImpl.getRootNamingContext().getIOR() : NamingContextImpl.getBootstrapIOR(clusterServices.getNextMember());
        if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
            IIOPLogger.logDebugTransport((String)("LOCATION_FORWARD(" + requestMessage.getRequestID() + "): to " + iOR));
        }
        ReplyMessage replyMessage = new ReplyMessage((EndPoint)this, requestMessage, requestMessage.getOutboundServiceContexts(), iOR);
        IIOPOutputStream iIOPOutputStream = replyMessage.getOutputStream();
        replyMessage.write(iIOPOutputStream);
        new ReplyHandler(this, replyMessage);
    }

    final void handleInitialReference(RequestMessage requestMessage, IOR iOR) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("handleInitialReference: LOCATION_FORWARD to: " + iOR);
        }
        ReplyMessage replyMessage = new ReplyMessage((EndPoint)this, requestMessage, requestMessage.getOutboundServiceContexts(), iOR);
        IIOPOutputStream iIOPOutputStream = replyMessage.getOutputStream();
        replyMessage.write(iIOPOutputStream);
        new ReplyHandler(this, replyMessage);
    }

    final void handleIncomingResponse(Message message) throws IOException {
        ForwardingContext forwardingContext;
        ReplyMessage replyMessage = (ReplyMessage)message;
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("handleIncomingResponse():  GIOP 1." + replyMessage.getMinorVersion() + " (Connection GIOP 1." + this.getMinorVersion());
        }
        if (replyMessage.getMinorVersion() < this.getMinorVersion()) {
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                this.p("dropping to GIOP 1." + replyMessage.getMinorVersion() + " for " + this);
            }
            this.c.setMinorVersion(replyMessage.getMinorVersion());
        }
        if ((forwardingContext = (ForwardingContext)replyMessage.getServiceContext(1111834889)) == null) {
            PropagationContextImpl propagationContextImpl;
            int n = replyMessage.getRequestID();
            if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                IIOPLogger.logDebugTransport((String)("REPLY(" + n + "): " + replyMessage.getStatusAsString()));
            }
            SequencedRequestMessage sequencedRequestMessage = this.getPendingResponse(n);
            if (replyMessage.getServiceContext(0) == null && sequencedRequestMessage != null && (propagationContextImpl = (PropagationContextImpl)sequencedRequestMessage.getServiceContext(0)) != null) {
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    this.p("handleIncomingResponse(): adding tx context to reply");
                }
                replyMessage.addServiceContext(propagationContextImpl);
            }
            sequencedRequestMessage.notify(replyMessage);
            this.removePendingResponse(n);
            return;
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("forwarding response to: " + forwardingContext);
        }
        EndPoint endPoint = EndPointManager.getForwardingDestination(forwardingContext.getConnectionKey());
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("got destination: " + endPoint);
        }
        new MessageForwardingHandler(endPoint, replyMessage, null, null);
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("done!");
        }
    }

    final void handleLocateReply(Message message) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("handleLocateReply");
        }
        LocateReplyMessage locateReplyMessage = (LocateReplyMessage)message;
        int n = locateReplyMessage.getRequestID();
        if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
            IIOPLogger.logDebugTransport((String)("LOCATE_REPLY(" + n + ")"));
        }
        LocateRequestMessage locateRequestMessage = (LocateRequestMessage)this.removePendingResponse(n);
        locateRequestMessage.notify(locateReplyMessage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void handleLocateRequest(Message message) throws IOException {
        LocateReplyMessage locateReplyMessage;
        ObjectKey objectKey;
        LocateRequestMessage locateRequestMessage = (LocateRequestMessage)message;
        if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
            IIOPLogger.logDebugTransport((String)("LOCATE_REQUEST(" + locateRequestMessage.getRequestID() + ")"));
        }
        if ((objectKey = locateRequestMessage.getObjectKey()).isWLSKey()) {
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                this.p("got this one... " + objectKey.getObjectID() + " interface = " + objectKey.getInterfaceName() + " oid = " + objectKey.getObjectID());
            }
            IOR iOR = null;
            if (!objectKey.isLocalKey()) throw new AssertionError("LocateRequest for non-local object");
            iOR = new IOR(objectKey.getInterfaceName(), objectKey);
            locateReplyMessage = new LocateReplyMessage(locateRequestMessage, iOR, 1);
        } else if (objectKey.isBootstrapKey()) {
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                this.p("got NameService request");
            }
            IOR iOR = RootNamingContextImpl.getRootNamingContext().getIOR();
            locateReplyMessage = new LocateReplyMessage(locateRequestMessage, iOR, 2);
        } else {
            IOR iOR = objectKey.getInitialReference();
            if (iOR != null) {
                locateReplyMessage = new LocateReplyMessage(locateRequestMessage, iOR, 2);
            } else {
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    this.p("don't have this one... " + objectKey.getObjectID());
                }
                locateReplyMessage = new LocateReplyMessage(locateRequestMessage, 0);
            }
        }
        locateReplyMessage.write(locateReplyMessage.getOutputStream());
        new ReplyHandler(this, locateReplyMessage);
    }

    public final void send(IIOPOutputStream iIOPOutputStream) throws RemoteException {
        if (Kernel.getDebug().getDebugIIOP() || debugMarshal.isEnabled() || debugIIOPMarshal.isDebugEnabled()) {
            IIOPLogger.logDebugMarshal((String)("send [" + this.getServerChannel().getProtocol() + "] to " + this.getConnection().getConnectionKey() + " on " + this.getServerChannel()));
        }
        try {
            this.c.send(iIOPOutputStream);
        }
        catch (IOException iOException) {
            if (Kernel.getDebug().getDebugIIOP() || debugMarshal.isEnabled() || debugIIOPMarshal.isDebugEnabled()) {
                IIOPLogger.logSendFailure((IOException)iOException);
            }
            this.conMan.handleExceptionSending(this.c, iOException);
            throw new MarshalException("IOException while sending", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Message sendReceive(SequencedRequestMessage sequencedRequestMessage, int n) throws RemoteException {
        this.registerPendingResponse(sequencedRequestMessage);
        if (n != 0 && this.negotiatedRequestId >= 0) {
            Object object = this.bootstrapLock;
            synchronized (object) {
                if (this.negotiatedRequestId == 0) {
                    this.negotiatedRequestId = sequencedRequestMessage.getRequestID();
                    this.bootstrapFlags = n;
                }
            }
        }
        this.send(sequencedRequestMessage.getOutputStream());
        try {
            sequencedRequestMessage.waitForData();
        }
        catch (RequestTimeoutException requestTimeoutException) {
            throw requestTimeoutException;
        }
        catch (Exception exception) {
            throw new UnmarshalException("Exception waiting for response", exception);
        }
        catch (Throwable throwable) {
            throw new UnmarshalException("Throwable waiting for response (" + throwable.getClass().getName() + ") " + throwable.getMessage());
        }
        return sequencedRequestMessage.getReply();
    }

    public final Message sendReceive(SequencedRequestMessage sequencedRequestMessage) throws RemoteException {
        return this.sendReceive(sequencedRequestMessage, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendDeferred(SequencedRequestMessage sequencedRequestMessage, int n) throws RemoteException {
        this.registerPendingResponse(sequencedRequestMessage);
        if (n != 0 && this.negotiatedRequestId >= 0) {
            Object object = this.bootstrapLock;
            synchronized (object) {
                if (this.negotiatedRequestId == 0) {
                    this.negotiatedRequestId = sequencedRequestMessage.getRequestID();
                    this.bootstrapFlags = n;
                }
            }
        }
        this.send(sequencedRequestMessage.getOutputStream());
    }

    public final void sendDeferred(SequencedRequestMessage sequencedRequestMessage) throws RemoteException {
        this.sendDeferred(sequencedRequestMessage, 0);
    }

    public boolean hasPendingResponses() {
        return this.pendingResponses.size() > 0 || this.pendingCount > 0;
    }

    public final synchronized void cleanupPendingResponses(Throwable throwable) {
        Enumeration enumeration = this.pendingResponses.elements();
        while (enumeration.hasMoreElements()) {
            ((SequencedRequestMessage)enumeration.nextElement()).notify(throwable);
        }
        this.deliverHeartbeatMonitorListenerException(throwable instanceof Exception ? (Exception)throwable : new Exception(throwable));
    }

    public final boolean isSecure() {
        return this.secure;
    }

    public final int getMinorVersion() {
        return this.c.getMinorVersion();
    }

    public void setMessageServiceContext(Message message, ServiceContext serviceContext) {
        if (serviceContext != null && this.getMinorVersion() > 0) {
            message.addServiceContext(serviceContext);
        }
    }

    public ServiceContext getMessageServiceContext(Message message, int n) {
        return message.getServiceContext(n);
    }

    public AuthenticatedSubject getSubject(RequestMessage requestMessage) {
        AuthenticatedSubject authenticatedSubject;
        ServiceContext serviceContext = null;
        serviceContext = requestMessage.getServiceContext(1111834882);
        if (serviceContext != null) {
            AuthenticatedUser authenticatedUser;
            if (debugSecurity.isEnabled() || debugIIOPSecurity.isDebugEnabled()) {
                IIOPLogger.logDebugSecurity((String)("getting user " + ((VendorInfoSecurity)serviceContext).getUser() + " from vendor service context"));
            }
            if ((authenticatedUser = ((VendorInfoSecurity)serviceContext).getUser()) == null) {
                return SubjectUtils.getAnonymousSubject();
            }
            return SecurityServiceManager.getASFromAUInServerOrClient((AuthenticatedUser)authenticatedUser);
        }
        serviceContext = requestMessage.getServiceContext(15);
        if (serviceContext != null) {
            AuthenticatedSubject authenticatedSubject2 = ((SASServiceContext)serviceContext).getSubject();
            if (authenticatedSubject2 != null) {
                if (debugSecurity.isEnabled() || debugIIOPSecurity.isDebugEnabled()) {
                    IIOPLogger.logDebugSecurity((String)("getting subject " + authenticatedSubject2 + " from CSIv2 service context"));
                }
                return authenticatedSubject2;
            }
            return SubjectUtils.getAnonymousSubject();
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("getting user: " + this.c.getUser() + " from connection");
        }
        if ((authenticatedSubject = this.c.getUser()) == null) {
            return SubjectUtils.getAnonymousSubject();
        }
        return authenticatedSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubject(RequestMessage requestMessage, AuthenticatedSubject authenticatedSubject) {
        if (authenticatedSubject == null) {
            authenticatedSubject = SubjectUtils.getAnonymousSubject();
        }
        if (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            authenticatedSubject = this.getPeerInfo() == null || !Kernel.isServer() ? SubjectUtils.getAnonymousSubject() : SecurityServiceManager.sendASToWire((AuthenticatedSubject)authenticatedSubject);
        }
        if (SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject) && this.getPeerInfo() != null) {
            return;
        }
        ClientSecurityContext clientSecurityContext = this.getClientContext(authenticatedSubject);
        if (!(clientSecurityContext == null || Kernel.isServer() && clientSecurityContext.needCredentials() && this.getPeerInfo() != null && EndPointImpl.getPasswordCredentials(authenticatedSubject) != null)) {
            if (debugSecurity.isEnabled() || debugIIOPSecurity.isDebugEnabled()) {
                IIOPLogger.logDebugSecurity((String)("adding client security context for " + authenticatedSubject));
            }
            requestMessage.addServiceContext(clientSecurityContext.getMessageInContext());
        } else {
            Object object;
            CompoundSecMechList compoundSecMechList = requestMessage.getMechanismListForRequest();
            if (compoundSecMechList != null && compoundSecMechList.useSAS()) {
                if (SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject)) {
                    if (debugSecurity.isEnabled() || debugIIOPSecurity.isDebugEnabled()) {
                        IIOPLogger.logDebugSecurity((String)("making anonymous outbound call using CSIv2 for " + authenticatedSubject));
                    }
                    this.putSASClientContext(requestMessage, compoundSecMechList, authenticatedSubject, false);
                    return;
                }
                object = EndPointImpl.getPasswordCredentials(authenticatedSubject);
                if (object != null && (debugSecurity.isEnabled() || debugIIOPSecurity.isDebugEnabled())) {
                    IIOPLogger.logDebugSecurity((String)("found password credentials for " + authenticatedSubject + " using CSIv2"));
                }
                if (object != null || this.getPeerInfo() == null || !Kernel.isServer()) {
                    this.putSASClientContext(requestMessage, compoundSecMechList, authenticatedSubject, object == null);
                    return;
                }
            } else if (debugSecurity.isEnabled() || debugIIOPSecurity.isDebugEnabled()) {
                IIOPLogger.logDebugSecurity((String)"target does not support CSIv2");
            }
            if (authenticatedSubject != null) {
                if (debugSecurity.isEnabled() || debugIIOPSecurity.isDebugEnabled()) {
                    IIOPLogger.logDebugSecurity((String)("adding outbound vendor security context for " + authenticatedSubject));
                }
                object = this.statefulClientContextTable;
                synchronized (object) {
                    ClientSecurityContext clientSecurityContext2 = new ClientSecurityContext(authenticatedSubject);
                    this.statefulClientContextTable.put(authenticatedSubject, clientSecurityContext2);
                    this.setMessageServiceContext(requestMessage, clientSecurityContext2.getMessageInContext());
                }
            }
        }
    }

    private static final PasswordCredential getPasswordCredentials(AuthenticatedSubject authenticatedSubject) {
        PasswordCredential passwordCredential = null;
        AuthenticatedSubject authenticatedSubject2 = authenticatedSubject;
        Set set = authenticatedSubject2.getPrivateCredentials((AbstractSubject)kernelId, PasswordCredential.class);
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            passwordCredential = (PasswordCredential)iterator.next();
        }
        return passwordCredential;
    }

    public Object getInboundRequestTxContext(RequestMessage requestMessage) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("getInboundRequestTxContext()");
        }
        ServiceContext serviceContext = null;
        serviceContext = requestMessage.getServiceContext(1111834881);
        if (serviceContext != null) {
            return ((VendorInfoTx)serviceContext).getTxContext();
        }
        serviceContext = requestMessage.getServiceContext(0);
        if (serviceContext != null) {
            if (!Kernel.isServer()) {
                return serviceContext;
            }
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                this.p("getInboundRequestTxContext(" + serviceContext + ")");
            }
            try {
                final ServiceContext serviceContext2 = serviceContext;
                Object object = SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)((AuthenticatedSubject)requestMessage.getSubject()), (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return OTSHelper.importTransaction((PropagationContextImpl)serviceContext2, 0);
                    }
                });
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    this.p("getInboundResponseTxContext(): " + object);
                }
                return object;
            }
            catch (PrivilegedActionException privilegedActionException) {
                IIOPLogger.logOTSError((String)"JTA error while importing transaction", (Throwable)((XAException)privilegedActionException.getException()));
                throw new TRANSACTION_ROLLEDBACK(privilegedActionException.getException().getMessage());
            }
        }
        return this.c.getTxContext();
    }

    public void setOutboundResponseTxContext(ReplyMessage replyMessage, Object object) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("setOutboundResponseTxContext(" + (object == null ? null : object.getClass().getName()) + ")");
        }
        if (object != null && this.c.getTxContext() == null) {
            if (object instanceof weblogic.transaction.internal.PropagationContext) {
                try {
                    if (IIOPService.txMechanism == 2) {
                        weblogic.transaction.internal.PropagationContext propagationContext = (weblogic.transaction.internal.PropagationContext)object;
                        propagationContext.getTransaction().setProperty("weblogic.transaction.protocol", (Serializable)((Object)"iiop"));
                        this.setMessageServiceContext(replyMessage, new VendorInfoTx(propagationContext));
                    }
                    this.setMessageServiceContext(replyMessage, OTSHelper.exportTransaction((weblogic.transaction.internal.PropagationContext)object, 1));
                }
                catch (Throwable throwable) {
                    IIOPLogger.logOTSError((String)"JTA error while exporting transaction", (Throwable)throwable);
                    throw new TRANSACTION_ROLLEDBACK(throwable.getMessage());
                }
            } else if (object instanceof PropagationContext) {
                this.setMessageServiceContext(replyMessage, new PropagationContextImpl((PropagationContext)object));
            }
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("setOutboundResponseTxContext(): " + object);
        }
    }

    public void setOutboundRequestTxContext(RequestMessage requestMessage, Object object) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("setOutboundRequestTxContext(" + (object == null ? null : object.getClass().getName()) + ")");
        }
        if (object != null) {
            if (object instanceof weblogic.transaction.internal.PropagationContext) {
                try {
                    if (IIOPService.txMechanism == 2) {
                        weblogic.transaction.internal.PropagationContext propagationContext = (weblogic.transaction.internal.PropagationContext)object;
                        propagationContext.getTransaction().setProperty("weblogic.transaction.protocol", (Serializable)((Object)"iiop"));
                        this.setMessageServiceContext(requestMessage, new VendorInfoTx(propagationContext));
                    }
                    this.setMessageServiceContext(requestMessage, OTSHelper.exportTransaction((weblogic.transaction.internal.PropagationContext)object, 0));
                }
                catch (Throwable throwable) {
                    IIOPLogger.logOTSError((String)"JTA error while exporting transaction", (Throwable)throwable);
                    throw new TRANSACTION_ROLLEDBACK(throwable.getMessage());
                }
            } else if (object instanceof PropagationContext) {
                this.setMessageServiceContext(requestMessage, new PropagationContextImpl((PropagationContext)object));
            }
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("setOutboundRequestTxContext(): " + object);
        }
    }

    public Object getInboundResponseTxContext(ReplyMessage replyMessage) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("getInboundResponseTxContext()");
        }
        ServiceContext serviceContext = null;
        serviceContext = replyMessage.getServiceContext(1111834881);
        if (serviceContext != null) {
            return ((VendorInfoTx)serviceContext).getTxContext();
        }
        serviceContext = replyMessage.getServiceContext(0);
        if (serviceContext != null) {
            if (!Kernel.isServer()) {
                return serviceContext;
            }
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                this.p("getInboundResponseTxContext(" + serviceContext + ")");
            }
            try {
                Transaction transaction = OTSHelper.importTransaction((PropagationContextImpl)serviceContext, 1);
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    this.p("getInboundResponseTxContext(): " + transaction);
                }
                return transaction;
            }
            catch (XAException xAException) {
                IIOPLogger.logOTSError((String)"JTA error while importing transaction", (Throwable)xAException);
                throw new TRANSACTION_ROLLEDBACK(xAException.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putSASClientContext(RequestMessage requestMessage, CompoundSecMechList compoundSecMechList, AuthenticatedSubject authenticatedSubject, boolean bl) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            this.p("putSASClientContext(" + authenticatedSubject + "): adding SAS service context");
        }
        HashMap hashMap = this.statefulClientContextTable;
        synchronized (hashMap) {
            ClientSecurityContext clientSecurityContext = (ClientSecurityContext)this.statefulClientContextTable.get(authenticatedSubject);
            if (clientSecurityContext == null || clientSecurityContext.needCredentials() && EndPointImpl.getPasswordCredentials(authenticatedSubject) != null) {
                clientSecurityContext = new SASServiceContext(compoundSecMechList, authenticatedSubject, this).getClientContext();
                clientSecurityContext.setNeedCredentials(bl);
                this.statefulClientContextTable.put(authenticatedSubject, clientSecurityContext);
                this.statefulClientContextIdTable.put(clientSecurityContext.getClientContextId(), (Object)authenticatedSubject);
            }
            requestMessage.addServiceContext(clientSecurityContext.getMessageInContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSASClientContext(long l) {
        HashMap hashMap = this.statefulClientContextTable;
        synchronized (hashMap) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)this.statefulClientContextIdTable.remove(l);
            if (authenticatedSubject != null) {
                this.statefulClientContextTable.remove(authenticatedSubject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void establishSASClientContext(long l) {
        HashMap hashMap = this.statefulClientContextTable;
        synchronized (hashMap) {
            ClientSecurityContext clientSecurityContext = (ClientSecurityContext)this.statefulClientContextTable.get(this.statefulClientContextIdTable.get(l));
            if (clientSecurityContext != null) {
                clientSecurityContext.contextEstablished();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ClientSecurityContext getClientContext(AuthenticatedSubject authenticatedSubject) {
        HashMap hashMap = this.statefulClientContextTable;
        synchronized (hashMap) {
            return (ClientSecurityContext)this.statefulClientContextTable.get(authenticatedSubject);
        }
    }

    public final synchronized long getNextClientContextId() {
        return ++this.nextClientContextId;
    }

    public synchronized int getNextRequestID() {
        return ++this.nextRequestID;
    }

    public synchronized void incrementPendingRequests() {
        ++this.pendingCount;
    }

    public synchronized void decrementPendingRequests() {
        --this.pendingCount;
    }

    public final SecurityContext putSecurityContext(long l, SecurityContext securityContext) {
        return (SecurityContext)this.securityContextTable.put(l, (Object)securityContext);
    }

    public final SecurityContext getSecurityContext(long l) {
        return (SecurityContext)this.securityContextTable.get(l);
    }

    public final SecurityContext removeSecurityContext(long l) {
        return (SecurityContext)this.securityContextTable.remove(l);
    }

    public HostID getHostID() {
        if (this.hostID == null) {
            ConnectionKey connectionKey = this.getConnection().getConnectionKey();
            this.hostID = new HostIDImpl(connectionKey.getAddress(), connectionKey.getPort());
        }
        return this.hostID;
    }

    public Channel getRemoteChannel() {
        return this.getConnection().getRemoteChannel();
    }

    public ServerChannel getServerChannel() {
        return this.getConnection().getChannel();
    }

    public boolean isDead() {
        return this.c == null || this.c.isDead();
    }

    public boolean isUnresponsive() {
        return this.isDead();
    }

    public OutboundRequest getOutboundRequest(RemoteReference remoteReference, RuntimeMethodDescriptor runtimeMethodDescriptor, String string) throws IOException {
        return null;
    }

    public OutboundRequest getOutboundRequest(RemoteReference remoteReference, RuntimeMethodDescriptor runtimeMethodDescriptor, String string, Protocol protocol) throws IOException {
        return null;
    }

    public String getClusterURL(ObjectInput objectInput) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDisconnectListener(Remote remote, DisconnectListener disconnectListener) {
        HashMap hashMap = this.disconnectListeners;
        synchronized (hashMap) {
            HeartbeatKey heartbeatKey = new HeartbeatKey(remote, disconnectListener);
            this.disconnectListeners.put(heartbeatKey, disconnectListener);
            this.getConnection().setHeartbeatStub(remote);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDisconnectListener(Remote remote, DisconnectListener disconnectListener) {
        HashMap hashMap = this.disconnectListeners;
        synchronized (hashMap) {
            HeartbeatKey heartbeatKey = new HeartbeatKey(remote, disconnectListener);
            this.disconnectListeners.remove(heartbeatKey);
            if (this.disconnectListeners.isEmpty()) {
                this.getConnection().setHeartbeatStub(null);
            }
        }
        return true;
    }

    public void disconnect() {
        throw new NotImplementedException("disconnect not implemented in IIOP");
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverHeartbeatMonitorListenerException(Exception exception) {
        HashMap hashMap = this.disconnectListeners;
        synchronized (hashMap) {
            for (DisconnectListener disconnectListener : this.disconnectListeners.values()) {
                WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new HeartbeatMonitorExceptionHandler(disconnectListener, exception));
            }
            this.disconnectListeners.clear();
        }
    }

    private static class HeartbeatKey {
        Remote stub;
        DisconnectListener l;
        int hashCode;

        public HeartbeatKey(Remote remote, DisconnectListener disconnectListener) {
            this.stub = remote;
            this.l = disconnectListener;
            this.hashCode = this.stub != null && this.l != null ? this.stub.hashCode() ^ this.l.hashCode() : super.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof HeartbeatKey)) {
                return false;
            }
            HeartbeatKey heartbeatKey = (HeartbeatKey)object;
            return this.stub == heartbeatKey.stub && this.l == heartbeatKey.l;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private class HeartbeatMonitorExceptionHandler
    implements Runnable {
        private DisconnectListener l;
        private Exception e;

        HeartbeatMonitorExceptionHandler(DisconnectListener disconnectListener, Exception exception) {
            this.l = disconnectListener;
            this.e = exception;
        }

        public final void run() {
            ServerIdentity serverIdentity;
            if (EndPointImpl.this.getRemoteCodeBase() != null && (serverIdentity = EndPointImpl.this.getConnection().getRemoteCodeBase().getProfile().getObjectKey().getTarget()) != null && !serverIdentity.isClient()) {
                this.l.onDisconnect((DisconnectEvent)new ServerDisconnectEventImpl(this.e, serverIdentity.getServerName()));
                return;
            }
            this.l.onDisconnect((DisconnectEvent)new DisconnectEventImpl((Throwable)this.e));
        }
    }
}

