/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.rmi.server.ExportException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.CodeSetsComponent;
import weblogic.iiop.Connection;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.ConnectionManager;
import weblogic.iiop.EndPoint;
import weblogic.iiop.HostIDImpl;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPService;
import weblogic.iiop.IOPProfile;
import weblogic.iiop.IOR;
import weblogic.iiop.MuxableSocketIIOP;
import weblogic.iiop.MuxableSocketIIOPS;
import weblogic.iiop.ObjectKey;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Identity;
import weblogic.rmi.spi.EndPointFinder;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.utils.Utilities;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.SyncKeyTable;

public final class EndPointManager
implements EndPointFinder {
    private static final HashMap outboundEndPointTable = new HashMap();
    private static final IdentityHashMap inboundEndPointTable = new IdentityHashMap();
    private static final HashMap bidirEndPointTable = new HashMap();
    private static final ConcurrentHashMap routingTable = new ConcurrentHashMap();
    private static final boolean DEBUG = false;
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private static final DebugLogger debugIIOPTransport = DebugLogger.getDebugLogger((String)"DebugIIOPTransport");
    private static final boolean DEBUG_TUNNELING = false;
    private static final WeakHashMap outboundConnectionLockTable = new WeakHashMap();

    static void dumpTables() {
        EndPointManager.p("\nDump tables: \n Outbound EndPointTable: " + outboundEndPointTable.toString() + "\n Inbound EndPointTable: " + inboundEndPointTable.toString() + "\n Bidir EndPointTable: " + bidirEndPointTable.toString() + "\n RoutingTable: " + routingTable.toString() + "\nDumpTables complete.");
    }

    static void p(String string) {
        System.err.println("<EndPointManager>: " + string);
    }

    public static EndPoint findEndPoint(Connection connection) {
        return (EndPoint)inboundEndPointTable.get(connection);
    }

    public static EndPoint findEndPoint(ConnectionKey connectionKey) {
        return (EndPoint)bidirEndPointTable.get(connectionKey);
    }

    public static EndPoint findOrCreateEndPoint(Connection connection) throws IOException {
        EndPoint endPoint = (EndPoint)inboundEndPointTable.get(connection.getConnectionKey());
        if (endPoint == null) {
            endPoint = EndPointManager.createEndPoint(connection);
        }
        return endPoint;
    }

    private static synchronized EndPoint createEndPoint(Connection connection) throws IOException {
        EndPoint endPoint = (EndPoint)inboundEndPointTable.get(connection);
        if (endPoint == null) {
            endPoint = connection.getEndPoint();
            connection.setFlag(8);
            if (connection.isStateful()) {
                inboundEndPointTable.put(connection, endPoint);
                Debug.assertion((bidirEndPointTable.get(connection.getConnectionKey()) == null ? 1 : 0) != 0);
                bidirEndPointTable.put(connection.getConnectionKey(), endPoint);
            }
        }
        return endPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateConnection(Connection connection, ConnectionKey connectionKey) {
        ConnectionKey connectionKey2 = connection.getConnectionKey();
        if (connectionKey2.equals(connectionKey) || inboundEndPointTable.get(connection) == null) {
            return;
        }
        if (bidirEndPointTable.get(connectionKey) != null) return;
        Class<EndPointManager> clazz = EndPointManager.class;
        synchronized (EndPointManager.class) {
            EndPoint endPoint;
            if (bidirEndPointTable.get(connectionKey) == null && (endPoint = (EndPoint)bidirEndPointTable.get(connectionKey2)) != null) {
                bidirEndPointTable.remove(connectionKey2);
                bidirEndPointTable.put(connectionKey, endPoint);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            connection.setConnectionKey(connectionKey);
            return;
        }
    }

    public static synchronized void updateRoutingTable(Identity identity, ConnectionKey connectionKey) {
        ConnectionKey connectionKey2 = (ConnectionKey)routingTable.get(identity);
        if (connectionKey2 == null) {
            routingTable.put(identity, connectionKey);
        }
    }

    public static synchronized void purgeRoutingTable(Identity identity) {
        routingTable.remove(identity);
    }

    public static synchronized EndPoint getRoute(Identity identity) {
        if (identity == null) {
            return null;
        }
        Object v = routingTable.get(identity);
        EndPoint endPoint = null;
        if (v != null) {
            endPoint = (EndPoint)bidirEndPointTable.get(v);
        }
        return endPoint;
    }

    public static synchronized EndPoint getForwardingDestination(ConnectionKey connectionKey) {
        return (EndPoint)bidirEndPointTable.get(connectionKey);
    }

    public static EndPoint findOrCreateEndPoint(IOR iOR, String string, boolean bl) throws IOException {
        EndPoint endPoint = (EndPoint)outboundEndPointTable.get(iOR.getConnectionKey());
        if (endPoint == null || bl || endPoint.getConnection().isDead()) {
            endPoint = EndPointManager.createEndPoint(iOR, string, bl);
        } else if (!endPoint.getFlag(16) && iOR.isRemote()) {
            EndPointManager.negotiateConnection(endPoint, iOR);
        }
        return endPoint;
    }

    public static EndPoint findOrCreateEndPoint(IOR iOR) throws IOException {
        return EndPointManager.findOrCreateEndPoint(iOR, null, false);
    }

    public static EndPoint findOrCreateEndPoint(IOR iOR, String string) throws IOException {
        return EndPointManager.findOrCreateEndPoint(iOR, string, false);
    }

    public static EndPoint findEndPoint(IOR iOR) {
        return (EndPoint)outboundEndPointTable.get(iOR.getConnectionKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static EndPoint createEndPoint(IOR iOR, String string, boolean bl) throws IOException {
        Object object;
        Object object2;
        EndPoint endPoint = null;
        IOPProfile iOPProfile = iOR.getProfile();
        Object object3 = EndPointManager.class;
        // MONITORENTER : weblogic.iiop.EndPointManager.class
        endPoint = (EndPoint)outboundEndPointTable.get(iOR.getConnectionKey());
        if (endPoint != null && (bl || endPoint.getConnection().isDead())) {
            ConnectionManager.getConnectionManager().forceConnectionShutdown(endPoint.getConnection(), new EOFException("Forceful shutdown"));
            endPoint = null;
        } else if (endPoint == null && (endPoint = (EndPoint)bidirEndPointTable.get(iOR.getConnectionKey())) != null) {
            object2 = (SyncKeyTable)endPoint.getConnection().getProperty("weblogic.iiop.BiDirKeys");
            if (object2 == null || object2.get(iOR.getConnectionKey().hashCode()) == null) {
                endPoint = null;
            } else {
                outboundEndPointTable.put(iOR.getConnectionKey(), endPoint);
            }
        }
        if (endPoint != null) {
            EndPointManager.negotiateConnection(endPoint, iOR);
            // MONITOREXIT : object3
            return endPoint;
        }
        // MONITOREXIT : object3
        object2 = object3 = EndPointManager.getOutboundConnectionLock(iOR.getConnectionKey());
        // MONITORENTER : object2
        Object object4 = EndPointManager.class;
        // MONITORENTER : weblogic.iiop.EndPointManager.class
        endPoint = (EndPoint)outboundEndPointTable.get(iOR.getConnectionKey());
        if (endPoint != null && (bl || endPoint.getConnection().isDead())) {
            ConnectionManager.getConnectionManager().forceConnectionShutdown(endPoint.getConnection(), new EOFException("Forceful shutdown"));
            endPoint = null;
        }
        if (((ConnectionKey)(object = iOR.getConnectionKey())).isBidirSet()) {
            throw new IOException("client requested BiDir, but EndPoint is closed for address: " + ((ConnectionKey)object).getAddress() + " port: " + ((ConnectionKey)object).getPort());
        }
        // MONITOREXIT : object4
        if (endPoint == null) {
            Object object5;
            block29: {
                object4 = iOPProfile.getObjectKey();
                object = null;
                if (KernelStatus.isServer() && IIOPService.isTGIOPEnabled() && (((ObjectKey)object4).isWLEKey() || ((ObjectKey)object4).isWLSKey() && !((ObjectKey)object4).getWLEDomainId().equals(ObjectKey.getLocalDomainID()))) {
                    try {
                        object5 = Utilities.classForName((String)"weblogic.tgiop.TGIOPConnection", iOR.getClass());
                        Constructor constructor = ((Class)object5).getConstructor(String.class, String.class, Integer.TYPE);
                        object = (Connection)constructor.newInstance(((ObjectKey)object4).getWLEDomainId().toString(), iOPProfile.getHost(), new Integer(iOPProfile.getPort()));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new ExportException("TGIOPConnection constructor not found" + classNotFoundException);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new ExportException("Missing constructor TGIOPConnection: " + noSuchMethodException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new ExportException("TGIOPConnection constructor not public: " + illegalAccessException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new ExportException("Failed to instantiate TGIOPConnection: " + instantiationException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getTargetException();
                        if (throwable instanceof IOException) break block29;
                        if (throwable instanceof Exception) throw new ExportException("Failed to invoke constructor for TGIOPConnection: " + (Exception)throwable);
                        throwable = invocationTargetException;
                        throw new ExportException("Failed to invoke constructor for TGIOPConnection: " + (Exception)throwable);
                    }
                }
            }
            if (object == null) {
                if (iOR.isSecure()) {
                    object5 = iOPProfile.getSecureHost();
                    if (object5 == null) {
                        object5 = iOPProfile.getHost();
                    }
                    object = MuxableSocketIIOPS.createConnection(InetAddress.getByName(object5), iOPProfile.getSecurePort(), string).getConnection();
                } else {
                    object = MuxableSocketIIOP.createConnection(iOPProfile.getHostAddress(), iOPProfile.getPort(), string).getConnection();
                }
            }
            endPoint = object.getEndPoint();
            if (((Connection)object).isStateful()) {
                object5 = EndPointManager.class;
                // MONITORENTER : weblogic.iiop.EndPointManager.class
                outboundEndPointTable.put(((Connection)object).getConnectionKey(), endPoint);
                inboundEndPointTable.put(object, endPoint);
                // MONITOREXIT : object5
            }
        }
        // MONITOREXIT : object2
        EndPointManager.negotiateConnection(endPoint, iOR);
        return endPoint;
    }

    private static synchronized void negotiateConnection(EndPoint endPoint, IOR iOR) throws IOException {
        if (!endPoint.getFlag(16)) {
            IOPProfile iOPProfile = iOR.getProfile();
            Connection connection = endPoint.getConnection();
            connection.setMinorVersion(iOPProfile.getMinorVersion());
            if (iOR.isRemote()) {
                connection.setFlag(16);
                CodeSetsComponent codeSetsComponent = (CodeSetsComponent)iOPProfile.getComponent(1);
                if (codeSetsComponent != null) {
                    if (!(connection.getFlag(32) && connection.getFlag(64) && codeSetsComponent.supportedCharCodeSet(connection.getCharCodeSet()) && codeSetsComponent.supportedWcharCodeSet(connection.getWcharCodeSet()))) {
                        connection.setCodeSets(codeSetsComponent.negotiatedCharCodeSet(), codeSetsComponent.negotiatedWcharCodeSet());
                    }
                    if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                        IIOPLogger.logDebugTransport((String)("negotiated char codeset = " + Integer.toHexString(connection.getCharCodeSet()) + ", wchar codeset = " + Integer.toHexString(connection.getWcharCodeSet())));
                    }
                }
            }
        }
    }

    public static synchronized EndPoint removeConnection(Connection connection) {
        Object object;
        ConnectionKey connectionKey = connection.getConnectionKey();
        Object v = inboundEndPointTable.remove(connection);
        if (v != null) {
            object = outboundEndPointTable.get(connectionKey);
            if (object == v) {
                outboundEndPointTable.remove(connectionKey);
            }
            if ((object = bidirEndPointTable.get(connectionKey)) == v) {
                bidirEndPointTable.remove(connectionKey);
            }
        }
        if (routingTable.containsValue(connectionKey)) {
            object = routingTable.values().iterator();
            while (object.hasNext()) {
                ConnectionKey connectionKey2 = (ConnectionKey)object.next();
                if (!connectionKey.equals(connectionKey2)) continue;
                object.remove();
            }
        }
        return (EndPoint)v;
    }

    private static synchronized Object getOutboundConnectionLock(ConnectionKey connectionKey) {
        Object object = outboundConnectionLockTable.get(connectionKey);
        if (object == null) {
            object = new Object();
        }
        outboundConnectionLockTable.put(connectionKey, object);
        return object;
    }

    public boolean claimHostID(HostID hostID) {
        return hostID instanceof HostIDImpl;
    }

    public boolean claimServerURL(String string) {
        return false;
    }

    public weblogic.rmi.spi.EndPoint findOrCreateEndPoint(HostID hostID) {
        if (hostID instanceof HostIDImpl) {
            return (EndPoint)outboundEndPointTable.get(((HostIDImpl)hostID).getConnectionKey());
        }
        return null;
    }

    public weblogic.rmi.spi.EndPoint findEndPoint(HostID hostID) {
        if (hostID instanceof HostIDImpl) {
            return (EndPoint)outboundEndPointTable.get(((HostIDImpl)hostID).getConnectionKey());
        }
        return null;
    }

    public weblogic.rmi.spi.EndPoint findOrCreateEndPoint(String string) {
        return null;
    }
}

