/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.ProtocolHandlerIIOP;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.HostID;

public final class HostIDImpl
implements HostID,
Channel {
    private final InetSocketAddress address;
    private final String host;
    private final int port;

    public HostIDImpl(String string, int n) {
        this.host = string;
        this.port = n;
        this.address = new InetSocketAddress(string, n);
    }

    public int hashCode() {
        return this.getInetAddress().hashCode() ^ this.port;
    }

    public boolean equals(Object object) {
        if (object instanceof HostIDImpl) {
            HostIDImpl hostIDImpl = (HostIDImpl)object;
            return hostIDImpl.getInetAddress().equals(this.getInetAddress()) & hostIDImpl.port == this.port;
        }
        return false;
    }

    public int compareTo(Object object) {
        try {
            HostIDImpl hostIDImpl = (HostIDImpl)object;
            int n = this.getInetAddress().hashCode();
            int n2 = hostIDImpl.getInetAddress().hashCode();
            if (n == n2) {
                if (n == n2) {
                    return 0;
                }
                if (this.port < hostIDImpl.port) {
                    return -1;
                }
                return 1;
            }
            if (n < n2) {
                return -1;
            }
            return 1;
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)(object + " is not an instanceof HostIDImpl"));
        }
    }

    public String getPublicAddress() {
        return this.host;
    }

    public InetSocketAddress getPublicInetAddress() {
        return this.address;
    }

    public int getPublicPort() {
        return this.port;
    }

    public String toString() {
        return this.host + "/" + this.port;
    }

    public boolean isLocal() {
        return false;
    }

    public String objectToString() {
        return this.toString();
    }

    public InetAddress getInetAddress() {
        if (this.address.isUnresolved()) {
            throw new AssertionError((Object)("Invalid address: " + this.address));
        }
        return this.address.getAddress();
    }

    public String getProtocolPrefix() {
        return ProtocolHandlerIIOP.PROTOCOL_IIOP.getAsURLPrefix();
    }

    public boolean supportsTLS() {
        return false;
    }

    public ConnectionKey getConnectionKey() {
        return new ConnectionKey(this.host, this.port);
    }
}

