/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.rmi.Remote;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.Streamable;
import weblogic.iiop.AbstractMsgInput;
import weblogic.iiop.AbstractMsgOutput;
import weblogic.iiop.IDLMsgOutput;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.Utils;
import weblogic.utils.AssertionError;

public class IDLMsgInput
extends AbstractMsgInput
implements ObjectInput {
    public IDLMsgInput(IIOPInputStream iIOPInputStream) {
        super(iIOPInputStream);
    }

    public final String readLine() throws IOException {
        try {
            return this.delegate.read_string();
        }
        catch (SystemException systemException) {
            throw Utils.mapSystemException(systemException);
        }
    }

    public final String readUTF() throws IOException {
        try {
            return this.delegate.read_string();
        }
        catch (SystemException systemException) {
            throw Utils.mapSystemException(systemException);
        }
    }

    public final char readChar() throws IOException {
        try {
            return this.delegate.read_char();
        }
        catch (SystemException systemException) {
            throw Utils.mapSystemException(systemException);
        }
    }

    private final java.lang.Object readArray(Class clazz) throws ClassNotFoundException, IOException {
        int n = this.delegate.read_long();
        Class<?> clazz2 = clazz.getComponentType();
        java.lang.Object object = Array.newInstance(clazz2, n);
        if (!clazz2.isPrimitive()) {
            for (int i = 0; i < n; ++i) {
                ((java.lang.Object[])object)[i] = this.readObject(clazz2);
            }
        } else if (clazz2 == Byte.TYPE) {
            this.delegate.read_octet_array((byte[])object, 0, n);
        } else if (clazz2 == Character.TYPE) {
            this.delegate.read_wchar_array((char[])object, 0, n);
        } else if (clazz2 == Float.TYPE) {
            this.delegate.read_float_array((float[])object, 0, n);
        } else if (clazz2 == Double.TYPE) {
            this.delegate.read_double_array((double[])object, 0, n);
        } else if (clazz2 == Integer.TYPE) {
            this.delegate.read_long_array((int[])object, 0, n);
        } else if (clazz2 == Long.TYPE) {
            this.delegate.read_longlong_array((long[])object, 0, n);
        } else if (clazz2 == Short.TYPE) {
            this.delegate.read_short_array((short[])object, 0, n);
        } else if (clazz2 == Boolean.TYPE) {
            this.delegate.read_boolean_array((boolean[])object, 0, n);
        } else {
            throw new AssertionError("Unknown component type " + clazz2);
        }
        return object;
    }

    public final java.lang.Object readObject() throws ClassNotFoundException, IOException {
        try {
            return this.readObject(null);
        }
        catch (SystemException systemException) {
            throw Utils.mapSystemException(systemException);
        }
    }

    public final java.lang.Object readObject(Class clazz) throws ClassNotFoundException, IOException {
        try {
            if (clazz.isArray()) {
                return this.readArray(clazz);
            }
            if (Remote.class.isAssignableFrom(clazz)) {
                return this.readRemote(clazz);
            }
            if (Object.class.isAssignableFrom(clazz)) {
                return this.delegate.read_Object(clazz);
            }
            if (Any.class.isAssignableFrom(clazz)) {
                return this.delegate.read_any();
            }
            if (IDLEntity.class.isAssignableFrom(clazz)) {
                return this.delegate.read_IDLEntity(clazz);
            }
            if (clazz.equals(java.lang.Object.class) || clazz.equals(Serializable.class) || clazz.equals(Externalizable.class)) {
                return Util.readAny((InputStream)this.delegate);
            }
            if (clazz.equals(String.class)) {
                return this.delegate.read_string();
            }
            return this.delegate.read_value(clazz);
        }
        catch (SystemException systemException) {
            throw Utils.mapSystemException(systemException);
        }
    }

    AbstractMsgOutput createMsgOutput(IIOPOutputStream iIOPOutputStream) {
        return new IDLMsgOutput(iIOPOutputStream);
    }

    void readStreamable(Streamable streamable) {
        streamable._read((InputStream)this.delegate);
    }
}

