/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.rmi.Remote;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Streamable;
import weblogic.iiop.AbstractMsgInput;
import weblogic.iiop.AbstractMsgOutput;
import weblogic.iiop.IDLMsgInput;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.Utils;
import weblogic.utils.AssertionError;

public class IDLMsgOutput
extends AbstractMsgOutput {
    public IDLMsgOutput(IIOPOutputStream iIOPOutputStream) {
        super(iIOPOutputStream);
    }

    public final void writeUTF(String string) throws IOException {
        try {
            this.delegate.write_string(string);
        }
        catch (SystemException systemException) {
            throw Utils.mapSystemException(systemException);
        }
    }

    public final void writeChar(int n) throws IOException {
        try {
            this.delegate.write_char((char)n);
        }
        catch (SystemException systemException) {
            throw Utils.mapSystemException(systemException);
        }
    }

    public final void writeBytes(String string) throws IOException {
        try {
            this.delegate.write_string(string);
        }
        catch (SystemException systemException) {
            throw Utils.mapSystemException(systemException);
        }
    }

    public final void writeChars(String string) throws IOException {
        try {
            this.delegate.write_string(string);
        }
        catch (SystemException systemException) {
            throw Utils.mapSystemException(systemException);
        }
    }

    private final void writeArray(java.lang.Object object, Class clazz) throws IOException {
        int n = Array.getLength(object);
        this.delegate.write_long(n);
        Class<?> clazz2 = clazz.getComponentType();
        if (!clazz2.isPrimitive()) {
            for (int i = 0; i < n; ++i) {
                this.writeObject(((java.lang.Object[])object)[i], clazz2);
            }
        } else if (clazz2 == Byte.TYPE) {
            this.delegate.write_octet_array((byte[])object, 0, n);
        } else if (clazz2 == Character.TYPE) {
            this.delegate.write_wchar_array((char[])object, 0, n);
        } else if (clazz2 == Float.TYPE) {
            this.delegate.write_float_array((float[])object, 0, n);
        } else if (clazz2 == Double.TYPE) {
            this.delegate.write_double_array((double[])object, 0, n);
        } else if (clazz2 == Integer.TYPE) {
            this.delegate.write_long_array((int[])object, 0, n);
        } else if (clazz2 == Long.TYPE) {
            this.delegate.write_longlong_array((long[])object, 0, n);
        } else if (clazz2 == Short.TYPE) {
            this.delegate.write_short_array((short[])object, 0, n);
        } else if (clazz2 == Boolean.TYPE) {
            this.delegate.write_boolean_array((boolean[])object, 0, n);
        } else {
            throw new AssertionError("Unknown component type " + clazz2);
        }
    }

    public final void writeObject(java.lang.Object object) throws IOException {
        this.writeObject(object, object.getClass());
    }

    public final void writeObject(java.lang.Object object, Class clazz) throws IOException {
        try {
            if (clazz.isArray()) {
                this.writeArray(object, clazz);
            } else if (Remote.class.isAssignableFrom(clazz) || InvokeHandler.class.isAssignableFrom(clazz) || Object.class.isAssignableFrom(clazz)) {
                this.delegate.writeRemote(object);
            } else if (Any.class.isAssignableFrom(clazz)) {
                this.delegate.write_any((Any)object);
            } else if (IDLEntity.class.isAssignableFrom(clazz)) {
                this.delegate.write_IDLEntity(object, clazz);
            } else if (clazz.equals(java.lang.Object.class) || clazz.equals(Serializable.class) || clazz.equals(Externalizable.class)) {
                Util.writeAny((OutputStream)this.delegate, (java.lang.Object)object);
            } else if (clazz.equals(String.class)) {
                this.delegate.write_string((String)object);
            } else if (Streamable.class.isAssignableFrom(clazz)) {
                this.writeStreamable((Streamable)object);
            } else {
                this.delegate.write_value((Serializable)object, clazz);
            }
        }
        catch (SystemException systemException) {
            throw Utils.mapSystemException(systemException);
        }
    }

    AbstractMsgInput createMsgInput(IIOPInputStream iIOPInputStream) {
        return new IDLMsgInput(iIOPInputStream);
    }

    void writeStreamable(Streamable streamable) {
        streamable._write((OutputStream)this.delegate);
    }
}

