/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.Externalizable;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;
import weblogic.corba.rmic.IDLAttribute;
import weblogic.corba.rmic.IDLField;
import weblogic.corba.rmic.IDLKeywords;
import weblogic.corba.rmic.IDLMangler;
import weblogic.corba.rmic.IDLOptions;
import weblogic.corba.utils.ValueHandlerImpl;
import weblogic.rmi.utils.Utilities;
import weblogic.utils.Debug;
import weblogic.utils.compiler.CodeGenerationException;

public final class IDLUtils
implements IDLKeywords {
    private static String SEQ = "seq";
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String IS = "is";
    public static final String DOT = ".";
    public static final char DOT_C = '.';
    public static String RAISES = " raises (";
    public static final String DOUBLEUNDERSCORE = "__";
    public static final String UNDERSCORE = "_";
    public static final String EXCEPTION = "Exception";
    public static final String EX = "Ex";
    private static Hashtable m_treatedClasses = null;
    public static final String BOXED_IDL_COLON_COLON = "::org::omg::boxedIDL::";

    public static String javaTypeToPath(Class clazz) {
        return IDLUtils.javaTypeToPath(null, clazz);
    }

    public static String getTypeID(Class clazz) {
        return ValueHandlerImpl.getRepositoryID(clazz);
    }

    public static String getPragmaID(Class clazz) {
        String string = "";
        String string2 = IDLUtils.getTypeID(clazz);
        String string3 = IDLUtils.stripPackage(IDLUtils.getIDLType(clazz, DOT));
        string = "#pragma ID " + string3 + " \"" + string2 + "\"\n";
        return string;
    }

    public static Class[] getInheritedInterfaces(Class clazz) {
        Hashtable hashtable = new Hashtable();
        IDLUtils.getInheritedInterfaces(clazz, hashtable);
        Class[] classArray = new Class[hashtable.size()];
        Enumeration enumeration = hashtable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            classArray[n++] = (Class)enumeration.nextElement();
        }
        return classArray;
    }

    static void getInheritedInterfaces(Class clazz, Hashtable hashtable) {
        Class clazz2;
        java.lang.Object object;
        Class clazz3 = clazz.getSuperclass();
        Class<?>[] classArray = null;
        if (clazz3 != null && !clazz3.isInterface()) {
            object = clazz.getInterfaces();
            classArray = new Class[((Class<?>[])object).length + 1];
            System.arraycopy(object, 0, classArray, 0, ((java.lang.Object)object).length);
            classArray[((java.lang.Object)object).length] = clazz3;
        } else {
            classArray = clazz.getInterfaces();
        }
        object = new Vector();
        for (int i = 0; i < classArray.length; ++i) {
            clazz2 = (Class)hashtable.get(classArray[i]);
            if (null != clazz2) continue;
            hashtable.put(classArray[i], classArray[i]);
            ((Vector)object).addElement(classArray[i]);
        }
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            clazz2 = (Class)enumeration.nextElement();
            IDLUtils.getInheritedInterfaces(clazz2, hashtable);
        }
    }

    public static Class[] getInheritedRemoteInterfaces(Class clazz) {
        Class[] classArray = IDLUtils.getInheritedInterfaces(clazz);
        Vector<Class> vector = new Vector<Class>();
        for (int i = 0; i < classArray.length; ++i) {
            if (!Utilities.isARemote((Class)classArray[i])) continue;
            vector.addElement(classArray[i]);
        }
        Class[] classArray2 = new Class[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            classArray2[n++] = (Class)enumeration.nextElement();
        }
        return classArray2;
    }

    static boolean isCORBAObject(Class clazz) {
        return "org.omg.CORBA.Object".equals(clazz.getName());
    }

    static String convertLeadingUnderscore(String string) {
        String string2 = string;
        if (string.startsWith(UNDERSCORE)) {
            string2 = "J" + string2;
        }
        return string2;
    }

    public static String javaTypeToPath(String string, Class clazz) {
        String string2 = new String();
        if (null != string) {
            string2 = string2 + string;
        }
        String string3 = new Character(File.separatorChar).toString();
        if (IDLUtils.isCORBAObject(clazz)) {
            return "org" + string3 + "omg" + string3 + "CORBA" + string3 + "_Object.idl";
        }
        String string4 = IDLUtils.getIDLType(clazz, string3);
        if ((string2 = string2 + string4 + ".idl").startsWith(string3)) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public static final String exceptionToEx(String string) {
        String string2 = string;
        if (string.endsWith(EXCEPTION)) {
            string2 = string.substring(0, string.length() - EXCEPTION.length());
        }
        return string2 + EX;
    }

    public static String getIDLType(Class clazz, String string, String string2) {
        String string3 = IDLMangler.normalizeClassToIDLName(clazz);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (IDLOptions.getVisibroker() && string3.equals(".javax.rmi.CORBA.ClassDesc")) {
            return string2 + "javax" + string + "rmi" + string + "CORBA_" + string + "ClassDesc";
        }
        if (string3.charAt(0) == '.') {
            stringBuffer.append(string2);
            ++n;
        }
        if (string.equals(DOT)) {
            return stringBuffer.append(string3.substring(n).replace(' ', '_')).toString();
        }
        while (n < string3.length()) {
            switch (string3.charAt(n)) {
                case '.': {
                    stringBuffer.append(string);
                    break;
                }
                case ' ': {
                    if (string.equals(UNDERSCORE)) {
                        stringBuffer.append(UNDERSCORE);
                        break;
                    }
                    stringBuffer.append(" ");
                    break;
                }
                default: {
                    stringBuffer.append(string3.charAt(n));
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getIDLType(Class clazz, String string) {
        return IDLUtils.getIDLType(clazz, string, "");
    }

    public static String getIDLType(Class clazz) {
        return IDLUtils.getIDLType(clazz, "::", "::");
    }

    public static boolean isException(Class clazz) {
        return Exception.class.isAssignableFrom(clazz) && !RemoteException.class.equals((java.lang.Object)clazz);
    }

    public static String stripPackage(String string) {
        return IDLUtils.stripPackage(string, DOT);
    }

    public static String stripPackage(String string, String string2) {
        String string3 = string;
        int n = string.lastIndexOf(string2);
        if (-1 != n) {
            string3 = string.substring(n + string2.length());
        }
        return string3;
    }

    public static Class[] getClasses(Class clazz, boolean bl, boolean bl2) {
        Hashtable hashtable = new Hashtable();
        IDLUtils.getAllTypes(clazz, hashtable, bl, bl2);
        Class[] classArray = new Class[hashtable.size()];
        Enumeration enumeration = hashtable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            classArray[n++] = (Class)enumeration.nextElement();
        }
        return classArray;
    }

    static void getAllTypes(Class clazz, Hashtable hashtable, boolean bl, boolean bl2) {
        m_treatedClasses = new Hashtable();
        IDLUtils.getAllTypesInternal(clazz, hashtable, bl, bl2);
    }

    public static boolean isValidField(Field field) {
        return !IDLUtils.attributeMustBeIgnored(field.getName()) && !Modifier.isStatic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers());
    }

    public static boolean isValid(Method method) {
        boolean bl = true;
        int n = method.getModifiers();
        if (Modifier.isNative(n) || !Modifier.isPublic(n)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isValid(Class clazz) {
        boolean bl = true;
        if (String.class.equals((java.lang.Object)clazz) || RemoteException.class.equals((java.lang.Object)clazz) || clazz.isPrimitive() || IDLEntity.class.equals((java.lang.Object)clazz) || Void.TYPE.equals(clazz) || Externalizable.class.equals((java.lang.Object)clazz)) {
            bl = false;
        }
        return bl;
    }

    static void addType(Class clazz, Hashtable hashtable, Class clazz2, boolean bl) {
        if (!clazz.equals(clazz2) && IDLUtils.isValid(clazz)) {
            hashtable.put(clazz, clazz);
            if (bl) {
                for (clazz = clazz.getSuperclass(); null != clazz; clazz = clazz.getSuperclass()) {
                    if (clazz.equals(clazz2) || !IDLUtils.isValid(clazz)) continue;
                    hashtable.put(clazz, clazz);
                }
            }
        }
    }

    static void getAllTypesInternal(Class clazz, Hashtable hashtable, boolean bl, boolean bl2) {
        java.lang.Object object;
        Class<?> clazz2 = clazz.getComponentType();
        if (null != clazz2) {
            IDLUtils.addType(clazz2, hashtable, clazz, bl);
            return;
        }
        Class clazz3 = clazz;
        Class clazz4 = clazz3.getSuperclass();
        if (null != clazz4 && !java.lang.Object.class.equals(clazz4)) {
            IDLUtils.addType(clazz3.getSuperclass(), hashtable, clazz, bl);
        }
        Class<?>[] classArray = clazz3.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            IDLUtils.addType(classArray[i], hashtable, clazz, bl);
        }
        Hashtable hashtable2 = new Hashtable();
        Vector vector = new Vector();
        IDLUtils.getAllFieldTypes(clazz, hashtable2);
        Enumeration enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            object = (Method[])enumeration.nextElement();
            IDLUtils.addType((Class)object, hashtable, clazz, bl);
        }
        if (bl2) {
            object = clazz.getDeclaredMethods();
            for (int i = 0; i < ((java.lang.Object)object).length; ++i) {
                java.lang.Object object2 = object[i];
                if (!IDLUtils.isValid((Method)object2)) continue;
                Class<?> clazz5 = ((Method)object2).getReturnType();
                if (null != clazz5) {
                    IDLUtils.addType(clazz5, hashtable, clazz, bl);
                }
                Class<?>[] classArray2 = ((Method)object2).getParameterTypes();
                for (int j = 0; j < classArray2.length; ++j) {
                    IDLUtils.addType(classArray2[j], hashtable, clazz, bl);
                }
                Class<?>[] classArray3 = ((Method)object2).getExceptionTypes();
                for (int j = 0; j < classArray3.length; ++j) {
                    IDLUtils.addType(classArray3[j], hashtable, clazz, bl);
                }
            }
        }
        if (bl) {
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                Class clazz6 = (Class)object.nextElement();
                if (IDLUtils.isException(clazz6) || null != m_treatedClasses.get(clazz6.getName())) continue;
                m_treatedClasses.put(clazz6.getName(), clazz6);
                IDLUtils.getAllTypesInternal(clazz6, hashtable, bl, bl2);
            }
        }
    }

    public static void getAllFieldTypes(Class clazz, Hashtable hashtable) {
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!IDLUtils.isValidField(fieldArray[i])) continue;
            IDLUtils.addType(fieldArray[i].getType(), hashtable, clazz, false);
        }
    }

    public static Class getNonConformantType(Class clazz) {
        Class clazz2 = null;
        if (IDLUtils.isValid(clazz) && !IDLUtils.isARemote(clazz) && !IDLUtils.isConcreteValueType(clazz) && !IDLUtils.isAbstractInterface(clazz)) {
            clazz2 = clazz;
        }
        return clazz2;
    }

    public static boolean isAbstractInterface(Class clazz) {
        boolean bl;
        block3: {
            bl = false;
            if (IDLUtils.isValid(clazz) && !IDLUtils.isARemote(clazz) && !IDLUtils.isRemote(clazz) && !Serializable.class.equals((java.lang.Object)clazz)) {
                Method[] methodArray = clazz.getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    if (IDLMangler.methodThrowsRemoteException(methodArray[i])) {
                        continue;
                    }
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isValueType(Class clazz) {
        Debug.assertion((null != clazz ? 1 : 0) != 0);
        if (clazz.isPrimitive() || Serializable.class.equals((java.lang.Object)clazz) || Externalizable.class.equals((java.lang.Object)clazz) || RemoteException.class.equals((java.lang.Object)clazz) || IDLEntity.class.equals((java.lang.Object)clazz) || Class.class.equals((java.lang.Object)clazz) || Void.TYPE.equals(clazz) || IDLUtils.isRemote(clazz) || IDLUtils.isARemote(clazz)) {
            return false;
        }
        if (clazz.isInterface() && !IDLUtils.isAbstractInterface(clazz)) {
            return true;
        }
        if (clazz.getComponentType() != null) {
            return false;
        }
        return Serializable.class.isAssignableFrom(clazz);
    }

    public static boolean isConcreteValueType(Class clazz) {
        return IDLUtils.isValueType(clazz) && !clazz.isInterface();
    }

    public static boolean isRemote(Class clazz) {
        return Remote.class.equals((java.lang.Object)clazz);
    }

    public static boolean isIDLInterface(Class clazz) {
        return Object.class.isAssignableFrom(clazz) && IDLEntity.class.isAssignableFrom(clazz);
    }

    public static boolean isARemote(Class clazz) {
        boolean bl = true;
        bl = IDLUtils.isRemote(clazz) ? false : Remote.class.isAssignableFrom(clazz);
        return bl;
    }

    public static Class getRemoteInterface(Class clazz) {
        Class<?> clazz2 = null;
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!IDLUtils.isARemote(classArray[i])) continue;
            clazz2 = classArray[i];
            break;
        }
        return clazz2;
    }

    public static boolean isACheckedException(Class clazz) {
        return !RemoteException.class.isAssignableFrom(clazz) && !RuntimeException.class.isAssignableFrom(clazz) && !Error.class.isAssignableFrom(clazz);
    }

    public static String openModule(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = IDLUtils.getIDLType(clazz, DOT);
        int n = string.indexOf(DOT);
        while (n != -1) {
            String string2 = string.substring(0, n);
            stringBuffer.append("module " + string2 + " {\n");
            string = string.substring(n + 1);
            n = string.indexOf(DOT);
        }
        return stringBuffer.toString();
    }

    public static String closeModule(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = IDLUtils.getIDLType(clazz, DOT).substring(1);
        int n = string.indexOf(DOT);
        while (n != -1) {
            stringBuffer.append("};\n");
            string = string.substring(n + 1);
            n = string.indexOf(DOT);
        }
        return stringBuffer.toString();
    }

    public static String generateGuard(Class clazz, String string) {
        String string2 = IDLUtils.getIDLType(clazz, UNDERSCORE);
        return IDLUtils.generateGuard(string2, string);
    }

    public static String generateGuard(String string, String string2) {
        String string3 = string2 + " __" + string + "__\n";
        return string3;
    }

    static String removeChars(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String generateInclude(String string, Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = IDLUtils.javaTypeToPath(null, clazz);
        stringBuffer.append("#include \"" + string2 + "\"\n");
        return stringBuffer.toString();
    }

    public static void getAttributesFromMethods(Class clazz, Hashtable hashtable) throws CodeGenerationException {
        Hashtable hashtable2 = new Hashtable();
        IDLUtils.findIDLAttributes(clazz, hashtable2);
        Enumeration enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            IDLField iDLField = (IDLField)enumeration.nextElement();
            hashtable.put(iDLField.getMangledName(), iDLField);
        }
    }

    public static void findIDLAttributes(Class clazz, Hashtable hashtable) {
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!IDLUtils.isValid(method)) continue;
            boolean bl = IDLMangler.isGetter(method) || IDLMangler.isIsser(method);
            boolean bl2 = IDLMangler.isSetter(method);
            if (!bl && !bl2) continue;
            Class<?> clazz2 = null;
            clazz2 = bl ? method.getReturnType() : method.getParameterTypes()[0];
            int n = bl2 ? 2 : 1;
            String string = IDLMangler.accessorToAttribute(method.getName());
            IDLAttribute iDLAttribute = (IDLAttribute)hashtable.get(string);
            if (null == iDLAttribute) {
                iDLAttribute = new IDLAttribute(string, n, null, clazz2);
                hashtable.put(string, iDLAttribute);
                continue;
            }
            if (!bl2) continue;
            iDLAttribute.setModifier(2);
        }
    }

    public static boolean isASetterFor(Field field, Method method) {
        return IDLUtils.isAnAccessorFor(field, method, SET);
    }

    public static boolean isAGetterFor(Field field, Method method) {
        return IDLUtils.isAnAccessorFor(field, method, GET) && IDLUtils.isAnAccessorFor(field, method, IS);
    }

    public static boolean isAnAccessorFor(Field field, Method method, String string) {
        boolean bl = false;
        String string2 = method.getName();
        int n = method.getModifiers();
        if (Modifier.isNative(n) || string.equals(SET) && !IDLMangler.isSetter(method) || string.equals(GET) && !IDLMangler.isGetter(method) || string.equals(IS) && !IDLMangler.isIsser(method) || field != null && !IDLMangler.accessorToAttribute(string2).equals(IDLMangler.normalizeJavaName(field.getName()))) {
            return false;
        }
        if (SET.equals(string)) {
            if (null == field || method.getParameterTypes()[0].equals(field.getType())) {
                bl = true;
            }
        } else if (null == field || method.getReturnType().equals(field.getType())) {
            bl = true;
        }
        return bl;
    }

    public static void getAttributesFromFields(Class clazz, Hashtable hashtable) throws CodeGenerationException {
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!IDLUtils.isValidField(field)) continue;
            IDLField iDLField = new IDLField(clazz, field);
            while (hashtable.get(iDLField.getMangledName()) != null) {
                iDLField.setMangledName(new StringBuffer(iDLField.getMangledName()).append(UNDERSCORE).toString());
            }
            hashtable.put(iDLField.getMangledName(), iDLField);
        }
    }

    public static boolean attributeMustBeIgnored(String string) {
        return "serialVersionUID".equals(string);
    }

    public static String mangleAttributeName(Class clazz, Field field) {
        return IDLMangler.convertIllegalCharacters(field.getName());
    }

    public static boolean isThrown(Class clazz, Class clazz2) {
        Debug.assertion((boolean)Exception.class.isAssignableFrom(clazz2));
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!IDLUtils.isValid(method)) continue;
            Class<?>[] classArray = method.getExceptionTypes();
            for (int j = 0; j < classArray.length; ++j) {
                if (!classArray[j].equals(clazz2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInheritable(Class clazz) {
        boolean bl = true;
        if (clazz.equals(java.lang.Object.class) || IDLUtils.isRemote(clazz) || Serializable.class.equals((java.lang.Object)clazz)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isMethodForAnAttribute(Class clazz, Method method) {
        return IDLMangler.isIsser(method) || IDLMangler.isGetter(method) || IDLMangler.isSetter(method);
    }

    public static String mangleExceptionName(String string) {
        int n = string.lastIndexOf(EXCEPTION);
        string = n != -1 ? string.substring(0, n) + EX : string + EX;
        return string;
    }

    public static boolean mustSkipClass(Class clazz) {
        return IDLUtils.mustSkipClass(clazz, IDLUtils.isValueType(clazz));
    }

    public static boolean mustSkipClass(Class clazz, String string) {
        boolean bl = -1 != string.indexOf("valuetype");
        return IDLUtils.mustSkipClass(clazz, bl);
    }

    public static boolean mustSkipClass(Class clazz, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = IDLUtils.isValid(clazz) && null != clazz.getComponentType();
        bl2 = bl || bl3;
        return bl2;
    }

    public static String getMangledMethodName(Method method, Method[] methodArray) throws CodeGenerationException {
        return IDLMangler.getMangledMethodName(method);
    }

    private static void p(String string) {
        System.out.println("***<IDLUtils> " + string);
    }
}

