/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import weblogic.iiop.IIOPClientService;
import weblogic.iiop.IIOPService;
import weblogic.iiop.InitialReferences;
import weblogic.iiop.MuxableSocketIIOP;
import weblogic.iiop.ProtocolHandlerIIOP;
import weblogic.kernel.Kernel;
import weblogic.protocol.ServerChannel;
import weblogic.security.service.SubjectManagerImpl;
import weblogic.server.channels.DynamicListenThread;

public final class IIOPClient {
    private static boolean enabled = false;

    public static boolean isEnabled() {
        return enabled || Kernel.isServer();
    }

    public static synchronized void initialize() {
        if (IIOPClient.isEnabled()) {
            return;
        }
        if (!IIOPClientService.load()) {
            return;
        }
        SubjectManagerImpl.ensureInitialized();
        Kernel.ensureInitialized();
        IIOPClientService.resumeClient();
        try {
            InitialReferences.initializeClientInitialReferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MuxableSocketIIOP.initialize();
        IIOPService.txMechanism = 0;
        ServerChannel serverChannel = ProtocolHandlerIIOP.getProtocolHandler().getDefaultServerChannel();
        if (serverChannel.getPort() != -1) {
            try {
                DynamicListenThread.createClientListener(serverChannel);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        enabled = true;
    }

    public static void shutdown() {
        MuxableSocketIIOP.disable();
        enabled = false;
    }
}

