/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.rmi.RemoteException;
import weblogic.corba.client.spi.ServiceManager;
import weblogic.corba.j2ee.naming.NameParser;
import weblogic.corba.j2ee.naming.ORBHelper;
import weblogic.corba.orb.ORBHelperImpl;
import weblogic.corba.server.naming.ReferenceHelperImpl;
import weblogic.corba.utils.ClassInfo;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.CodeSet;
import weblogic.iiop.CodeSetsComponent;
import weblogic.iiop.DisconnectMonitorImpl;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.InitialReferences;
import weblogic.iiop.MuxableSocketIIOP;
import weblogic.iiop.ProtocolHandlerIIOP;
import weblogic.iiop.ProtocolHandlerIIOPS;
import weblogic.jndi.security.internal.server.ServerSubjectPusher;
import weblogic.kernel.Kernel;
import weblogic.protocol.ClientEnvironment;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.server.DisconnectMonitorProvider;
import weblogic.rmi.extensions.server.ReferenceHelper;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class IIOPClientService
extends AbstractServerService {
    private static boolean loaded = false;
    private static final String FALSE_PROP = "false";
    private static final String TRUE_PROP = "true";
    private static boolean initialized = false;
    private static final DebugCategory debugStartup = Debug.getCategory((String)"weblogic.iiop.startup");
    private static final DebugLogger debugIIOPStartup = DebugLogger.getDebugLogger((String)"DebugIIOPStartup");
    public static String locationForwardPolicy;
    public static byte defaultGIOPMinorVersion;
    public static boolean useSerialFormatVersion2;
    public static boolean reconnectOnBootstrap;
    public static boolean useLocateRequest;

    public static boolean load() {
        if (loaded) {
            return loaded;
        }
        if (FALSE_PROP.equals(System.getProperty("weblogic.system.enableIIOP")) || FALSE_PROP.equals(System.getProperty("weblogic.system.iiop.enable"))) {
            return false;
        }
        if (TRUE_PROP.equals(System.getProperty("weblogic.system.iiop.reconnectOnBootstrap"))) {
            reconnectOnBootstrap = true;
        }
        try {
            loaded = true;
            ClientEnvironment.loadEnvironment();
            if ("weblogic.iiop.UtilDelegateImpl".equals(System.getProperty("javax.rmi.CORBA.UtilClass"))) {
                if (Kernel.isServer()) {
                    IIOPLogger.logEnabled();
                }
            } else {
                IIOPLogger.logUtilClassNotInstalled((String)System.getProperty("javax.rmi.CORBA.UtilClass"));
            }
            if (!"weblogic.iiop.PortableRemoteObjectDelegateImpl".equals(System.getProperty("javax.rmi.CORBA.PortableRemoteObjectClass"))) {
                IIOPLogger.logPROClassNotInstalled((String)System.getProperty("javax.rmi.CORBA.PortableRemoteObjectClass"));
            }
            ReferenceHelper.setReferenceHelper((ReferenceHelper)new ReferenceHelperImpl());
            ServiceManager.setSecurityManager(new ServerSubjectPusher());
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private void initialize() throws ServiceFailureException {
        if (initialized) {
            return;
        }
        initialized = true;
        if (!IIOPClientService.load()) {
            return;
        }
        ORBHelper.setORBHelper(new ORBHelperImpl());
        ProtocolHandlerIIOP.getProtocolHandler();
        ProtocolHandlerIIOPS.getProtocolHandler();
        MuxableSocketIIOP.initialize();
        try {
            InitialReferences.initializeClientInitialReferences();
        }
        catch (RemoteException remoteException) {
            throw new ServiceFailureException((Throwable)remoteException);
        }
        catch (IOException iOException) {
            throw new ServiceFailureException((Throwable)iOException);
        }
    }

    public void stop() {
        this.halt();
    }

    public void halt() {
        MuxableSocketIIOP.disable();
    }

    public static void resumeClient() {
        boolean bl = debugStartup.isEnabled() || debugIIOPStartup.isDebugEnabled();
        useLocateRequest = Kernel.getConfig().getIIOP().getUseLocateRequest();
        if (bl) {
            IIOPLogger.logLocateRequest((String)(useLocateRequest ? "on" : "off"));
        }
        defaultGIOPMinorVersion = (byte)Kernel.getConfig().getIIOP().getDefaultMinorVersion();
        if (bl) {
            IIOPLogger.logGIOPVersion((byte)defaultGIOPMinorVersion);
        }
        locationForwardPolicy = Kernel.getConfig().getIIOP().getLocationForwardPolicy();
        if (bl) {
            IIOPLogger.logLocationForwardPolicy((String)locationForwardPolicy);
        }
        useSerialFormatVersion2 = Kernel.getConfig().getIIOP().getUseSerialFormatVersion2();
        NameParser.initialize(defaultGIOPMinorVersion);
        String string = Kernel.getConfig().getIIOP().getDefaultCharCodeset();
        String string2 = Kernel.getConfig().getIIOP().getDefaultWideCharCodeset();
        CodeSet.setDefaults(CodeSet.getOSFCodeset(string), CodeSet.getOSFCodeset(string2));
        if (bl) {
            IIOPLogger.logCodeSet((String)"char", (String)string, (String)("0x" + Integer.toHexString(CodeSet.getDefaultCharCodeSet())));
        }
        if (bl) {
            IIOPLogger.logCodeSet((String)"wchar", (String)string2, (String)("0x" + Integer.toHexString(CodeSet.getDefaultWcharCodeSet())));
        }
        CodeSetsComponent.resetDefault();
        ClassInfo.initialize(Kernel.getConfig().getIIOP().getUseFullRepositoryIdList());
        DisconnectMonitorListImpl.getDisconnectMonitorList().addDisconnectMonitor((DisconnectMonitorProvider)new DisconnectMonitorImpl());
    }

    public void start() throws ServiceFailureException {
        this.initialize();
        IIOPClientService.resumeClient();
    }

    static {
        defaultGIOPMinorVersion = (byte)2;
        useSerialFormatVersion2 = false;
        reconnectOnBootstrap = false;
        useLocateRequest = false;
    }
}

