/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA.portable.ValueInputStream;
import org.omg.CORBA_2_3.portable.InputStream;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.corba.idl.AnyImpl;
import weblogic.corba.idl.TypeCodeImpl;
import weblogic.corba.orb.ORB;
import weblogic.corba.utils.ClassInfo;
import weblogic.corba.utils.IndirectionHashtable;
import weblogic.corba.utils.RemoteInfo;
import weblogic.corba.utils.RepositoryId;
import weblogic.corba.utils.ValueHandlerImpl;
import weblogic.iiop.CodeSet;
import weblogic.iiop.EndPoint;
import weblogic.iiop.GIOP10Helper;
import weblogic.iiop.IDLMsgInput;
import weblogic.iiop.IDLUtils;
import weblogic.iiop.IIOPReplacer;
import weblogic.iiop.IIOPService;
import weblogic.iiop.IOR;
import weblogic.iiop.ObjectInputStreamImpl;
import weblogic.iiop.Utils;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelStream;
import weblogic.rmi.spi.MsgInput;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.Hex;
import weblogic.utils.StringUtils;
import weblogic.utils.collections.Pool;
import weblogic.utils.collections.StackPool;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkInput;
import weblogic.utils.io.ChunkedInputStream;
import weblogic.utils.io.ObjectInput;
import weblogic.utils.io.ObjectStreamClass;
import weblogic.utils.io.StringInput;

public final class IIOPInputStream
extends InputStream
implements PeerInfoable,
ServerChannelStream,
StringInput,
ObjectInput,
ChunkInput,
MsgInput,
ValueInputStream {
    private static final int NULL_TAG = 0;
    private static final boolean debugValueTypes = false;
    private static final boolean DEBUG = false;
    private boolean SUPPORT_JDK_13_CHUNKING = true;
    private int minorVersion = 2;
    private static final ValueHandler valueHandler;
    private static final String READ_METHOD = "read";
    private static final String INSERT_METHOD = "insert";
    private static final String TYPE_METHOD = "type";
    private static final Class[] READ_METHOD_ARGS;
    private static final Class[] NO_ARGS_METHOD;
    private static final java.lang.Object[] NO_ARGS;
    private static final String NULL_STRING = "";
    private static final int VT_INDIRECTION = -1;
    private Fragment fragmentHead;
    private Fragment fragmentTail;
    private final Marker marker = new Marker();
    private Chunk head;
    private Chunk firstChunk;
    private int streamPos = 0;
    private int chunkPos = 0;
    private boolean chunking = false;
    private int chunkLength = 0;
    private int endTag = 0;
    private boolean littleEndian;
    private int needLongAlignment = 0;
    private String annotation;
    private boolean needEightByteAlignment = false;
    private boolean needEightByteAlignmentSave;
    private boolean endianSave;
    private int alignSave = 0;
    private boolean secure = false;
    private org.omg.CORBA.ORB orb = null;
    private static final boolean ASSERT = false;
    private final EndPoint endPoint;
    private int char_codeset;
    private int wchar_codeset;
    private java.io.ObjectInput oinput;
    private ObjectInputStream objectStream;
    private String possibleCodebase;
    private int nestingLevel = 0;
    private IndirectionHashtable indirections = null;
    private IndirectionHashtable tcIndirections = null;
    private int tcNestingLevel = 0;
    private IIOPInputStream parentStream;
    static final int MAX_ENCAP_SIZE = 0x4000000;
    static final int MAX_STRING_SIZE = 524288;
    private static final int MAP_POOL_SIZE = 1024;
    private static final Pool mapPool;
    private IndirectionHashtable encapsulations = null;
    private static Constructor odeCtor;
    private boolean readingObjectKey = false;

    static IndirectionHashtable getHashMap() {
        IndirectionHashtable indirectionHashtable = (IndirectionHashtable)mapPool.remove();
        if (indirectionHashtable == null) {
            indirectionHashtable = new IndirectionHashtable();
        }
        return indirectionHashtable;
    }

    static void releaseHashMap(IndirectionHashtable indirectionHashtable) {
        if (indirectionHashtable != null) {
            indirectionHashtable.clear();
            mapPool.add((java.lang.Object)indirectionHashtable);
        }
    }

    IIOPInputStream(ChunkedInputStream chunkedInputStream, boolean bl, EndPoint endPoint) {
        this(chunkedInputStream.getChunks(), bl, endPoint);
    }

    IIOPInputStream(Chunk chunk, boolean bl, EndPoint endPoint) {
        this.endPoint = endPoint;
        this.head = chunk;
        this.indirections = IIOPInputStream.getHashMap();
        if (endPoint != null) {
            this.wchar_codeset = endPoint.getWcharCodeSet();
            this.char_codeset = endPoint.getCharCodeSet();
        } else {
            this.char_codeset = CodeSet.getDefaultCharCodeSet();
            this.wchar_codeset = CodeSet.getDefaultWcharCodeSet();
        }
        this.secure = bl;
        this.chunkPos = 0;
        this.orb = ORB.getInstance();
    }

    public IIOPInputStream(byte[] byArray) {
        this((Chunk)null, false, null);
        int n;
        Chunk chunk = null;
        int n2 = 0;
        this.SUPPORT_JDK_13_CHUNKING = false;
        for (int i = byArray.length; i > 0; i -= n) {
            Chunk chunk2 = chunk;
            chunk = Chunk.getChunk();
            if (chunk2 != null) {
                chunk2.next = chunk;
            } else {
                this.head = chunk;
            }
            n = IIOPInputStream.min(chunk.buf.length, i);
            System.arraycopy(byArray, n2, chunk.buf, 0, n);
            n2 += n;
            chunk.end = n;
        }
    }

    public IIOPInputStream(IIOPInputStream iIOPInputStream, EndPoint endPoint) {
        this((Chunk)null, false, endPoint);
        int n;
        this.parentStream = iIOPInputStream;
        long l = iIOPInputStream.startEncapsulation(false);
        this.SUPPORT_JDK_13_CHUNKING = iIOPInputStream.SUPPORT_JDK_13_CHUNKING;
        this.nestingLevel = iIOPInputStream.nestingLevel;
        this.readingObjectKey = iIOPInputStream.readingObjectKey;
        Chunk chunk = null;
        for (int i = iIOPInputStream.peek_long(); i > 0; i -= n) {
            Chunk chunk2 = chunk;
            chunk = Chunk.getChunk();
            if (chunk2 != null) {
                chunk2.next = chunk;
            } else {
                this.head = chunk;
            }
            n = IIOPInputStream.min(chunk.buf.length, i);
            iIOPInputStream.read_octet_array(chunk.buf, 0, n);
            chunk.end = n;
        }
        iIOPInputStream.endEncapsulation(l);
        this.consumeEndian();
    }

    public IIOPInputStream(IIOPInputStream iIOPInputStream) {
        this(iIOPInputStream, iIOPInputStream.endPoint);
    }

    public final void setSupportsJDK13Chunking(boolean bl) {
        this.SUPPORT_JDK_13_CHUNKING = bl;
    }

    void setPossibleCodebase(String string) {
        this.possibleCodebase = string;
    }

    private String getPossibleCodebase() {
        if (this.possibleCodebase != null) {
            return this.possibleCodebase;
        }
        if (this.parentStream != null) {
            return this.parentStream.getPossibleCodebase();
        }
        return null;
    }

    private final boolean useCompliantChunking() {
        return !this.SUPPORT_JDK_13_CHUNKING || this.nestingLevel != 0 && this.readingObjectKey;
    }

    public int getMinorVersion() {
        if (this.endPoint != null && (this.nestingLevel == 0 || this.SUPPORT_JDK_13_CHUNKING && !this.readingObjectKey)) {
            return this.minorVersion;
        }
        return 2;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public PeerInfo getPeerInfo() {
        if (this.endPoint != null && this.endPoint.getPeerInfo() != null) {
            return this.endPoint.getPeerInfo();
        }
        return PeerInfo.FOREIGN;
    }

    private final java.lang.Object getIndirection(int n) {
        if (this.indirections == null) {
            return null;
        }
        return this.indirections.get(n);
    }

    private final void addIndirection(int n, java.lang.Object object) {
        this.indirections.put(n, object);
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    Chunk getChunks() {
        return this.head;
    }

    void addChunks(IIOPInputStream iIOPInputStream) {
        if (this.fragmentHead == null) {
            this.fragmentHead = this.fragmentTail = new Fragment(iIOPInputStream.getChunks(), iIOPInputStream.chunkPos);
        } else {
            this.fragmentTail = this.fragmentTail.next = new Fragment(iIOPInputStream.getChunks(), iIOPInputStream.chunkPos);
        }
    }

    public void setCodeSets(int n, int n2) {
        this.char_codeset = n;
        this.wchar_codeset = n2;
    }

    private final int getWcharCodeSet() {
        return this.nestingLevel > 0 && !this.SUPPORT_JDK_13_CHUNKING && !this.readingObjectKey ? 65801 : this.wchar_codeset;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public java.io.ObjectInput getObjectInput(boolean bl) {
        if (!bl) {
            return this;
        }
        if (this.oinput == null) {
            this.oinput = new IDLMsgInput(this);
        }
        return this.oinput;
    }

    public ObjectInputStream getObjectInputStream(java.lang.Object object, ObjectStreamClass objectStreamClass, boolean bl, byte by) throws IOException {
        if (this.objectStream == null) {
            this.objectStream = new ObjectInputStreamImpl(this, object, objectStreamClass, bl, by);
        } else {
            ((ObjectInputStreamImpl)this.objectStream).pushCurrent(object, objectStreamClass, bl, by);
        }
        return this.objectStream;
    }

    public boolean consumeEndian() {
        boolean bl = this.littleEndian;
        this.littleEndian = (this.read_octet() & 1) == 1;
        return bl;
    }

    void setEndian(boolean bl) {
        this.littleEndian = bl;
    }

    void setORB(org.omg.CORBA.ORB oRB) {
        this.orb = oRB;
    }

    void recordStart() {
        this.firstChunk = this.head;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public final byte read_octet() {
        if (this.needEightByteAlignment) {
            this.checkEightByteAlignment();
        }
        if (this.chunkPos == this.head.end) {
            this.advance();
        }
        if (this.chunking) {
            this.checkChunk(1);
        }
        return this.head.buf[this.chunkPos++];
    }

    private void startChunk() {
        this.chunking = false;
        this.mark(0);
        this.chunkLength = this.read_long();
        if (this.chunkLength < 0 || this.chunkLength >= 0x7FFFFF00) {
            this.reset();
        } else {
            this.clearMark();
        }
        if (this.useCompliantChunking()) {
            --this.endTag;
        }
        this.chunking = true;
    }

    private final void checkChunk(int n) {
        if (this.endOfChunk(n)) {
            throw new MARSHAL("stream corrupted: reading past end of chunk at: " + this.pos(), 1330446344, CompletionStatus.COMPLETED_NO);
        }
    }

    private final boolean endOfChunk(int n) {
        if (!this.chunking) {
            return false;
        }
        if (n >= this.chunkLength && (n == 0 || n > this.chunkLength)) {
            if (this.chunkLength == 0) {
                if (this.peek_long() >= 0x7FFFFF00) {
                    return false;
                }
                if (!this.continuation()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        this.chunkLength -= n;
        return false;
    }

    private boolean continuation() {
        int n = this.peek_long();
        if (n == 0) {
            throw new MARSHAL("stream corrupted: '0' tag reserved");
        }
        if (n > 0 && n < 0x7FFFFF00) {
            this.chunking = false;
            this.chunkLength = this.read_long();
            this.chunking = true;
            return true;
        }
        return false;
    }

    private void endChunk(boolean bl) {
        if (!this.chunking) {
            return;
        }
        this.chunking = false;
        if (this.chunkLength > 0) {
            this.skip(this.chunkLength);
            this.chunkLength = 0;
        }
        int n = this.peek_long();
        while (n < this.endTag) {
            this.read_long();
            this.continuation();
            this.skip(this.chunkLength);
            this.chunkLength = 0;
            n = this.peek_long();
        }
        if (n > this.endTag) {
            if (!this.useCompliantChunking()) {
                this.chunking = bl;
            } else {
                ++this.endTag;
                this.chunking = true;
            }
            return;
        }
        this.read_long();
        if (!this.useCompliantChunking()) {
            this.chunking = bl;
        } else {
            this.chunking = n < -1;
            ++this.endTag;
        }
        if (this.chunking) {
            this.continuation();
        }
    }

    boolean eof() {
        return this.chunkPos == this.head.end && this.head.next == null && this.fragmentHead == null || this.endOfChunk(0);
    }

    private static final int min(int n, int n2) {
        return n <= n2 ? n : n2;
    }

    public final void read_octet_array(byte[] byArray, int n, int n2) {
        if (this.needEightByteAlignment) {
            this.checkEightByteAlignment();
        }
        if (byArray == null) {
            throw new MARSHAL("null array as parameter to read_octet_array");
        }
        if (n2 == 0) {
            return;
        }
        if (this.chunking) {
            this.checkChunk(0);
        }
        while (n2 > 0) {
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            int n3 = IIOPInputStream.min(this.head.end - this.chunkPos, n2);
            this.checkChunk(n3);
            System.arraycopy(this.head.buf, this.chunkPos, byArray, n, n3);
            this.chunkPos += n3;
            n += n3;
            n2 -= n3;
        }
    }

    public void read_octet_array(OctetSeqHolder octetSeqHolder, int n, int n2) {
        if (octetSeqHolder == null) {
            throw new MARSHAL("null OctetSeqHolder as parameter to read_octet_array");
        }
        this.read_octet_array(octetSeqHolder.value, n, n2);
    }

    public byte[] read_octet_sequence() {
        byte[] byArray = null;
        int n = this.read_long();
        if (n > 0x4000000) {
            throw new MARSHAL("Stream corrupted at " + this.pos() + ": tried to read octet sequence of length " + Integer.toHexString(n));
        }
        if (n > 0) {
            byArray = new byte[n];
            this.read_octet_array(byArray, 0, n);
        }
        return byArray;
    }

    public boolean read_boolean() {
        boolean bl = this.read_octet() != 0;
        return bl;
    }

    public void read_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            throw new MARSHAL("null array as parameter to read_boolean_array");
        }
        for (int i = 0; i < n2; ++i) {
            blArray[i + n] = this.read_boolean();
        }
    }

    public void read_boolean_array(BooleanSeqHolder booleanSeqHolder, int n, int n2) {
        if (booleanSeqHolder == null) {
            throw new MARSHAL("null BooleanSeqHolder as parameter to read_boolean_array");
        }
        this.read_boolean_array(booleanSeqHolder.value, n, n2);
    }

    private final void alignWithoutChunking(int n) {
        int n2;
        int n3;
        if (this.needEightByteAlignment) {
            this.checkEightByteAlignment();
        }
        if ((n3 = (n - (n2 = this.streamPos + this.chunkPos + this.needLongAlignment) % n) % n) <= this.head.end - this.chunkPos) {
            this.chunkPos += n3;
        } else {
            this.skip(n3);
        }
    }

    final void align(int n) {
        int n2;
        int n3;
        if (this.needEightByteAlignment) {
            this.checkEightByteAlignment();
        }
        if ((n3 = (n - (n2 = this.streamPos + this.chunkPos + this.needLongAlignment) % n) % n) <= this.head.end - this.chunkPos) {
            this.chunkPos += n3;
        } else {
            this.skip(n3);
        }
        if (this.chunking) {
            Debug.assertion((this.chunkLength == 0 || this.chunkLength >= n3 ? 1 : 0) != 0);
            this.chunkLength -= IIOPInputStream.min(n3, this.chunkLength);
        }
    }

    public final void setNeedEightByteAlignment() {
        this.needEightByteAlignment = true;
    }

    public final void checkEightByteAlignment() {
        this.needEightByteAlignment = false;
        this.align(8);
    }

    public void mark(int n) {
        this.mark(this.marker);
        this.endianSave = this.littleEndian;
        this.alignSave = this.needLongAlignment;
        this.needEightByteAlignmentSave = this.needEightByteAlignment;
    }

    public boolean markSupported() {
        return true;
    }

    void mark(Marker marker) {
        marker.streamPos = this.streamPos;
        marker.chunkPos = this.chunkPos;
        marker.head = this.head;
        marker.fragmentHead = this.fragmentHead;
        marker.chunkLength = this.chunkLength;
    }

    final void reset(Marker marker) {
        this.streamPos = marker.streamPos;
        this.chunkPos = marker.chunkPos;
        this.head = marker.head;
        this.chunkLength = marker.chunkLength;
        this.fragmentHead = marker.fragmentHead;
    }

    public void reset() {
        if (this.marker.head == null) {
            this.streamPos = 0;
            this.chunkPos = 0;
            this.head = this.firstChunk;
            this.chunkLength = 0;
            if (this.tcIndirections != null) {
                this.tcIndirections.clear();
            }
            if (this.indirections != null) {
                this.indirections.clear();
            }
        } else {
            this.reset(this.marker);
            this.marker.head = null;
            this.marker.fragmentHead = null;
        }
        this.littleEndian = this.endianSave;
        this.needLongAlignment = this.alignSave;
        this.needEightByteAlignment = this.needEightByteAlignmentSave;
    }

    public void clearMark() {
        while (this.marker.head != null && this.marker.head != this.head && this.firstChunk == null) {
            Chunk chunk = this.marker.head;
            this.marker.head = this.marker.head.next;
            Chunk.releaseChunk((Chunk)chunk);
        }
        this.marker.head = null;
        this.marker.fragmentHead = null;
    }

    public long skip(long l) {
        while (l > 0L) {
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            int n = IIOPInputStream.min(this.head.end - this.chunkPos, (int)l);
            this.chunkPos += n;
            l -= (long)n;
        }
        return l;
    }

    public final int bytesLeft(long l) {
        if ((l &= 0x1FFFFFFFL) > (long)this.pos()) {
            return (int)(l - (long)this.pos());
        }
        return 0;
    }

    public final int pos() {
        return this.streamPos + this.chunkPos;
    }

    private final void advance() {
        this.streamPos += this.head.end;
        this.chunkPos = 0;
        Chunk chunk = this.head.next;
        if (this.marker.head == null && this.firstChunk == null) {
            Chunk.releaseChunk((Chunk)this.head);
        }
        this.head = chunk;
        if (this.head == null) {
            if (this.fragmentHead == null) {
                throw new MARSHAL("EOF at " + this.pos());
            }
            this.streamPos -= this.fragmentHead.start;
            this.head = this.fragmentHead.chunk;
            this.chunkPos = this.fragmentHead.start;
            this.fragmentHead = this.fragmentHead.next;
        }
    }

    public void close() {
        IIOPInputStream.releaseHashMap(this.indirections);
        this.indirections = null;
        IIOPInputStream.releaseHashMap(this.tcIndirections);
        this.tcIndirections = null;
        IIOPInputStream.releaseHashMap(this.encapsulations);
        this.encapsulations = null;
        this.marker.head = null;
        this.firstChunk = null;
        this.marker.fragmentHead = null;
        this.fragmentTail = null;
        this.annotation = null;
        IIOPInputStream.releaseChunks(this.head);
        this.head = null;
        this.possibleCodebase = null;
        while (this.fragmentHead != null) {
            Fragment fragment = this.fragmentHead.next;
            IIOPInputStream.releaseChunks(this.fragmentHead.chunk);
            this.fragmentHead = fragment;
        }
        this.parentStream = null;
    }

    private static void releaseChunks(Chunk chunk) {
        while (chunk != null) {
            Chunk chunk2 = chunk.next;
            Chunk.releaseChunk((Chunk)chunk);
            chunk = chunk2;
        }
    }

    public short read_short() {
        int n;
        int n2;
        if (this.chunking) {
            this.align(2);
            this.checkChunk(2);
        } else {
            this.alignWithoutChunking(2);
        }
        if (this.chunkPos + 2 <= this.head.end) {
            n2 = this.head.buf[this.chunkPos++] & 0xFF;
            n = this.head.buf[this.chunkPos++] & 0xFF;
        } else {
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            n2 = this.head.buf[this.chunkPos++] & 0xFF;
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            n = this.head.buf[this.chunkPos++] & 0xFF;
        }
        short s = this.littleEndian ? (short)(n << 8 | n2) : (short)(n2 << 8 | n);
        return s;
    }

    public void read_short_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new MARSHAL("null array as parameter to read_short_array");
        }
        for (int i = 0; i < n2; ++i) {
            sArray[i + n] = this.read_short();
        }
    }

    public void read_short_array(ShortSeqHolder shortSeqHolder, int n, int n2) {
        if (shortSeqHolder == null) {
            throw new MARSHAL("null ShortSeqHolder as parameter to read_short_array");
        }
        this.read_short_array(shortSeqHolder.value, n, n2);
    }

    public short read_ushort() {
        return this.read_short();
    }

    public int read_unsigned_short() {
        this.align(2);
        int n = this.read_octet() & 0xFF;
        int n2 = this.read_octet() & 0xFF;
        int n3 = this.littleEndian ? n2 << 8 | n : n << 8 | n2;
        return n3;
    }

    public int peek_slow_long() {
        this.mark(0);
        boolean bl = this.chunking;
        this.chunking = false;
        int n = this.read_long();
        this.chunking = bl;
        this.reset();
        return n;
    }

    public final int peek_long() {
        int n;
        int n2 = this.needEightByteAlignment ? 8 : 4;
        int n3 = (n2 - (n = this.streamPos + this.chunkPos + this.needLongAlignment) % n2) % n2 + this.chunkPos;
        if (n3 + 4 <= this.head.end && !this.littleEndian) {
            return (this.head.buf[n3++] & 0xFF) << 24 | (this.head.buf[n3++] & 0xFF) << 16 | (this.head.buf[n3++] & 0xFF) << 8 | this.head.buf[n3++] & 0xFF;
        }
        return this.peek_slow_long();
    }

    public final int read_long() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.chunking) {
            this.align(4);
            this.checkChunk(4);
        } else {
            this.alignWithoutChunking(4);
        }
        if (this.chunkPos + 4 <= this.head.end) {
            n4 = this.head.buf[this.chunkPos++] & 0xFF;
            n3 = this.head.buf[this.chunkPos++] & 0xFF;
            n2 = this.head.buf[this.chunkPos++] & 0xFF;
            n = this.head.buf[this.chunkPos++] & 0xFF;
        } else {
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            n4 = this.head.buf[this.chunkPos++] & 0xFF;
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            n3 = this.head.buf[this.chunkPos++] & 0xFF;
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            n2 = this.head.buf[this.chunkPos++] & 0xFF;
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            n = this.head.buf[this.chunkPos++] & 0xFF;
        }
        int n5 = this.littleEndian ? n << 24 | n2 << 16 | n3 << 8 | n4 : n4 << 24 | n3 << 16 | n2 << 8 | n;
        return n5;
    }

    public void read_long_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new MARSHAL("null array as parameter to read_long_array");
        }
        for (int i = 0; i < n2; ++i) {
            nArray[i + n] = this.read_long();
        }
    }

    public void read_long_array(LongSeqHolder longSeqHolder, int n, int n2) {
        if (longSeqHolder == null) {
            throw new MARSHAL("null LongSeqHolder as parameter to read_long_array");
        }
        this.read_long_array(longSeqHolder.value, n, n2);
    }

    public final int read_ulong() {
        return this.read_long();
    }

    public void read_ulong_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new MARSHAL("null array as parameter to read_ulong_array");
        }
        for (int i = 0; i < n2; ++i) {
            nArray[i + n] = this.read_ulong();
        }
    }

    public void read_ulong_array(ULongSeqHolder uLongSeqHolder, int n, int n2) {
        if (uLongSeqHolder == null) {
            throw new MARSHAL("null ULongSeqHolder as parameter to read_ulong_array");
        }
        this.read_ulong_array(uLongSeqHolder.value, n, n2);
    }

    public final long read_longlong() {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        if (this.chunking) {
            this.align(4);
            this.checkChunk(8);
            this.align(8);
        } else {
            this.alignWithoutChunking(8);
        }
        if (this.chunkPos + 8 <= this.head.end) {
            l8 = this.head.buf[this.chunkPos++] & 0xFF;
            l7 = this.head.buf[this.chunkPos++] & 0xFF;
            l6 = this.head.buf[this.chunkPos++] & 0xFF;
            l5 = this.head.buf[this.chunkPos++] & 0xFF;
            l4 = this.head.buf[this.chunkPos++] & 0xFF;
            l3 = this.head.buf[this.chunkPos++] & 0xFF;
            l2 = this.head.buf[this.chunkPos++] & 0xFF;
            l = this.head.buf[this.chunkPos++] & 0xFF;
        } else {
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            l8 = this.head.buf[this.chunkPos++] & 0xFF;
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            l7 = this.head.buf[this.chunkPos++] & 0xFF;
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            l6 = this.head.buf[this.chunkPos++] & 0xFF;
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            l5 = this.head.buf[this.chunkPos++] & 0xFF;
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            l4 = this.head.buf[this.chunkPos++] & 0xFF;
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            l3 = this.head.buf[this.chunkPos++] & 0xFF;
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            l2 = this.head.buf[this.chunkPos++] & 0xFF;
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            l = this.head.buf[this.chunkPos++] & 0xFF;
        }
        long l9 = this.littleEndian ? l << 56 | l2 << 48 | l3 << 40 | l4 << 32 | l5 << 24 | l6 << 16 | l7 << 8 | l8 : l8 << 56 | l7 << 48 | l6 << 40 | l5 << 32 | l4 << 24 | l3 << 16 | l2 << 8 | l;
        return l9;
    }

    public void read_longlong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new MARSHAL("null array as parameter to read_longlong_array");
        }
        for (int i = 0; i < n2; ++i) {
            lArray[i + n] = this.read_longlong();
        }
    }

    public void read_longlong_array(LongLongSeqHolder longLongSeqHolder, int n, int n2) {
        if (longLongSeqHolder == null) {
            throw new MARSHAL("null LongLongSeqHolder as parameter to read_longlong_array");
        }
        this.read_longlong_array(longLongSeqHolder.value, n, n2);
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public void read_ulonglong_array(long[] lArray, int n, int n2) {
        this.read_longlong_array(lArray, n, n2);
    }

    public void read_ulonglong_array(ULongLongSeqHolder uLongLongSeqHolder, int n, int n2) {
        if (uLongLongSeqHolder == null) {
            throw new MARSHAL("null ULongLongSeqHolder as parameter to read_ulonglong_array");
        }
        this.read_ulonglong_array(uLongLongSeqHolder.value, n, n2);
    }

    public float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public void read_float_array(float[] fArray, int n, int n2) {
        if (fArray == null) {
            throw new MARSHAL("null array as parameter to read_float_array");
        }
        for (int i = 0; i < n2; ++i) {
            fArray[i + n] = this.read_float();
        }
    }

    public void read_float_array(FloatSeqHolder floatSeqHolder, int n, int n2) {
        if (floatSeqHolder == null) {
            throw new MARSHAL("null FloatSeqHolder as parameter to read_float_array");
        }
        this.read_float_array(floatSeqHolder.value, n, n2);
    }

    public double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public void read_double_array(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new MARSHAL("null array as parameter to read_double_array");
        }
        for (int i = 0; i < n2; ++i) {
            dArray[i + n] = this.read_double();
        }
    }

    public void read_double_array(DoubleSeqHolder doubleSeqHolder, int n, int n2) {
        if (doubleSeqHolder == null) {
            throw new MARSHAL("null DoubleSeqHolder as parameter to read_double_array");
        }
        this.read_double_array(doubleSeqHolder.value, n, n2);
    }

    public char read_char() {
        return (char)(this.read_octet() & 0xFF);
    }

    public void read_char_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new MARSHAL("null array as parameter to read_char_array");
        }
        for (int i = 0; i < n2; ++i) {
            cArray[i + n] = this.read_char();
        }
    }

    public void read_char_array(CharSeqHolder charSeqHolder, int n, int n2) {
        if (charSeqHolder == null) {
            throw new MARSHAL("null CharSeqHolder as parameter to read_char_array");
        }
        this.read_char_array(charSeqHolder.value, n, n2);
    }

    public char read_wchar() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = this.littleEndian;
        switch (this.getWcharCodeSet()) {
            case 0x5010001: {
                n3 = this.read_UTF8wchar();
                break;
            }
            case 65801: {
                switch (this.getMinorVersion()) {
                    case 0: 
                    case 1: {
                        this.align(2);
                        n = this.read_octet();
                        n2 = this.read_octet();
                        break;
                    }
                    case 2: {
                        byte by = this.read_octet();
                        n = this.read_octet();
                        n2 = this.read_octet();
                        bl = false;
                        if (n == -1 && n2 == -2) {
                            n = this.read_octet();
                            n2 = this.read_octet();
                            bl = true;
                            break;
                        }
                        if (n != -2 || n2 != -1) break;
                        n = this.read_octet();
                        n2 = this.read_octet();
                    }
                }
                if (bl) {
                    n3 = ((n2 & 0xFF) << 8) + ((n & 0xFF) << 0);
                    break;
                }
                n3 = ((n & 0xFF) << 8) + ((n2 & 0xFF) << 0);
                break;
            }
            case 65792: {
                switch (this.getMinorVersion()) {
                    case 0: 
                    case 1: {
                        this.align(2);
                        n = this.read_octet();
                        n2 = this.read_octet();
                        break;
                    }
                    case 2: {
                        byte by = this.read_octet();
                        n = this.read_octet();
                        n2 = this.read_octet();
                    }
                }
                n3 = bl ? ((n2 & 0xFF) << 8) + ((n & 0xFF) << 0) : ((n & 0xFF) << 8) + ((n2 & 0xFF) << 0);
            }
        }
        return (char)n3;
    }

    public int read() {
        if (this.chunkPos == this.head.end && this.head.next == null && this.fragmentHead == null) {
            return -1;
        }
        return this.read_octet() & 0xFF;
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public void read_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new MARSHAL("null array as parameter to read_wchar_array");
        }
        for (int i = 0; i < n2; ++i) {
            cArray[i + n] = this.read_wchar();
        }
    }

    public Object read_Object(Class clazz) {
        Class clazz2;
        RemoteInfo remoteInfo;
        IOR iOR = new IOR(this);
        if (iOR.isNull()) {
            return null;
        }
        if (clazz == null && iOR.getTypeId().isIDLType() && (remoteInfo = RemoteInfo.findRemoteInfo(iOR.getTypeId(), iOR.getCodebase())) != null && (clazz2 = remoteInfo.getTheClass()) != null) {
            clazz = Utils.getStubFromClass(clazz2);
        }
        try {
            if (iOR.getTypeId().isIDLType()) {
                try {
                    return IIOPReplacer.createCORBAStub(iOR, clazz == null ? null : Utils.getClassFromStub(clazz), clazz);
                }
                catch (InstantiationException instantiationException) {
                    return IIOPReplacer.makeInvocationHandler(iOR, clazz);
                }
            }
            return IIOPReplacer.makeInvocationHandler(iOR, clazz);
        }
        catch (IOException iOException) {
            throw new MARSHAL("IOException reading CORBA object " + iOException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MARSHAL("IllegalAccessException reading CORBA object " + illegalAccessException.getMessage());
        }
    }

    public Object read_Object() {
        return this.read_Object(null);
    }

    private final char read_UTF8wchar() {
        this.align(1);
        long l = 0L;
        byte by = 0;
        if (this.getMinorVersion() >= 2) {
            by = this.read_octet();
        }
        return this.readUTF8wchar();
    }

    private final char readUTF8wchar() {
        int n = this.read_octet() & 0xFF;
        if ((n & 0x80) != 0) {
            if ((n & 0xE0) == 192) {
                int n2 = this.read_octet() & 0xFF;
                n = ((n & 0x1F) << 6) + (n2 & 0x3F);
            } else {
                int n3 = this.read_octet() & 0xFF;
                int n4 = this.read_octet() & 0xFF;
                n = ((n & 0xF) << 12) + ((n3 & 0x3F) << 6) + (n4 & 0x3F);
            }
        }
        return (char)n;
    }

    private final String readUTF8String(int n) {
        int n2;
        char[] cArray = new char[n];
        int n3 = 0;
        this.checkChunk(n);
        boolean bl = this.chunking;
        this.chunking = false;
        for (int i = 0; i < n; i += n2 - this.chunkPos) {
            int n4;
            while (this.head.end - this.chunkPos < 3 && i < n) {
                n4 = this.pos();
                cArray[n3++] = this.readUTF8wchar();
                i += this.pos() - n4;
            }
            n4 = IIOPInputStream.min(this.head.end - this.chunkPos - 2, n - i);
            n2 = this.chunkPos;
            while (n2 < this.chunkPos + n4) {
                int n5;
                if (((n5 = this.head.buf[n2++] & 0xFF) & 0x80) != 0) {
                    int n6;
                    if ((n5 & 0xE0) == 192) {
                        n6 = this.head.buf[n2++] & 0xFF;
                        n5 = ((n5 & 0x1F) << 6) + (n6 & 0x3F);
                    } else {
                        n6 = this.head.buf[n2++] & 0xFF;
                        int n7 = this.head.buf[n2++] & 0xFF;
                        n5 = ((n5 & 0xF) << 12) + ((n6 & 0x3F) << 6) + (n7 & 0x3F);
                    }
                }
                cArray[n3++] = (char)n5;
            }
            this.chunkPos = n2;
        }
        this.chunking = bl;
        return StringUtils.getString((char[])cArray, (int)0, (int)n3);
    }

    private final char readUTF16wchar(boolean bl) {
        int n = this.read_octet() & 0xFF;
        int n2 = this.read_octet() & 0xFF;
        if (bl) {
            return (char)((n2 << 8) + (n << 0));
        }
        return (char)((n << 8) + (n2 << 0));
    }

    private final String readUTF16String(int n) {
        if (n < 2) {
            return NULL_STRING;
        }
        char[] cArray = new char[n / 2];
        int n2 = 2;
        int n3 = 0;
        boolean bl = this.littleEndian;
        this.checkChunk(n);
        boolean bl2 = this.chunking;
        this.chunking = false;
        int n4 = this.read_octet() & 0xFF;
        int n5 = this.read_octet() & 0xFF;
        if (n4 == 255 && n5 == 254) {
            bl = true;
        } else if (n4 == 254 && n5 == 255) {
            bl = false;
        } else {
            cArray[n3++] = bl ? (char)((n5 << 8) + (n4 << 0)) : (char)((n4 << 8) + (n5 << 0));
        }
        while (n2 < n) {
            if (this.head.end - this.chunkPos < 2) {
                cArray[n3++] = this.readUTF16wchar(bl);
                n2 += 2;
            }
            int n6 = IIOPInputStream.min(this.head.end - this.chunkPos - (this.head.end - this.chunkPos) % 2, n - n2);
            int n7 = this.chunkPos;
            this.chunkPos += n6;
            if (bl) {
                while (n7 < this.chunkPos) {
                    n4 = this.head.buf[n7++] & 0xFF;
                    n5 = this.head.buf[n7++] & 0xFF;
                    cArray[n3++] = (char)((n5 << 8) + (n4 << 0));
                }
            } else {
                while (n7 < this.chunkPos) {
                    n4 = this.head.buf[n7++] & 0xFF;
                    n5 = this.head.buf[n7++] & 0xFF;
                    cArray[n3++] = (char)((n4 << 8) + (n5 << 0));
                }
            }
            n2 += n6;
        }
        this.chunking = bl2;
        return StringUtils.getString((char[])cArray, (int)0, (int)n3);
    }

    public final String read_wstring() {
        int n = this.read_ulong();
        if (n == 0) {
            return NULL_STRING;
        }
        if (n > 0x4000000) {
            throw new MARSHAL("Stream corrupted at " + this.pos() + ": tried to read wstring of length " + Integer.toHexString(n));
        }
        if (this.getMinorVersion() < 2) {
            return GIOP10Helper.read_wstring(this, this.getWcharCodeSet(), this.littleEndian, n);
        }
        String string = null;
        switch (this.getWcharCodeSet()) {
            case 0x5010001: {
                string = this.readUTF8String(n);
                break;
            }
            case 65792: 
            case 65801: {
                string = this.readUTF16String(n);
                break;
            }
            default: {
                throw new CODESET_INCOMPATIBLE("Unsupported codeset: " + Integer.toHexString(this.getWcharCodeSet()));
            }
        }
        return string;
    }

    public final Chunk readChunks() throws IOException {
        Chunk chunk;
        int n = this.read_long();
        Debug.assertion((this.fragmentHead == null ? 1 : 0) != 0);
        if (n > this.head.end - this.chunkPos) {
            Chunk chunk2;
            chunk = Chunk.split((Chunk)this.head, (int)this.chunkPos);
            this.head.next = chunk2 = Chunk.split((Chunk)chunk, (int)n);
        } else {
            chunk = Chunk.getChunk();
            System.arraycopy(this.head.buf, this.chunkPos, chunk.buf, 0, n);
            this.chunkPos += n;
        }
        return chunk;
    }

    public void read_ushort_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new MARSHAL("null array as parameter to read_ushort_array");
        }
        for (int i = n; i < n2; ++i) {
            sArray[i] = this.read_ushort();
        }
    }

    public final Any read_any() {
        return this.read_any(this.read_TypeCode());
    }

    public final Any read_any(TypeCode typeCode) {
        Debug.assertion((typeCode != null ? 1 : 0) != 0);
        AnyImpl anyImpl = new AnyImpl();
        anyImpl.type(typeCode);
        anyImpl.read_value((org.omg.CORBA.portable.InputStream)this, anyImpl.type());
        return anyImpl;
    }

    public final void read_any(Any any, TypeCode typeCode) {
        Debug.assertion((any != null ? 1 : 0) != 0);
        if (any instanceof AnyImpl) {
            any.type(typeCode);
            any.read_value((org.omg.CORBA.portable.InputStream)this, typeCode);
        } else {
            Any any2 = this.read_any(typeCode);
            OutputStream outputStream = any.create_output_stream();
            any2.write_value(outputStream);
            any.read_value(outputStream.create_input_stream(), any.type());
        }
    }

    public java.lang.Object readAny() {
        TypeCode typeCode = this.read_TypeCode();
        java.lang.Object var3_2 = null;
        java.lang.Object object = null;
        int n = 0;
        n = typeCode.kind().value();
        if (n == 21) {
            try {
                n = typeCode.content_type().kind().value();
                typeCode = typeCode.content_type();
            }
            catch (BadKind badKind) {
                throw new MARSHAL("IOException reading Any " + badKind.getMessage());
            }
        }
        RepositoryId repositoryId = TypeCodeImpl.getRepositoryId(typeCode);
        switch (n) {
            case 14: {
                IOR iOR = new IOR(this);
                try {
                    IIOPReplacer.getIIOPReplacer();
                    object = IIOPReplacer.resolveObject(iOR);
                    break;
                }
                catch (IOException iOException) {
                    throw new MARSHAL("IOException reading Any " + iOException.getMessage());
                }
            }
            case 32: {
                boolean bl = this.read_boolean();
                if (!bl) {
                    if (repositoryId.equals(RepositoryId.NULL)) {
                        object = this.read_value();
                        break;
                    }
                    object = this.read_value(repositoryId);
                    break;
                }
                IOR iOR = new IOR(this);
                try {
                    IIOPReplacer.getIIOPReplacer();
                    object = IIOPReplacer.resolveObject(iOR);
                    break;
                }
                catch (IOException iOException) {
                    throw new MARSHAL("IOException reading Any " + iOException.getMessage());
                }
            }
            case 29: {
                object = this.read_value(repositoryId);
                break;
            }
            case 30: {
                object = this.read_value(repositoryId);
                break;
            }
            default: {
                throw new MARSHAL("Can't handle TypeCode: " + n + " at pos: " + this.pos());
            }
        }
        return object;
    }

    public final long startEncapsulation() {
        return this.startEncapsulation(true);
    }

    final long startEncapsulation(boolean bl) {
        int n = this.read_long();
        if (n > 0) {
            ++this.nestingLevel;
            if (this.chunking) {
                this.checkChunk(0);
            }
            int n2 = this.pos();
            long l = this.chunking ? (long)n2 : (long)(n2 + n);
            Debug.assertion(((l & 0xFFFFFFFFC0000000L) == 0L ? 1 : 0) != 0);
            if (this.littleEndian) {
                l |= Integer.MIN_VALUE;
            }
            if (this.needLongAlignment > 0) {
                l |= 0x40000000L;
            }
            int n3 = this.needLongAlignment = (this.streamPos + this.chunkPos) % 8 != 0 ? 4 : 0;
            if (this.chunking) {
                l |= 0x20000000L;
                if (this.encapsulations == null) {
                    this.encapsulations = IIOPInputStream.getHashMap();
                }
                this.encapsulations.put(n2, new EncapsulationWrapper(n, this.chunking, this.chunkLength, this.endTag));
                this.chunking = false;
                this.chunkLength = 0;
                this.endTag = 0;
            }
            if (bl) {
                this.consumeEndian();
            }
            return l;
        }
        return 0L;
    }

    public void endEncapsulation(long l) {
        if (l == 0L) {
            return;
        }
        --this.nestingLevel;
        this.littleEndian = (l & Integer.MIN_VALUE) != 0L;
        this.needLongAlignment = (l & 0x40000000L) != 0L ? 4 : 0;
        boolean bl = (l & 0x20000000L) != 0L;
        l &= 0x1FFFFFFFL;
        if (bl) {
            EncapsulationWrapper encapsulationWrapper = (EncapsulationWrapper)this.encapsulations.remove((int)l);
            if (encapsulationWrapper == null) {
                throw new MARSHAL("No encapsulation information at: " + this.pos());
            }
            l += (long)encapsulationWrapper.encapLength;
            this.chunking = encapsulationWrapper.chunking;
            this.endTag = encapsulationWrapper.endTag;
            this.chunkLength = encapsulationWrapper.chunkLength;
            this.checkChunk(encapsulationWrapper.encapLength);
        } else {
            this.chunking = false;
        }
        if (l > (long)this.pos()) {
            this.skip(l - (long)this.pos());
            return;
        }
        if (l < (long)this.pos()) {
            throw new MARSHAL("read beyond encapsulation at position: " + this.pos());
        }
    }

    public void start_value() {
        this.startValue();
    }

    public boolean startValue() {
        int n;
        int n2 = this.read_long();
        if (n2 == 0) {
            return false;
        }
        if (n2 == -1) {
            throw new MARSHAL("Illegal indirection for serial format version 2 data at " + this.pos());
        }
        if ((n2 & 6) != 2) {
            throw new MARSHAL("Illegal value tag: " + Integer.toHexString(n2) + " for serial format version 2 data at " + this.pos());
        }
        boolean bl = this.chunking;
        this.chunking = false;
        String string = (String)this.read_indirection();
        if (string == null) {
            n = this.pos();
            string = this.read_string();
            this.addIndirection(n, string);
        }
        this.chunking = bl;
        int n3 = n = (n2 & 8) == 8 ? 1 : 0;
        if (n != 0 || this.chunking) {
            this.startChunk();
        }
        return true;
    }

    public void end_value() {
        if (this.chunking) {
            this.endChunk(true);
        }
    }

    public Serializable read_value() {
        return this.read_value((Class)null);
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        return this.read_value((Class)null);
    }

    /*
     * Unable to fully structure code
     */
    public Serializable read_value(Class var1_1) {
        var2_2 = var1_1;
        var3_3 = 0;
        var4_4 = this.read_long();
        if (var4_4 == 0) {
            return null;
        }
        if (var4_4 == -1) {
            var3_3 = this.read_long();
            Debug.assertion((boolean)(var3_3 < -4));
            var3_3 = var3_3 + this.pos() - 4;
            Debug.assertion((boolean)(var3_3 > 0));
            var5_5 = (Serializable)this.getIndirection(var3_3);
            if (var5_5 == null) {
                throw new IndirectionException(var3_3);
            }
            return var5_5;
        }
        var3_3 = this.pos() - 4;
        var5_6 = this.indirections.reserve(var3_3);
        var6_7 = this.chunking;
        this.chunking = false;
        var7_8 = (var4_4 & 1) == 1;
        var8_9 = null;
        var9_10 = 0;
        if (var7_8 && (var8_9 = (String)this.read_indirection()) == null) {
            var9_10 = this.pos();
            var8_9 = this.read_string();
            this.addIndirection(var9_10, var8_9);
        }
        if (var8_9 == null) {
            var8_9 = this.getPossibleCodebase();
        }
        var10_11 = null;
        var11_12 = null;
        switch (var4_4 & 6) {
            case 0: {
                break;
            }
            case 2: {
                var10_11 = this.readIndirectingRepositoryId(var8_9);
                var11_12 = var10_11.getRepositoryId();
                break;
            }
            case 6: {
                var12_13 = this.readIndirectingRepositoryIdList(var8_9);
                var10_11 = var12_13[0];
                var11_12 = var10_11.getRepositoryId();
            }
        }
        this.chunking = var6_7;
        v0 = var12_14 = (var4_4 & 8) == 8;
        if (!this.useCompliantChunking()) {
            --this.endTag;
        }
        if (var12_14 || this.chunking) {
            this.startChunk();
        }
        if (var11_12 != null) {
            if (var11_12.isClassDesc()) {
                var8_9 = (String)this.read_value(String.class);
                var13_15 = (String)this.read_value(String.class);
                if (var8_9 != null && (var8_9.startsWith("RMI:") || var8_9.startsWith("IDL:"))) {
                    var14_17 = var8_9;
                    var8_9 = var13_15;
                    var13_15 = var14_17;
                }
                if ((var14_17 = Utils.getClassFromID(new RepositoryId((String)var13_15), var8_9)) == null) {
                    throw new MARSHAL("Class not found: " + (String)var13_15);
                }
                this.indirections.putReserved(var5_6, var3_3, var14_17);
                if (this.chunking) {
                    this.endChunk(var6_7);
                }
                if (!this.useCompliantChunking()) {
                    ++this.endTag;
                }
                return var14_17;
            }
            if (var11_12.compareStrings(RepositoryId.OLD_EJB_EXCEPTION)) {
                var11_12 = RepositoryId.EJB_EXCEPTION;
                var10_11 = ClassInfo.findClassInfo(var11_12);
            }
        }
        var13_16 = null;
        if (var11_12 == null) {
            var10_11 = ClassInfo.findClassInfo(var2_2);
            var11_12 = var10_11.getRepositoryId();
        } else if (var10_11 != null) {
            var2_2 = var10_11.forClass();
        }
        if (var2_2 == String.class || var11_12.compareStrings(RepositoryId.STRING)) {
            var13_16 = this.read_wstring();
            this.indirections.putReserved(var5_6, var3_3, var13_16);
        } else if (var2_2 != null && var10_11.isIDLEntity()) {
            var13_16 = this.read_IDLValue(var2_2);
            this.indirections.putReserved(var5_6, var3_3, var13_16);
        } else if (var2_2 != null && (var2_2.isArray() || var10_11.getRepositoryId() == var10_11.getLocalRepositoryId()) && (Externalizable.class.isAssignableFrom(var2_2) || ObjectStreamClass.supportsUnsafeSerialization())) {
            try {
                var14_18 = ObjectStreamClass.lookup((Class)var2_2);
                var13_16 = (Serializable)ValueHandlerImpl.allocateValue((org.omg.CORBA.portable.InputStream)this, var14_18);
                this.indirections.putReserved(var5_6, var3_3, var13_16);
                var15_21 = (Serializable)ValueHandlerImpl.readValue(this, var14_18, var13_16);
                if (var15_21 == var13_16) ** GOTO lbl97
                var13_16 = var15_21;
                this.indirections.putReserved(var5_6, var3_3, var13_16);
            }
            catch (ClassNotFoundException var14_19) {
                throw Utils.wrapMARSHALWithCause(var14_19);
            }
            catch (IOException var14_20) {
                throw Utils.wrapMARSHALWithCause(var14_20);
            }
        } else {
            var13_16 = IIOPInputStream.valueHandler.readValue((org.omg.CORBA.portable.InputStream)this, var3_3, var2_2, var11_12.toString(), this.endPoint != null ? this.endPoint.getRemoteCodeBase() : null);
            this.indirections.putReserved(var5_6, var3_3, var13_16);
        }
lbl97:
        // 5 sources

        if (this.chunking) {
            this.endChunk(var6_7);
        }
        if (!this.useCompliantChunking()) {
            ++this.endTag;
        }
        return var13_16;
    }

    public Serializable read_value(RepositoryId repositoryId) {
        Class clazz = null;
        if (repositoryId != null) {
            ClassInfo classInfo = ClassInfo.findClassInfo(repositoryId);
            clazz = classInfo.forClass();
        }
        return this.read_value(clazz);
    }

    public Serializable read_value(String string) {
        java.lang.Object var2_2 = null;
        if (string != null && string.length() > 0) {
            return this.read_value(new RepositoryId(string));
        }
        return this.read_value((Class)null);
    }

    public Serializable read_value(Serializable serializable) {
        if (serializable instanceof StreamableValue) {
            StreamableValue streamableValue = (StreamableValue)serializable;
            int n = this.pos();
            this.addIndirection(n, serializable);
            streamableValue._read((org.omg.CORBA.portable.InputStream)this);
            return serializable;
        }
        throw Utils.wrapMARSHALWithCause(new NO_IMPLEMENT());
    }

    private final Serializable read_IDLValue(Class clazz) {
        try {
            if (CustomValue.class.isAssignableFrom(clazz)) {
                throw new MARSHAL("Custom marshalled valuetypes not supported");
            }
            if (StreamableValue.class.isAssignableFrom(clazz)) {
                ValueFactory valueFactory = (ValueFactory)Utils.getHelper(clazz, "DefaultFactory").newInstance();
                return valueFactory.read_value((InputStream)this);
            }
            if (ValueBase.class.isAssignableFrom(clazz)) {
                BoxedValueHelper boxedValueHelper = (BoxedValueHelper)Utils.getHelper(clazz, "Helper").newInstance();
                return boxedValueHelper.read_value((org.omg.CORBA.portable.InputStream)this);
            }
            return this.read_IDLEntity(clazz);
        }
        catch (InstantiationException instantiationException) {
            throw new MARSHAL(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MARSHAL(illegalAccessException.getMessage());
        }
    }

    final IDLEntity read_IDLEntity(Class clazz) {
        return IIOPInputStream.read_IDLEntity((org.omg.CORBA.portable.InputStream)this, clazz);
    }

    public static final IDLEntity read_IDLEntity(org.omg.CORBA.portable.InputStream inputStream, Class clazz) {
        Class clazz2 = Utils.getIDLHelper(clazz);
        if (clazz2 == null) {
            throw new MARSHAL("Couldn't find helper for " + clazz.getName());
        }
        return (IDLEntity)IIOPInputStream.readWithHelper(inputStream, clazz2);
    }

    public static final java.lang.Object readWithHelper(org.omg.CORBA.portable.InputStream inputStream, Class clazz) {
        try {
            Method method = Utils.getDeclaredMethod(clazz, READ_METHOD, READ_METHOD_ARGS);
            if (method == null) {
                throw new MARSHAL("No read method for " + clazz.getName());
            }
            return method.invoke(null, inputStream);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Utils.wrapMARSHALWithCause(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Utils.wrapMARSHALWithCause(invocationTargetException.getTargetException());
        }
    }

    public java.lang.Object read_abstract_interface() {
        if (this.read_boolean()) {
            return this.read_Object();
        }
        return this.read_value();
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        if (this.read_boolean()) {
            return this.read_Object();
        }
        return this.read_value(clazz);
    }

    public String dumpBuf() {
        StringBuffer stringBuffer = new StringBuffer(Hex.dump((byte[])this.head.buf, (int)this.chunkPos, (int)(this.head.end - this.chunkPos)));
        Chunk chunk = this.head.next;
        while (chunk != null) {
            stringBuffer.append("\n").append(Hex.dump((byte[])chunk.buf, (int)0, (int)chunk.end));
            chunk = chunk.next;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "IIOPInputStream:\n" + this.dumpBuf();
    }

    private static final String getStringBytes(byte[] byArray, int n) {
        String string = null;
        try {
            switch (n) {
                case 0x5010001: {
                    string = new String(byArray, "utf-8");
                    break;
                }
                case 65568: {
                    string = new String(byArray, 0);
                    break;
                }
                case 65537: {
                    string = new String(byArray, "iso-8859-1");
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        return string;
    }

    public final String read_string() {
        int n = this.read_ulong();
        if (n > 0x4000000) {
            throw new MARSHAL("Stream corrupted at " + this.pos() + ": tried to read string of length " + Integer.toHexString(n));
        }
        if (n == 0) {
            return NULL_STRING;
        }
        byte[] byArray = new byte[n - 1];
        this.read_octet_array(byArray, 0, byArray.length);
        String string = IIOPInputStream.getStringBytes(byArray, this.char_codeset);
        this.read_octet();
        return string;
    }

    public final int read_numeric_string() throws NumberFormatException {
        int n = this.read_ulong();
        int n2 = 0;
        int n3 = 1;
        if (n <= 1) {
            if (n == 1) {
                this.read_octet();
            }
            throw new NumberFormatException(NULL_STRING);
        }
        if (n > 524288) {
            throw new MARSHAL("Stream corrupted at " + this.pos() + ": tried to read string of length " + Integer.toHexString(n));
        }
        byte[] byArray = new byte[n - 1];
        this.read_octet_array(byArray, 0, byArray.length);
        for (int i = n - 2; i >= 0; --i) {
            if (byArray[i] <= 57 && byArray[i] >= 48) {
                n2 += (byArray[i] - 48) * n3;
                n3 *= 10;
                continue;
            }
            if (byArray[i] == 45) {
                n2 = -n2;
                continue;
            }
            if (byArray[i] == 43) continue;
            String string = IIOPInputStream.getStringBytes(byArray, this.char_codeset);
            this.read_octet();
            throw new NumberFormatException(string);
        }
        this.read_octet();
        return n2;
    }

    final String read_guessed_string(String string, byte[] byArray) {
        int n = this.read_ulong();
        Debug.assertion((string != null && byArray != null ? 1 : 0) != 0);
        if (n > 524288) {
            throw new MARSHAL("Stream corrupted at " + this.pos() + ": tried to read string of length " + Integer.toHexString(n));
        }
        if (n <= 1) {
            if (n == 1) {
                this.read_octet();
            }
            return NULL_STRING;
        }
        if (!(byArray.length != n - 1 || this.chunkPos + n > this.head.end || this.chunking && n > this.chunkLength)) {
            int n2 = 0;
            int n3 = this.chunkPos;
            while (n2 < n - 1 && byArray[n2++] == this.head.buf[this.chunkPos++]) {
            }
            if (n2 == n - 1) {
                ++this.chunkPos;
                if (this.chunking) {
                    this.chunkLength -= n;
                }
                return string;
            }
            this.chunkPos = n3;
        }
        byte[] byArray2 = new byte[n - 1];
        this.read_octet_array(byArray2, 0, byArray2.length);
        String string2 = IIOPInputStream.getStringBytes(byArray2, this.char_codeset);
        this.read_octet();
        return string2;
    }

    final void annotateStream() {
        this.annotation = Utils.getAnnotation(null);
    }

    public final RepositoryId read_repository_id() {
        return this.read_repository_id(this.read_ulong());
    }

    private final RepositoryId read_repository_id(int n) {
        if (n > 524288) {
            throw new MARSHAL("Stream corrupted at " + this.pos() + ": tried to read string of length " + Integer.toHexString(n));
        }
        if (n <= 1) {
            if (n == 1) {
                this.read_octet();
            }
            return null;
        }
        return new RepositoryId((org.omg.CORBA.portable.InputStream)this, n);
    }

    private final ClassInfo readIndirectingRepositoryId(String string) {
        ClassInfo classInfo = (ClassInfo)this.read_indirection();
        if (classInfo == null) {
            int n = this.read_ulong();
            int n2 = this.pos() - 4;
            RepositoryId repositoryId = this.read_repository_id(n);
            if (repositoryId != null) {
                classInfo = ClassInfo.findClassInfo(repositoryId, string);
                this.addIndirection(n2, classInfo);
            }
        }
        return classInfo;
    }

    private final ClassInfo[] readIndirectingRepositoryIdList(String string) {
        ClassInfo[] classInfoArray = (ClassInfo[])this.read_indirection();
        if (classInfoArray == null) {
            classInfoArray = new ClassInfo[this.read_long()];
            int n = this.pos() - 4;
            int n2 = this.indirections.reserve(n);
            for (int i = 0; i < classInfoArray.length; ++i) {
                classInfoArray[i] = this.readIndirectingRepositoryId(string);
            }
            this.indirections.putReserved(n2, n, classInfoArray);
        }
        return classInfoArray;
    }

    private final java.lang.Object read_indirection() {
        java.lang.Object object = null;
        this.mark(0);
        if (this.read_long() == -1) {
            int n = this.read_long();
            Debug.assertion((n < -4 ? 1 : 0) != 0);
            n = n + this.pos() - 4;
            Debug.assertion((n > 0 ? 1 : 0) != 0);
            object = this.getIndirection(n);
            this.clearMark();
            if (object == null) {
                throw new IndirectionException(n);
            }
        } else {
            this.reset();
        }
        return object;
    }

    final void discard_string() {
        this.read_octet_sequence();
    }

    public Principal read_Principal() {
        int n = this.read_ulong();
        this.skip(n);
        return null;
    }

    private final TypeCode getTypeCodeIndirection(int n) {
        if (this.tcIndirections == null) {
            return null;
        }
        return (TypeCode)this.tcIndirections.get(n);
    }

    private final int addTypeCodeIndirection(int n) {
        if (this.tcIndirections == null) {
            this.tcIndirections = IIOPInputStream.getHashMap();
        }
        return this.tcIndirections.reserve(n);
    }

    public TypeCode read_TypeCode() {
        TypeCodeImpl typeCodeImpl;
        int n = -1;
        this.align(4);
        int n2 = this.pos();
        if (this.tcNestingLevel == 0 && this.tcIndirections != null) {
            this.tcIndirections.clear();
        }
        ++this.tcNestingLevel;
        int n3 = this.read_long();
        if (n3 != -1) {
            n = this.addTypeCodeIndirection(n2);
            typeCodeImpl = new TypeCodeImpl(n3);
            this.tcIndirections.putReserved(n, n2, (java.lang.Object)typeCodeImpl);
            typeCodeImpl.read(this);
        } else {
            n2 = this.pos();
            typeCodeImpl = this.getTypeCodeIndirection(n2 += this.read_ulong());
            if (typeCodeImpl == null) {
                throw new MARSHAL("Couldn't read indirected TypeCode at " + this.pos() + " indirection to " + n2);
            }
        }
        --this.tcNestingLevel;
        return typeCodeImpl;
    }

    private void throwOptionalData(int n) throws OptionalDataException {
        try {
            OptionalDataException optionalDataException = (OptionalDataException)odeCtor.newInstance(new Boolean(true));
            optionalDataException.length = n;
            throw optionalDataException;
        }
        catch (Exception exception) {
            throw new AssertionError("Couldn't build an OptionalDataException");
        }
    }

    public final void readFully(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new MARSHAL("null array as parameter to readFully");
        }
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        this.read_octet_array(byArray, n, n2);
    }

    public final int skipBytes(int n) throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        return (int)this.skip(n);
    }

    public final boolean readBoolean() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        return this.read_boolean();
    }

    public final byte readByte() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        return this.read_octet();
    }

    public final int readUnsignedByte() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        return this.read_octet() & 0xFF;
    }

    public final short readShort() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        return this.read_short();
    }

    public final int readUnsignedShort() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        return this.read_unsigned_short();
    }

    public final char readChar() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        return this.read_wchar();
    }

    public final int readInt() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        return this.read_long();
    }

    public final long readLong() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        return this.read_longlong();
    }

    public final float readFloat() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        return this.read_float();
    }

    public final double readDouble() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        return this.read_double();
    }

    public final String readLine() throws IOException {
        if (this.eof()) {
            this.throwOptionalData(0);
        }
        throw new IOException("readLine() is not supportable for IIOP streams");
    }

    public final String readUTF() throws IOException {
        if (this.eof()) {
            this.throwOptionalData(0);
        }
        return this.read_wstring();
    }

    public String readUTF8() throws IOException {
        int n;
        if (this.eof()) {
            this.throwOptionalData(0);
        }
        if ((n = this.read_ulong()) == 0) {
            return NULL_STRING;
        }
        if (n > 0x4000000) {
            throw new MARSHAL("Stream corrupted at " + this.pos() + ": tried to read wstring of length " + Integer.toHexString(n));
        }
        return this.readUTF8String(n);
    }

    public final String readASCII() throws IOException {
        if (this.eof()) {
            this.throwOptionalData(0);
        }
        return this.read_string();
    }

    public final java.lang.Object readObject() throws ClassNotFoundException, IOException {
        if (this.eof()) {
            this.throwOptionalData(0);
        }
        return this.read_abstract_interface();
    }

    public final java.lang.Object readObject(Class clazz) throws ClassNotFoundException, IOException {
        try {
            if (Remote.class.isAssignableFrom(clazz)) {
                IOR iOR = new IOR(this);
                if (clazz != null && IDLUtils.isARemote(clazz)) {
                    RemoteInfo remoteInfo = RemoteInfo.findRemoteInfo(clazz);
                    IIOPReplacer.getIIOPReplacer();
                    return IIOPReplacer.resolveObject(iOR, remoteInfo);
                }
                IIOPReplacer.getIIOPReplacer();
                return IIOPReplacer.resolveObject(iOR);
            }
            if (clazz.equals(java.lang.Object.class) || clazz.equals(Serializable.class) || clazz.equals(Externalizable.class)) {
                return this.readAny();
            }
            if (Object.class.isAssignableFrom(clazz)) {
                return this.read_Object(clazz);
            }
            if (Utils.isIDLException(clazz)) {
                return this.read_IDLEntity(clazz);
            }
            if (Utils.isAbstractInterface(clazz)) {
                return this.read_abstract_interface(clazz);
            }
            return this.read_value(clazz);
        }
        catch (SystemException systemException) {
            throw Utils.mapSystemException(systemException);
        }
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eof()) {
            return -1;
        }
        if (this.chunking) {
            n2 = IIOPInputStream.min(n2, this.chunkLength);
        }
        int n3 = 0;
        if (this.needEightByteAlignment) {
            this.checkEightByteAlignment();
        }
        if (byArray == null) {
            throw new MARSHAL("null array as parameter to read_octet_array");
        }
        while (n2 > 0 && (this.head != null || this.fragmentHead != null)) {
            if (this.chunkPos == this.head.end) {
                this.advance();
            }
            int n4 = IIOPInputStream.min(this.head.end - this.chunkPos, n2);
            this.checkChunk(n4);
            System.arraycopy(this.head.buf, this.chunkPos, byArray, n, n4);
            this.chunkPos += n4;
            n += n4;
            n2 -= n4;
            n3 += n4;
        }
        return n3;
    }

    public final int available() throws IOException {
        return 0;
    }

    static void p(String string) {
        System.err.println("<IIOPInputStream> " + string);
    }

    public ServerChannel getServerChannel() {
        if (this.endPoint == null) {
            return null;
        }
        return this.endPoint.getServerChannel();
    }

    final void setReadingObjectKey(boolean bl) {
        this.readingObjectKey = bl;
    }

    final boolean isReadingObjectKey() {
        return this.readingObjectKey;
    }

    static {
        IIOPService.load();
        valueHandler = Util.createValueHandler();
        READ_METHOD_ARGS = new Class[]{org.omg.CORBA.portable.InputStream.class};
        NO_ARGS_METHOD = new Class[0];
        NO_ARGS = new java.lang.Object[0];
        mapPool = new StackPool(1024);
        odeCtor = null;
        try {
            odeCtor = OptionalDataException.class.getDeclaredConstructor(Boolean.TYPE);
            odeCtor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static final class Marker {
        int streamPos;
        int chunkPos;
        Chunk head;
        Fragment fragmentHead;
        int chunkLength;

        Marker() {
        }

        void copy(Marker marker) {
            this.streamPos = marker.streamPos;
            this.chunkPos = marker.chunkPos;
            this.head = marker.head;
            this.fragmentHead = marker.fragmentHead;
            this.chunkLength = marker.chunkLength;
        }
    }

    static class EncapsulationWrapper {
        int encapLength;
        boolean chunking;
        int chunkLength;
        int endTag;

        EncapsulationWrapper(int n, boolean bl, int n2, int n3) {
            this.chunking = bl;
            this.chunkLength = n2;
            this.encapLength = n;
            this.endTag = n3;
        }
    }

    private static class Fragment {
        Fragment next;
        int start;
        Chunk chunk;

        Fragment(Chunk chunk, int n) {
            this.chunk = chunk;
            this.start = n;
        }
    }
}

