/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.rmi.Remote;
import javax.management.MBeanInfo;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA.portable.ValueOutputStream;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.corba.idl.TypeCodeImpl;
import weblogic.corba.orb.ORB;
import weblogic.corba.utils.ClassInfo;
import weblogic.corba.utils.IndirectionHashtable;
import weblogic.corba.utils.IndirectionValueHashtable;
import weblogic.corba.utils.MarshaledString;
import weblogic.corba.utils.MarshalledObject;
import weblogic.corba.utils.RepositoryId;
import weblogic.corba.utils.ValueHandlerImpl;
import weblogic.ejb.spi.EJBPortableReplacer;
import weblogic.iiop.CodeSet;
import weblogic.iiop.EndPoint;
import weblogic.iiop.GIOP10Helper;
import weblogic.iiop.IDLMsgOutput;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPReplacer;
import weblogic.iiop.IIOPService;
import weblogic.iiop.IOR;
import weblogic.iiop.ObjectOutputStreamImpl;
import weblogic.iiop.ProxyDesc;
import weblogic.iiop.Utils;
import weblogic.iiop.spi.Message;
import weblogic.iiop.spi.MessageStream;
import weblogic.protocol.AsyncOutgoingMessage;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelStream;
import weblogic.rmi.spi.MsgOutput;
import weblogic.rmi.utils.io.Codebase;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.Hex;
import weblogic.utils.collections.Pool;
import weblogic.utils.collections.StackPool;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkOutput;
import weblogic.utils.io.ObjectOutput;
import weblogic.utils.io.ObjectStreamClass;
import weblogic.utils.io.StringOutput;

public final class IIOPOutputStream
extends org.omg.CORBA_2_3.portable.OutputStream
implements AsyncOutgoingMessage,
ObjectOutput,
PeerInfoable,
ServerChannelStream,
StringOutput,
ValueOutputStream,
ChunkOutput,
MsgOutput,
MessageStream {
    private static final boolean ASSERT = false;
    private static final boolean debugValueTypes = false;
    private static boolean USE_JAVA_SERIALIZATION_FOR_JMX = true;
    private static final boolean DEBUG = false;
    private static final int VT_NON_CHUNKING = 2147483394;
    private static final int VT_CHUNKING = 2147483402;
    private static final int VT_INDIRECTION = -1;
    private static final boolean SUPPORT_CHUNKING = true;
    private static final String EXTRACT_METHOD = "extract";
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;
    private Chunk head;
    private Chunk current;
    private int currentPos = 0;
    private int chunkPos = 0;
    private Chunk queued;
    private int queuedLength;
    private final Marker[] markers = new Marker[]{new Marker(), new Marker()};
    private int minorVersion = 2;
    private boolean SUPPORT_JDK_13_CHUNKING = false;
    private int nestingLevel = 0;
    private boolean nesting = true;
    private org.omg.CORBA.ORB orb = null;
    private int needLongAlignment = 0;
    private boolean needEightByteAlignment = false;
    static final long HANDLE_ENDIAN_MASK = Integer.MIN_VALUE;
    static final long HANDLE_ALIGN_MASK = 0x40000000L;
    static final long HANDLE_CHUNK_MASK = 0x20000000L;
    static final long HANDLE_NESTING_MASK = 0x10000000L;
    private static final int CHAR_BUF_SIZE = 256;
    private final char[] cbuf = new char[256];
    private static final ValueHandler valueHandler;
    private boolean littleEndian;
    private EndPoint endPoint;
    private int char_codeset = CodeSet.getDefaultCharCodeSet();
    private int wchar_codeset = CodeSet.getDefaultWcharCodeSet();
    private java.io.ObjectOutput ooutput;
    private ObjectOutputStream objectStream;
    private IndirectionHashtable encapsulations = null;
    private IndirectionValueHashtable indirections = null;
    private IndirectionValueHashtable tcIndirections = null;
    private int tcNestingLevel = 0;
    private Message message;
    private boolean useJavaSerialization = false;
    private byte maxFormatVersion = 1;
    private static final int MAP_POOL_SIZE = 1024;
    private static final Pool mapPool;
    private boolean chunking = false;
    private int currentChunk = 0;
    private int currentChunkPos = 0;
    private Chunk currentChunkChunk;
    private int endTag = 0;
    private int lastEnd = 0;
    private boolean writingObjectKey = false;

    public IIOPOutputStream() {
        this(false, null, null);
    }

    public IIOPOutputStream(org.omg.CORBA.ORB oRB) {
        this();
        this.orb = oRB;
    }

    public IIOPOutputStream(boolean bl, EndPoint endPoint) {
        this(bl, endPoint, null);
    }

    public IIOPOutputStream(boolean bl, EndPoint endPoint, Message message) {
        this.littleEndian = bl;
        this.endPoint = endPoint;
        this.message = message;
        if (endPoint != null) {
            this.wchar_codeset = endPoint.getWcharCodeSet();
            this.char_codeset = endPoint.getCharCodeSet();
            this.useJavaSerialization = endPoint.getServerChannel().getUseFastSerialization();
        }
        if (message != null) {
            this.minorVersion = message.getMinorVersion();
            this.maxFormatVersion = message.getMaxStreamFormatVersion();
        }
        this.orb = ORB.getInstance();
        this.head = this.current = Chunk.getChunk();
    }

    public void setMaxStreamFormatVersion(byte by) {
        this.maxFormatVersion = by;
    }

    public byte getMaxStreamFormatVersion() {
        return this.maxFormatVersion;
    }

    public long startEncapsulation() {
        return this.startEncapsulation(false, true, this.nesting);
    }

    long startEncapsulationNoEndian() {
        return this.startEncapsulation(false, false, this.nesting);
    }

    long startEncapsulationNoNesting() {
        return this.startEncapsulation(false, true, false);
    }

    private long startEncapsulation(boolean bl, boolean bl2, boolean bl3) {
        this.write_long(0);
        int n = this.pos();
        long l = n;
        Debug.assertion(((l & 0xFFFFFFFFC0000000L) == 0L ? 1 : 0) != 0);
        if (this.littleEndian) {
            l |= Integer.MIN_VALUE;
        }
        if (this.needLongAlignment > 0) {
            l |= 0x40000000L;
        }
        if (this.nesting) {
            ++this.nestingLevel;
            l |= 0x10000000L;
        }
        int n2 = this.needLongAlignment = this.chunkPos % 8 != 0 ? 4 : 0;
        if (this.chunking) {
            l |= 0x20000000L;
            if (this.encapsulations == null) {
                this.encapsulations = IIOPInputStream.getHashMap();
            }
            this.encapsulations.put(n, new IIOPInputStream.EncapsulationWrapper(this.lastEnd, this.chunking, this.currentChunk, this.endTag));
            this.chunking = false;
            this.currentChunk = 0;
            this.currentChunkChunk = null;
            this.currentChunkPos = 0;
            this.endTag = 0;
            this.lastEnd = 0;
        }
        this.littleEndian = bl;
        this.nesting = bl3;
        if (bl2) {
            this.putEndian();
        }
        return l;
    }

    public void endEncapsulation(long l) {
        this.littleEndian = (l & Integer.MIN_VALUE) != 0L;
        boolean bl = this.nesting = (l & 0x10000000L) != 0L;
        if (this.nesting) {
            --this.nestingLevel;
        }
        this.needLongAlignment = (l & 0x40000000L) != 0L ? 4 : 0;
        boolean bl2 = (l & 0x20000000L) != 0L;
        l &= 0xFFFFFFFL;
        if (bl2) {
            IIOPInputStream.EncapsulationWrapper encapsulationWrapper = (IIOPInputStream.EncapsulationWrapper)this.encapsulations.remove((int)l);
            if (encapsulationWrapper == null) {
                throw new MARSHAL("No encapsulation information at: " + this.pos());
            }
            this.chunking = encapsulationWrapper.chunking;
            this.endTag = encapsulationWrapper.endTag;
            this.currentChunk = encapsulationWrapper.chunkLength;
            this.currentChunkChunk = null;
            this.currentChunkPos = 0;
            this.lastEnd = encapsulationWrapper.encapLength;
        } else {
            this.chunking = false;
        }
        long l2 = this.pos();
        this.setPosition((int)(l - 4L));
        this.write_long((int)(l2 - l));
        this.setPosition((int)l2);
    }

    public final void write_octet(byte by) {
        if (this.needEightByteAlignment) {
            this.checkEightByteAlignment();
        }
        if (this.chunking && this.currentChunk == 0) {
            this.startChunk();
        }
        this.advance();
        this.current.buf[this.chunkPos++] = by;
    }

    private final void align(int n) {
        if (this.needEightByteAlignment) {
            this.checkEightByteAlignment();
        }
        if (this.chunking && this.currentChunk == 0) {
            this.startChunk();
        }
        int n2 = this.chunkPos + this.needLongAlignment;
        while (n2 % n != 0) {
            this.advance();
            this.current.buf[this.chunkPos++] = 0;
            ++n2;
        }
    }

    public final void align8() {
        this.align(8);
    }

    public final void setNeedEightByteAlignment() {
        this.needEightByteAlignment = true;
    }

    public final void checkEightByteAlignment() {
        this.needEightByteAlignment = false;
        this.align(8);
    }

    public final void putEndian() {
        if (this.littleEndian) {
            this.write_octet((byte)1);
        } else {
            this.write_octet((byte)0);
        }
    }

    public void startUnboundedEncapsulation() {
        this.putEndian();
        ++this.nestingLevel;
    }

    void reset() {
        Chunk chunk = this.head;
        this.head = this.head.next;
        this.close();
        this.head = chunk;
        this.head.next = null;
        this.head.end = 0;
        this.chunkPos = 0;
        this.current = this.head;
        this.currentPos = 0;
        this.nestingLevel = 0;
        this.nesting = true;
        this.needLongAlignment = 0;
        this.needEightByteAlignment = false;
    }

    public String dumpBuf() {
        byte[] byArray = this.getBuffer();
        return Hex.dump((byte[])byArray, (int)0, (int)byArray.length);
    }

    public final int getMinorVersion() {
        return this.nestingLevel > 0 && (!this.SUPPORT_JDK_13_CHUNKING || this.writingObjectKey) ? 2 : this.minorVersion;
    }

    private final boolean useCompliantChunking() {
        return !this.SUPPORT_JDK_13_CHUNKING || this.nestingLevel != 0 && this.writingObjectKey;
    }

    public final void setMinorVersion(int n) {
        this.minorVersion = n;
        this.SUPPORT_JDK_13_CHUNKING = n < 2;
    }

    public java.io.ObjectOutput getObjectOutput(boolean bl) {
        if (!bl) {
            return this;
        }
        if (this.ooutput == null) {
            this.ooutput = new IDLMsgOutput(this);
        }
        return this.ooutput;
    }

    public ObjectOutputStream getObjectOutputStream(java.lang.Object object, ObjectStreamClass objectStreamClass, byte by) throws IOException {
        if (this.objectStream == null) {
            this.objectStream = new ObjectOutputStreamImpl(this, object, objectStreamClass, by);
        } else {
            ((ObjectOutputStreamImpl)this.objectStream).pushCurrent(object, objectStreamClass, by);
        }
        return this.objectStream;
    }

    public PeerInfo getPeerInfo() {
        if (this.endPoint != null && this.endPoint.getPeerInfo() != null) {
            return this.endPoint.getPeerInfo();
        }
        return PeerInfo.getPeerInfo();
    }

    public void setCodeSets(int n, int n2) {
        this.char_codeset = n;
        this.wchar_codeset = n2;
    }

    private final int getWcharCodeSet() {
        return this.nestingLevel > 0 && !this.SUPPORT_JDK_13_CHUNKING && !this.writingObjectKey ? 65801 : this.wchar_codeset;
    }

    private static final int min(int n, int n2) {
        return n <= n2 ? n : n2;
    }

    private static final int max(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    private final void setMark(int n) {
        this.markers[n].chunk = this.current;
        this.markers[n].pos = this.chunkPos;
        this.markers[n].currentPos = this.currentPos;
    }

    final void setMark(Marker marker) {
        marker.chunk = this.current;
        marker.pos = this.chunkPos;
        marker.currentPos = this.currentPos;
    }

    private final void restoreMark(int n) {
        this.current = this.markers[n].chunk;
        this.chunkPos = this.markers[n].pos;
        this.currentPos = this.markers[n].currentPos;
    }

    final void restoreMark(Marker marker) {
        this.current = marker.chunk;
        this.chunkPos = marker.pos;
        this.currentPos = marker.currentPos;
    }

    private final void setPosition(int n) {
        if (this.currentPos <= n && n - this.currentPos < Chunk.CHUNK_SIZE) {
            this.chunkPos = n - this.currentPos;
        } else {
            this.current = this.head;
            this.currentPos = 0;
            while (n > Chunk.CHUNK_SIZE) {
                if (this.current.next == null) {
                    this.current.next = Chunk.getChunk();
                }
                n -= this.current.end;
                this.currentPos += this.current.end;
                this.current = this.current.next;
            }
            this.chunkPos = n;
        }
    }

    private final int setLength() {
        this.current.end = this.chunkPos;
        int n = this.getSize();
        this.setPosition(8);
        this.write_long(n - 12);
        return n;
    }

    public final void writeTo(OutputStream outputStream) throws IOException {
        if (this.queued == null) {
            if (this.current == null || this.head == null) {
                throw new IOException("writeTo() called on closed stream");
            }
            this.enqueue();
        }
        while (this.queued != null) {
            if (this.queued.end > 0) {
                outputStream.write(this.queued.buf, 0, this.queued.end);
            }
            Chunk chunk = this.queued;
            this.queued = this.queued.next;
            Chunk.releaseChunk((Chunk)chunk);
        }
        this.queuedLength = 0;
    }

    public Chunk getChunks() {
        return this.queued != null ? this.queued : this.head;
    }

    public void cleanup() {
        while (this.queued != null) {
            Chunk chunk = this.queued.next;
            Chunk.releaseChunk((Chunk)this.queued);
            this.queued = chunk;
        }
    }

    public final void enqueue() {
        if (this.queued == null) {
            this.queuedLength = this.setLength();
            this.queued = this.head;
            this.head = null;
            this.close();
        }
    }

    public final int getLength() throws IOException {
        if (this.queued != null) {
            return this.queuedLength;
        }
        return this.getSize();
    }

    public int pos() {
        return this.currentPos + this.chunkPos;
    }

    public byte[] getBuffer() {
        this.current.end = this.chunkPos;
        byte[] byArray = new byte[this.getSize()];
        Chunk chunk = this.head;
        int n = 0;
        while (chunk != null) {
            System.arraycopy(chunk.buf, 0, byArray, n, chunk.end);
            n += chunk.end;
            chunk = chunk.next;
        }
        return byArray;
    }

    byte[] getBufferFromMark(Marker marker) {
        this.current.end = this.chunkPos;
        byte[] byArray = new byte[this.currentPos + this.chunkPos - (marker.currentPos + marker.pos)];
        int n = marker.chunk.end - marker.pos;
        System.arraycopy(marker.chunk.buf, marker.pos, byArray, 0, n);
        Chunk chunk = marker.chunk.next;
        while (chunk != null) {
            System.arraycopy(chunk.buf, 0, byArray, n, chunk.end);
            n += chunk.end;
            chunk = chunk.next;
        }
        return byArray;
    }

    public byte[] getBufferToWrite() {
        if (this.queued == null) {
            this.enqueue();
        }
        byte[] byArray = new byte[this.queuedLength];
        int n = 0;
        while (this.queued != null) {
            System.arraycopy(this.queued.buf, 0, byArray, n, this.queued.end);
            n += this.queued.end;
            Chunk chunk = this.queued;
            this.queued = this.queued.next;
            Chunk.releaseChunk((Chunk)chunk);
        }
        this.queuedLength = 0;
        return byArray;
    }

    public void close() {
        while (this.head != null) {
            Chunk chunk = this.head.next;
            Chunk.releaseChunk((Chunk)this.head);
            this.head = chunk;
        }
        IIOPOutputStream.releaseHashMap(this.indirections);
        this.indirections = null;
        IIOPOutputStream.releaseHashMap(this.tcIndirections);
        this.tcIndirections = null;
        IIOPInputStream.releaseHashMap(this.encapsulations);
        this.encapsulations = null;
        this.current = null;
        this.message = null;
    }

    private final int getSize() {
        Chunk chunk = this.head;
        int n = 0;
        while (chunk != this.current) {
            n += chunk.end;
            chunk = chunk.next;
        }
        return n + this.chunkPos;
    }

    boolean isSecure() {
        if (this.endPoint != null) {
            return this.endPoint.isSecure();
        }
        return false;
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public ServerChannel getServerChannel() {
        if (this.endPoint != null) {
            return this.endPoint.getServerChannel();
        }
        return null;
    }

    public InputStream create_input_stream() {
        this.current.end = this.chunkPos;
        return this.createInputStream(this.head);
    }

    public IIOPInputStream createExactInputStream() {
        this.current.end = this.chunkPos;
        Chunk chunk = new Chunk(this.getSize());
        chunk.end = chunk.buf.length;
        int n = 0;
        while (this.head != null) {
            System.arraycopy(this.head.buf, 0, chunk.buf, n, this.head.end);
            n += this.head.end;
            Chunk chunk2 = this.head;
            this.head = this.head.next;
            Chunk.releaseChunk((Chunk)chunk2);
        }
        return this.createInputStream(chunk);
    }

    private IIOPInputStream createInputStream(Chunk chunk) {
        IIOPInputStream iIOPInputStream = new IIOPInputStream(chunk, this.isSecure(), this.endPoint);
        iIOPInputStream.setCodeSets(this.char_codeset, this.wchar_codeset);
        iIOPInputStream.setEndian(this.littleEndian);
        iIOPInputStream.setORB(this.orb);
        iIOPInputStream.recordStart();
        this.current = null;
        this.head = null;
        this.close();
        return iIOPInputStream;
    }

    public void write_boolean(boolean bl) {
        this.write_octet(bl ? (byte)1 : 0);
    }

    public void write_char(char c) {
        this.write_octet((byte)(c & 0xFF));
    }

    public void write_wchar(char c) {
        char c2 = c;
        block0 : switch (this.getWcharCodeSet()) {
            case 0x5010001: {
                this.write_UTF8wchar(c);
                return;
            }
            case 65792: {
                switch (this.getMinorVersion()) {
                    case 2: {
                        this.write_octet((byte)2);
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.align(2);
                    }
                }
                break;
            }
            case 65801: {
                switch (this.getMinorVersion()) {
                    case 2: {
                        this.write_octet((byte)4);
                        if (this.littleEndian) {
                            this.write_octet((byte)-1);
                            this.write_octet((byte)-2);
                            break block0;
                        }
                        this.write_octet((byte)-2);
                        this.write_octet((byte)-1);
                        break block0;
                    }
                    case 0: 
                    case 1: {
                        this.align(2);
                    }
                }
            }
        }
        if (this.littleEndian) {
            this.write_octet((byte)c2);
            this.write_octet((byte)(c2 >>> 8));
        } else {
            this.write_octet((byte)(c2 >>> 8));
            this.write_octet((byte)c2);
        }
    }

    private final void advance() {
        if (this.chunkPos == Chunk.CHUNK_SIZE) {
            if (this.current.next == null) {
                this.current.next = Chunk.getChunk();
            }
            this.current.end = this.chunkPos;
            this.currentPos += this.chunkPos;
            this.current = this.current.next;
            this.chunkPos = 0;
        }
    }

    public void write_unsigned_short(int n) {
        this.align(2);
        if (this.chunkPos + 2 <= Chunk.CHUNK_SIZE) {
            if (this.littleEndian) {
                this.current.buf[this.chunkPos++] = (byte)n;
                this.current.buf[this.chunkPos++] = (byte)(n >>> 8);
            } else {
                this.current.buf[this.chunkPos++] = (byte)(n >>> 8);
                this.current.buf[this.chunkPos++] = (byte)n;
            }
        } else if (this.littleEndian) {
            this.write_octet((byte)(n & 0xFF));
            this.write_octet((byte)(n >>> 8));
        } else {
            this.write_octet((byte)(n >>> 8));
            this.write_octet((byte)n);
        }
    }

    public void write_ushort(short s) {
        this.write_unsigned_short(s);
    }

    public void write_short(short s) {
        this.write_unsigned_short(s);
    }

    public final void write_long(int n) {
        this.align(4);
        if (this.chunkPos + 4 <= Chunk.CHUNK_SIZE && !this.littleEndian) {
            this.current.buf[this.chunkPos++] = (byte)(n >>> 24);
            this.current.buf[this.chunkPos++] = (byte)(n >>> 16);
            this.current.buf[this.chunkPos++] = (byte)(n >>> 8);
            this.current.buf[this.chunkPos++] = (byte)n;
        } else {
            this.write_slow_long(n);
        }
    }

    public final void write_slow_long(int n) {
        if (this.littleEndian) {
            if (this.chunkPos + 4 <= Chunk.CHUNK_SIZE) {
                this.current.buf[this.chunkPos++] = (byte)n;
                this.current.buf[this.chunkPos++] = (byte)(n >>> 8);
                this.current.buf[this.chunkPos++] = (byte)(n >>> 16);
                this.current.buf[this.chunkPos++] = (byte)(n >>> 24);
            } else {
                this.write_octet((byte)n);
                this.write_octet((byte)(n >>> 8));
                this.write_octet((byte)(n >>> 16));
                this.write_octet((byte)(n >>> 24));
            }
        } else {
            this.write_octet((byte)(n >>> 24));
            this.write_octet((byte)(n >>> 16));
            this.write_octet((byte)(n >>> 8));
            this.write_octet((byte)n);
        }
    }

    public final void write_ulong(int n) {
        this.write_long(n);
    }

    public void write_longlong(long l) {
        this.align(8);
        if (this.chunkPos + 8 <= Chunk.CHUNK_SIZE) {
            if (this.littleEndian) {
                this.current.buf[this.chunkPos++] = (byte)l;
                this.current.buf[this.chunkPos++] = (byte)(l >>> 8);
                this.current.buf[this.chunkPos++] = (byte)(l >>> 16);
                this.current.buf[this.chunkPos++] = (byte)(l >>> 24);
                this.current.buf[this.chunkPos++] = (byte)(l >>> 32);
                this.current.buf[this.chunkPos++] = (byte)(l >>> 40);
                this.current.buf[this.chunkPos++] = (byte)(l >>> 48);
                this.current.buf[this.chunkPos++] = (byte)(l >>> 56);
            } else {
                this.current.buf[this.chunkPos++] = (byte)(l >>> 56);
                this.current.buf[this.chunkPos++] = (byte)(l >>> 48);
                this.current.buf[this.chunkPos++] = (byte)(l >>> 40);
                this.current.buf[this.chunkPos++] = (byte)(l >>> 32);
                this.current.buf[this.chunkPos++] = (byte)(l >>> 24);
                this.current.buf[this.chunkPos++] = (byte)(l >>> 16);
                this.current.buf[this.chunkPos++] = (byte)(l >>> 8);
                this.current.buf[this.chunkPos++] = (byte)l;
            }
        } else if (this.littleEndian) {
            this.write_octet((byte)l);
            this.write_octet((byte)(l >>> 8));
            this.write_octet((byte)(l >>> 16));
            this.write_octet((byte)(l >>> 24));
            this.write_octet((byte)(l >>> 32));
            this.write_octet((byte)(l >>> 40));
            this.write_octet((byte)(l >>> 48));
            this.write_octet((byte)(l >>> 56));
        } else {
            this.write_octet((byte)(l >>> 56));
            this.write_octet((byte)(l >>> 48));
            this.write_octet((byte)(l >>> 40));
            this.write_octet((byte)(l >>> 32));
            this.write_octet((byte)(l >>> 24));
            this.write_octet((byte)(l >>> 16));
            this.write_octet((byte)(l >>> 8));
            this.write_octet((byte)l);
        }
    }

    public void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public void write_string(String string) {
        if (string == null) {
            throw new MARSHAL("null value passed to write_string(String)");
        }
        switch (this.char_codeset) {
            case 65537: 
            case 65568: {
                int n = string.length();
                this.write_ulong(string.length() + 1);
                this.writeASCII(string);
                this.write_octet((byte)0);
                break;
            }
            case 0x5010001: {
                this.write_stringUTF8(string);
                break;
            }
            default: {
                throw new CODESET_INCOMPATIBLE("Unknown char codeset");
            }
        }
    }

    public void write_stringUTF8(String string) {
        int n;
        int n2 = string.length();
        boolean bl = true;
        for (int i = 0; i < n2; i += n) {
            n = IIOPOutputStream.min(256, n2 - i);
            string.getChars(i, i + n, this.cbuf, 0);
            for (int j = 0; j < n; ++j) {
                char c = this.cbuf[j];
                if ((c & 0xFF80) == 0) continue;
                bl = false;
                break;
            }
            if (!bl) break;
        }
        if (!bl) {
            this.writeStringUTF8_1Pass(string, true);
        } else {
            this.write_ulong(string.length() + 1);
            this.writeASCII(string);
            this.write_octet((byte)0);
        }
    }

    public final void write_repository_id(RepositoryId repositoryId) {
        if (repositoryId == null) {
            this.write_ulong(1);
            this.write_octet((byte)0);
        } else {
            repositoryId.write((org.omg.CORBA.portable.OutputStream)this);
        }
    }

    public final void writeRepositoryIdList(RepositoryId[] repositoryIdArray) {
        if (!this.writeIndirectionMaybe((Serializable)repositoryIdArray)) {
            this.write_long(repositoryIdArray.length);
            for (int i = 0; i < repositoryIdArray.length; ++i) {
                if (this.writeIndirectionMaybe(repositoryIdArray[i])) continue;
                this.write_repository_id(repositoryIdArray[i]);
            }
        }
    }

    private final void writeStringUTF16(String string, boolean bl) {
        int n;
        int n2 = string.length();
        this.write_ulong(n2 == 0 ? n2 : n2 * 2 + (bl ? 2 : 0));
        if (n2 != 0 && bl) {
            if (this.littleEndian) {
                this.write_octet((byte)-1);
                this.write_octet((byte)-2);
            } else {
                this.write_octet((byte)-2);
                this.write_octet((byte)-1);
            }
        }
        for (int i = 0; i < n2; i += n) {
            n = IIOPOutputStream.min(n2 - i, 256);
            string.getChars(i, i + n, this.cbuf, 0);
            this.writeCharsUTF16(this.cbuf, n);
        }
    }

    private final void writeCharsUTF16(char[] cArray, int n) {
        this.align(1);
        int n2 = n * 2;
        int n3 = 0;
        int n4 = 8;
        int n5 = 0;
        if (this.littleEndian) {
            n5 = 8;
            n4 = 0;
        }
        while (n3 < n) {
            int n6 = Chunk.CHUNK_SIZE - this.chunkPos;
            if (n6 == 0) {
                this.advance();
            } else if (n6 == 1) {
                this.current.buf[this.chunkPos++] = (byte)(cArray[n3] >>> n4);
                this.advance();
                this.current.buf[this.chunkPos++] = (byte)(cArray[n3++] >>> n5);
                n2 -= 2;
            }
            n6 = Chunk.CHUNK_SIZE - this.chunkPos;
            n6 -= n6 % 2;
            int n7 = IIOPOutputStream.min(n6, n2);
            while (n7 > 0) {
                this.current.buf[this.chunkPos++] = (byte)(cArray[n3] >>> n4);
                this.current.buf[this.chunkPos++] = (byte)(cArray[n3++] >>> n5);
                n7 -= 2;
                n2 -= 2;
            }
        }
    }

    public final void writeUTF8(String string) {
        int n;
        int n2;
        int n3 = string.length();
        block0: for (n = 0; n < n3; n += n2) {
            n2 = IIOPOutputStream.min(256, n3 - n);
            string.getChars(n, n + n2, this.cbuf, 0);
            for (int i = 0; i < n2; ++i) {
                char c = this.cbuf[i];
                if ((c & 0xFF80) != 0) break block0;
            }
        }
        if (n == n3) {
            this.write_ulong(n3);
            this.writeASCII(string);
        } else {
            this.writeStringUTF8_1Pass(string, false);
        }
    }

    private final void writeStringUTF8_1Pass(String string, boolean bl) {
        int n;
        this.align(4);
        int n2 = this.pos();
        this.write_slow_long(0);
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            while (n5 < n3 && this.chunkPos < Chunk.CHUNK_SIZE - 3) {
                int n6;
                n = IIOPOutputStream.min(256, n3 - n5);
                string.getChars(n5, n5 + n, this.cbuf, 0);
                int n7 = this.chunkPos;
                for (n6 = 0; n6 < n && n7 < Chunk.CHUNK_SIZE - 3; ++n6) {
                    char c = this.cbuf[n6];
                    if ((c & 0xFF80) == 0) {
                        this.current.buf[n7++] = (byte)c;
                        continue;
                    }
                    if ((c & 0xF800) == 0) {
                        this.current.buf[n7++] = (byte)(0xC0 | c >> 6 & 0x1F);
                        this.current.buf[n7++] = (byte)(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.current.buf[n7++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this.current.buf[n7++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this.current.buf[n7++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
                n4 += n7 - this.chunkPos;
                this.chunkPos = n7;
                n5 += n6;
            }
            while (n5 < n3 && this.chunkPos >= Chunk.CHUNK_SIZE - 3) {
                n4 += this.writeUTF8Char(string.charAt(n5++));
            }
        }
        n = this.pos();
        this.setPosition(n2);
        if (bl) {
            this.write_slow_long(n4 + 1);
            this.setPosition(n);
            this.write_octet((byte)0);
        } else {
            this.write_slow_long(n4);
            this.setPosition(n);
        }
    }

    public final void writeASCII(String string) {
        int n;
        if (this.chunking && this.currentChunk == 0) {
            this.startChunk();
        }
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            if (this.chunkPos == Chunk.CHUNK_SIZE) {
                this.advance();
            }
            n = IIOPOutputStream.min(Chunk.CHUNK_SIZE - this.chunkPos, n2 - i);
            string.getBytes(i, i + n, this.current.buf, this.chunkPos);
            this.chunkPos += n;
        }
    }

    private final int writeUTF8Char(char c) {
        if ((c & 0xFF80) == 0) {
            this.write_octet((byte)c);
            return 1;
        }
        if ((c & 0xF800) == 0) {
            this.write_octet((byte)(0xC0 | c >> 6 & 0x1F));
            this.write_octet((byte)(0x80 | c >> 0 & 0x3F));
            return 2;
        }
        this.write_octet((byte)(0xE0 | c >> 12 & 0xF));
        this.write_octet((byte)(0x80 | c >> 6 & 0x3F));
        this.write_octet((byte)(0x80 | c >> 0 & 0x3F));
        return 3;
    }

    protected void write_UTF8wchar(char c) {
        this.align(1);
        if (this.getMinorVersion() >= 2) {
            if ((c & 0xFF80) == 0) {
                this.write_octet((byte)1);
            } else if ((c & 0xF800) == 0) {
                this.write_octet((byte)2);
            } else {
                this.write_octet((byte)3);
            }
        }
        this.writeUTF8Char(c);
    }

    public void write_wstring(String string) {
        if (string == null) {
            throw new MARSHAL("null value passes to write_wstring(String)");
        }
        java.lang.Object var2_2 = null;
        if (this.getMinorVersion() < 2) {
            GIOP10Helper.write_wstring(string, this, this.getWcharCodeSet(), this.littleEndian);
            return;
        }
        switch (this.getWcharCodeSet()) {
            case 0x5010001: {
                this.writeUTF8(string);
                break;
            }
            case 65792: {
                this.writeStringUTF16(string, false);
                break;
            }
            case 65801: {
                this.writeStringUTF16(string, true);
                break;
            }
            default: {
                throw new CODESET_INCOMPATIBLE();
            }
        }
    }

    public final void writeChunks(Chunk chunk) {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        Chunk chunk2 = chunk;
        int n = 0;
        while (chunk.next != null) {
            n += chunk.end;
            chunk = chunk.next;
        }
        this.write_long(n += chunk.end);
        this.current.next = chunk2;
        this.chunkPos = chunk.end;
        this.current = chunk;
        this.currentPos = this.currentPos + n - this.chunkPos;
    }

    public void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            throw new MARSHAL("null value passes to write_boolean_array");
        }
        for (int i = n; i < n2; ++i) {
            this.write_boolean(blArray[i]);
        }
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new MARSHAL("null value passes to write_char_array");
        }
        for (int i = n; i < n2; ++i) {
            this.write_char(cArray[i]);
        }
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new MARSHAL("null value passes to write_wchar_array");
        }
        for (int i = n; i < n2; ++i) {
            this.write_wchar(cArray[i]);
        }
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new MARSHAL("null array as parameter to write_octet_array");
        }
        if (this.needEightByteAlignment) {
            this.checkEightByteAlignment();
        }
        if (this.chunking && this.currentChunk == 0) {
            this.startChunk();
        }
        while (n2 > 0) {
            this.advance();
            int n3 = IIOPOutputStream.min(Chunk.CHUNK_SIZE - this.chunkPos, n2);
            System.arraycopy(byArray, n, this.current.buf, this.chunkPos, n3);
            n += n3;
            n2 -= n3;
            this.chunkPos += n3;
        }
    }

    public void write_short_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new MARSHAL("null value passes to write_short_array");
        }
        for (int i = n; i < n2; ++i) {
            this.write_short(sArray[i]);
        }
    }

    public void write_ushort_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new MARSHAL("null value passes to write_ushort_array");
        }
        for (int i = n; i < n2; ++i) {
            this.write_ushort(sArray[i]);
        }
    }

    public void write_long_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new MARSHAL("null value passes to write_long_array");
        }
        for (int i = n; i < n2; ++i) {
            this.write_long(nArray[i]);
        }
    }

    public void write_ulong_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new MARSHAL("null value passes to write_ulong_array");
        }
        for (int i = n; i < n2; ++i) {
            this.write_ulong(nArray[i]);
        }
    }

    public void write_longlong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new MARSHAL("null value passes to write_longlong_array");
        }
        for (int i = n; i < n2; ++i) {
            this.write_longlong(lArray[i]);
        }
    }

    public void write_ulonglong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new MARSHAL("null value passes to write_ulonglong_array");
        }
        for (int i = n; i < n2; ++i) {
            this.write_ulonglong(lArray[i]);
        }
    }

    public void write_float_array(float[] fArray, int n, int n2) {
        if (fArray == null) {
            throw new MARSHAL("null value passes to write_float_array");
        }
        for (int i = n; i < n2; ++i) {
            this.write_float(fArray[i]);
        }
    }

    public void write_double_array(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new MARSHAL("null value passes to write_double_array");
        }
        for (int i = n; i < n2; ++i) {
            this.write_double(dArray[i]);
        }
    }

    public void write_Object(Object object) {
        this.writeRemote(object);
    }

    private static IndirectionValueHashtable getHashMap() {
        IndirectionValueHashtable indirectionValueHashtable = (IndirectionValueHashtable)mapPool.remove();
        if (indirectionValueHashtable == null) {
            indirectionValueHashtable = new IndirectionValueHashtable();
        }
        return indirectionValueHashtable;
    }

    private static void releaseHashMap(IndirectionValueHashtable indirectionValueHashtable) {
        if (indirectionValueHashtable != null) {
            indirectionValueHashtable.clear();
            mapPool.add((java.lang.Object)indirectionValueHashtable);
        }
    }

    public void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            this.write_long(0);
            return;
        }
        if (this.tcNestingLevel == 0 && this.tcIndirections != null) {
            this.tcIndirections.clear();
        }
        if (typeCode.kind().value() > 13) {
            int n;
            if (this.tcIndirections == null) {
                this.tcIndirections = IIOPOutputStream.getHashMap();
            }
            if ((n = this.tcIndirections.get(typeCode, 0)) >= 0) {
                this.write_ulong(-1);
                this.write_ulong(n - this.pos());
                return;
            }
            this.align(4);
            this.tcIndirections.put(typeCode, 0, this.pos(), n);
        }
        ++this.tcNestingLevel;
        TypeCodeImpl.write(typeCode, this);
        --this.tcNestingLevel;
    }

    void writeAny(java.lang.Object object) {
        try {
            object = IIOPReplacer.getIIOPReplacer().replaceObject(object);
        }
        catch (IOException iOException) {
            throw new MARSHAL("IOException writing Any " + iOException.getMessage());
        }
        if (object == null && this.useCompliantChunking()) {
            this.write_TypeCode(TypeCodeImpl.NULL);
            this.write_boolean(false);
            this.write_long(0);
        } else if (object instanceof String) {
            String string = (String)object;
            this.write_TypeCode(TypeCodeImpl.STRING);
            this.write_value((Serializable)((java.lang.Object)string));
        } else if (object instanceof IOR) {
            this.write_TypeCode(TypeCodeImpl.OBJECT);
            ((IOR)object).write(this);
        } else {
            this.write_TypeCode(new TypeCodeImpl(29, this.findRepositoryIdForValue((Serializable)object), "", TypeCodeImpl.NULL_TC));
            this.write_value((Serializable)object);
        }
    }

    public final void write_any(Any any) {
        if (any == null) {
            this.write_TypeCode(null);
        } else {
            this.write_TypeCode(any.type());
            any.write_value((org.omg.CORBA.portable.OutputStream)this);
        }
    }

    public final void write_any(Any any, TypeCode typeCode) {
        any.write_value((org.omg.CORBA.portable.OutputStream)this);
    }

    public void write_Principal(Principal principal) {
        throw new NO_IMPLEMENT("write_Principal not implemented");
    }

    public void write(int n) throws IOException {
        this.write_octet((byte)(n & 0xFF));
    }

    public void write_fixed(BigDecimal bigDecimal) {
        throw new NO_IMPLEMENT("write_fixed() not implemented");
    }

    public void write_Context(Context context, ContextList contextList) {
        throw new NO_IMPLEMENT("write_Context() not implemented");
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public Message getMessage() {
        return this.message;
    }

    String getRepositoryID(java.lang.Object object) {
        if (object == null) {
            return null;
        }
        return valueHandler.getRMIRepositoryID(object.getClass());
    }

    private final boolean writeIndirectionMaybe(Serializable serializable) {
        int n = this.indirections.get(serializable, this.nestingLevel);
        if (n > 0) {
            this.write_long(-1);
            this.write_long(n - this.pos());
            return true;
        }
        this.align(4);
        this.indirections.put(serializable, this.nestingLevel, this.pos(), n);
        return false;
    }

    private void terminateChunk(int n) {
        int n2 = n - this.currentChunk - 4;
        Debug.assertion((this.currentChunk > 0 ? 1 : 0) != 0);
        if (this.currentChunkChunk != null) {
            this.currentChunkChunk.buf[this.currentChunkPos++] = (byte)(n2 >>> 24);
            this.currentChunkChunk.buf[this.currentChunkPos++] = (byte)(n2 >>> 16);
            this.currentChunkChunk.buf[this.currentChunkPos++] = (byte)(n2 >>> 8);
            this.currentChunkChunk.buf[this.currentChunkPos++] = (byte)n2;
            this.currentChunkChunk = null;
            this.currentChunkPos = 0;
        } else {
            this.setPosition(this.currentChunk);
            this.write_slow_long(n2);
            this.setPosition(n);
        }
        this.currentChunk = 0;
    }

    private void startChunk() {
        this.chunking = false;
        this.align(4);
        this.currentChunk = this.pos();
        if (this.chunkPos + 4 <= Chunk.CHUNK_SIZE && !this.littleEndian) {
            this.currentChunkPos = this.chunkPos;
            this.currentChunkChunk = this.current;
            this.chunkPos += 4;
        } else {
            this.write_slow_long(0);
        }
        this.chunking = true;
    }

    private void endChunk() {
        int n = this.pos();
        this.chunking = false;
        if (this.lastEnd != n) {
            if (this.currentChunk > 0) {
                this.terminateChunk(n);
            }
        } else {
            this.setPosition(this.lastEnd - 4);
            this.currentChunk = 0;
            this.currentChunkChunk = null;
        }
        this.write_long(this.endTag);
        if (this.useCompliantChunking()) {
            ++this.endTag;
        }
        if (this.endTag > 0) {
            throw new AssertionError("Chunking error at " + this.pos() + ": end tags must not be +ve: " + this.endTag);
        }
        this.lastEnd = this.endTag == 0 ? 0 : this.pos();
    }

    public void start_value(String string) {
        Debug.assertion((string != null ? 1 : 0) != 0);
        this.chunking = false;
        if (this.currentChunk != 0) {
            this.terminateChunk(this.pos());
        }
        this.write_long(2147483402);
        RepositoryId repositoryId = ClassInfo.getRepositoryId(string);
        if (!this.writeIndirectionMaybe(repositoryId)) {
            this.write_repository_id(repositoryId);
        }
        this.chunking = true;
        --this.endTag;
    }

    public void end_value() {
        if (this.chunking) {
            this.endChunk();
        }
        this.chunking = true;
    }

    public void write_value(Serializable serializable) {
        java.lang.Object object;
        ClassInfo classInfo;
        int n;
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.indirections == null) {
            this.indirections = IIOPOutputStream.getHashMap();
        }
        if ((n = this.indirections.get(serializable, this.nestingLevel)) > 0) {
            this.write_long(-1);
            this.write_long(n - this.pos());
            return;
        }
        Class<java.lang.Object> clazz = serializable.getClass();
        if (Proxy.class.isAssignableFrom(clazz)) {
            serializable = new ProxyDesc((Proxy)serializable);
            clazz = ProxyDesc.class;
        }
        if ((classInfo = ClassInfo.findClassInfo(clazz)).isPortableReplaceable()) {
            try {
                serializable = EJBPortableReplacer.getReplacer().replaceObject(serializable);
                clazz = serializable.getClass();
                classInfo = ClassInfo.findClassInfo(clazz);
            }
            catch (IOException iOException) {
                throw new MARSHAL("IOException writing PortableReplaceable " + iOException.getMessage());
            }
        }
        Serializable serializable2 = serializable;
        if ((serializable = classInfo.writeReplace(serializable)).getClass() != clazz) {
            clazz = serializable.getClass();
            classInfo = ClassInfo.findClassInfo(clazz);
        }
        boolean bl = this.chunking;
        boolean bl2 = this.chunking || classInfo.getDescriptor().isCustomMarshaled();
        this.chunking = false;
        if (bl && this.currentChunk != 0) {
            this.terminateChunk(this.pos());
        }
        int n2 = bl2 ? 2147483402 : 2147483394;
        RepositoryId[] repositoryIdArray = classInfo.getRepositoryIdList();
        if (repositoryIdArray != null) {
            n2 |= 6;
        }
        boolean bl3 = false;
        String string = null;
        if (bl3 && (object = Utils.getAnnotation(classInfo.forClass().getClassLoader())) != null) {
            string = Codebase.getDefaultCodebase() + (String)object + '/';
            n2 |= 1;
        }
        this.write_long(n2);
        this.indirections.put(serializable, this.nestingLevel, this.pos() - 4, n);
        if (string != null && !this.writeIndirectionMaybe((Serializable)((java.lang.Object)string))) {
            this.write_string(string);
        }
        object = classInfo.getRepositoryId();
        if (repositoryIdArray != null) {
            this.writeRepositoryIdList(repositoryIdArray);
        } else {
            if (classInfo.isValueBase()) {
                object = new RepositoryId(((ValueBase)serializable)._truncatable_ids()[0]);
            }
            if (object == null || ((MarshaledString)object).length() == 0 || !this.writeIndirectionMaybe((Serializable)object)) {
                this.write_repository_id((RepositoryId)object);
            }
        }
        this.chunking = bl2;
        if (bl2 || !this.useCompliantChunking()) {
            --this.endTag;
        }
        if (classInfo.isString()) {
            this.write_wstring((String)((java.lang.Object)serializable));
        } else if (((RepositoryId)object).isClassDesc()) {
            this.write_value((Serializable)((java.lang.Object)""));
            this.write_value((Serializable)((java.lang.Object)ClassInfo.findClassInfo((Class)serializable).getRepositoryId().toString()));
        } else if (classInfo.isIDLEntity() && !Object.class.isAssignableFrom(clazz)) {
            this.write_IDLValue(serializable, clazz);
        } else if (classInfo.isStreamable()) {
            ((Streamable)serializable)._write((org.omg.CORBA.portable.OutputStream)this);
        } else if (!this.useJavaSerialization) {
            try {
                ValueHandlerImpl.writeValue(this, serializable, this.maxFormatVersion, classInfo);
            }
            catch (IOException iOException) {
                throw (MARSHAL)new MARSHAL(iOException.getMessage()).initCause((Throwable)iOException);
            }
        } else {
            valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this, serializable);
        }
        if (this.chunking) {
            this.endChunk();
        }
        if (!this.useCompliantChunking()) {
            ++this.endTag;
        }
        this.chunking = bl;
    }

    public void write_value(Serializable serializable, Class clazz) {
        if (clazz.equals(AuthenticatedUser.class) && AuthenticatedSubject.class.isInstance(serializable) && (serializable = SecurityServiceManager.convertToAuthenticatedUser((AuthenticatedUser)((AuthenticatedUser)serializable))) == null) {
            this.write_long(0);
            return;
        }
        this.write_value(serializable);
    }

    public void write_value(Serializable serializable, String string) {
        this.write_value(serializable);
    }

    public RepositoryId findRepositoryIdForValue(Serializable serializable) {
        Class<?> clazz = serializable.getClass();
        ClassInfo classInfo = ClassInfo.findClassInfo(clazz);
        if (classInfo.isPortableReplaceable()) {
            try {
                serializable = EJBPortableReplacer.getReplacer().replaceObject(serializable);
                clazz = serializable.getClass();
                classInfo = ClassInfo.findClassInfo(clazz);
            }
            catch (IOException iOException) {
                throw new MARSHAL("IOException writing value " + iOException.getMessage());
            }
        }
        if ((serializable = classInfo.writeReplace(serializable)).getClass() != clazz) {
            clazz = serializable.getClass();
            classInfo = ClassInfo.findClassInfo(clazz);
        }
        if (classInfo.isValueBase()) {
            return new RepositoryId(((ValueBase)serializable)._truncatable_ids()[0]);
        }
        return classInfo.getRepositoryId();
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        this.write_value(serializable);
    }

    public void write_abstract_interface(java.lang.Object object) {
        if ((object instanceof Remote || object instanceof Object || object instanceof InvokeHandler || object instanceof IOR) && !(object instanceof Proxy)) {
            this.write_boolean(true);
            this.writeRemote(object);
        } else {
            this.write_boolean(false);
            this.write_value((Serializable)object);
        }
    }

    private final void write_IDLValue(Serializable serializable, Class clazz) {
        try {
            if (serializable instanceof StreamableValue) {
                ((StreamableValue)serializable)._write((org.omg.CORBA.portable.OutputStream)this);
            } else {
                if (serializable instanceof CustomValue) {
                    throw new MARSHAL("Custom marshalled valuetypes not supported");
                }
                if (serializable instanceof ValueBase) {
                    BoxedValueHelper boxedValueHelper = (BoxedValueHelper)Utils.getHelper(clazz, "Helper").newInstance();
                    boxedValueHelper.write_value((org.omg.CORBA.portable.OutputStream)this, serializable);
                } else {
                    this.write_IDLEntity(serializable, clazz);
                }
            }
        }
        catch (InstantiationException instantiationException) {
            throw new MARSHAL(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MARSHAL(illegalAccessException.getMessage());
        }
    }

    final void write_IDLEntity(java.lang.Object object, Class clazz) {
        IIOPOutputStream.write_IDLEntity((org.omg.CORBA.portable.OutputStream)this, object, clazz);
    }

    public static final void write_IDLEntity(org.omg.CORBA.portable.OutputStream outputStream, java.lang.Object object, Class clazz) {
        Debug.assertion((boolean)IDLEntity.class.isAssignableFrom(clazz));
        Method method = Utils.getIDLWriter(clazz);
        if (method == null) {
            throw new MARSHAL("Couldn't find helper for " + clazz.getName());
        }
        IIOPOutputStream.writeWithHelper(outputStream, object, method);
    }

    public static final void writeWithHelper(org.omg.CORBA.portable.OutputStream outputStream, java.lang.Object object, Method method) {
        try {
            method.invoke(null, outputStream, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MARSHAL(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            MARSHAL mARSHAL = new MARSHAL(invocationTargetException.getTargetException().getMessage());
            mARSHAL.initCause(invocationTargetException.getTargetException());
            throw mARSHAL;
        }
    }

    public void writeRemote(java.lang.Object object) {
        if (object == null) {
            IOR.NULL.write(this);
            return;
        }
        IOR iOR = null;
        try {
            iOR = IIOPReplacer.getIIOPReplacer().replaceRemote(object);
        }
        catch (IOException iOException) {
            IIOPLogger.logFailedToExport((String)object.getClass().getName(), (IOException)iOException);
            throw new MARSHAL("Couldn't export " + object.getClass().getName(), 0, CompletionStatus.COMPLETED_MAYBE);
        }
        iOR.write(this);
    }

    public void write_octet_sequence(byte[] byArray) {
        if (byArray == null) {
            this.write_long(0);
        } else {
            this.write_long(byArray.length);
            this.write_octet_array(byArray, 0, byArray.length);
        }
    }

    public final void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new MARSHAL("null array as parameter to readFully");
        }
        this.write(byArray, 0, byArray.length);
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        this.write_octet_array(byArray, n, n2);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write_boolean(bl);
    }

    public final void writeByte(int n) throws IOException {
        this.write_octet((byte)(n & 0xFF));
    }

    public final void writeShort(int n) throws IOException {
        this.write_short((short)(n & 0xFFFF));
    }

    public final void writeChar(int n) throws IOException {
        this.write_wchar((char)(n & 0xFFFF));
    }

    public final void writeInt(int n) throws IOException {
        this.write_long(n);
    }

    public final void writeLong(long l) throws IOException {
        this.write_longlong(l);
    }

    public final void writeFloat(float f) throws IOException {
        this.write_float(f);
    }

    public final void writeDouble(double d) throws IOException {
        this.write_double(d);
    }

    public final void writeBytes(String string) throws IOException {
        this.writeASCII(string);
    }

    public final void writeChars(String string) throws IOException {
        char[] cArray = string.toCharArray();
        this.write_wchar_array(cArray, 0, cArray.length);
    }

    public final void writeUTF(String string) throws IOException {
        this.write_wstring(string);
    }

    public final void writeObject(java.lang.Object object) throws IOException {
        this.write_abstract_interface(object);
    }

    public final void writeObject(java.lang.Object object, Class clazz) throws IOException {
        try {
            if (Remote.class.isAssignableFrom(clazz) || InvokeHandler.class.isAssignableFrom(clazz) || Object.class.isAssignableFrom(clazz)) {
                this.writeRemote(object);
            } else if (clazz.equals(java.lang.Object.class) || clazz.equals(Serializable.class) || clazz.equals(Externalizable.class)) {
                this.writeAny(object);
            } else if (Utils.isIDLException(clazz)) {
                this.write_IDLEntity(object, clazz);
            } else if (Utils.isAbstractInterface(clazz)) {
                this.write_abstract_interface(object);
            } else {
                object = RemoteObjectReplacer.getReplacer().replaceObject(object);
                if (this.useJavaSerialization) {
                    try {
                        this.write_value((Serializable)new MarshalledObject(object), MarshalledObject.class);
                    }
                    catch (NotSerializableException notSerializableException) {
                        this.write_value((Serializable)object, clazz);
                    }
                } else {
                    if (USE_JAVA_SERIALIZATION_FOR_JMX && MBeanInfo.class.isAssignableFrom(clazz)) {
                        object = new MarshalledObject(object);
                        clazz = MarshalledObject.class;
                    }
                    this.write_value((Serializable)object, clazz);
                }
            }
        }
        catch (SystemException systemException) {
            throw Utils.mapSystemException(systemException);
        }
    }

    public final void flush() {
        this.current.end = this.chunkPos;
    }

    void p(String string) {
        System.err.println("<IIOPOutputStream>: " + string);
    }

    final boolean isWritingObjectKey() {
        return this.writingObjectKey;
    }

    final void setWritingObjectKey(boolean bl) {
        this.writingObjectKey = bl;
    }

    boolean getLittleEndian() {
        return this.littleEndian;
    }

    static {
        String string = System.getProperty("weblogic.iiop.useJavaSerializationForJMX", "true");
        USE_JAVA_SERIALIZATION_FOR_JMX = Boolean.valueOf(string);
        IIOPService.load();
        valueHandler = Util.createValueHandler();
        mapPool = new StackPool(1024);
    }

    static class Marker {
        Chunk chunk;
        int pos;
        int currentPos;

        Marker() {
        }
    }
}

