/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.ConnectIOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import org.omg.CORBA.Object;
import weblogic.corba.cos.transactions.OTSHelper;
import weblogic.corba.utils.RemoteInfo;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointManager;
import weblogic.iiop.HostIDImpl;
import weblogic.iiop.IIOPClientService;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IOPProfile;
import weblogic.iiop.IOR;
import weblogic.iiop.InboundResponseImpl;
import weblogic.iiop.LocateReplyMessage;
import weblogic.iiop.LocateRequestMessage;
import weblogic.iiop.Message;
import weblogic.iiop.ObjectKey;
import weblogic.iiop.OutboundRequestImpl;
import weblogic.iiop.RequestMessage;
import weblogic.iiop.SequencedRequestMessage;
import weblogic.iiop.Utils;
import weblogic.iiop.spi.IORDelegate;
import weblogic.kernel.Kernel;
import weblogic.rmi.extensions.server.ActivatableRemoteReference;
import weblogic.rmi.extensions.server.ForwardReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InboundResponse;
import weblogic.rmi.spi.OutboundRequest;
import weblogic.trace.Trace;
import weblogic.transaction.ServerTransactionInterceptor;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class IIOPRemoteRef
implements ActivatableRemoteReference,
ForwardReference,
Externalizable,
IORDelegate {
    static final long serialVersionUID = 7205760308016316442L;
    public static final int LOCATION_RETRIES = 5;
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private static final DebugLogger debugIIOPTransport = DebugLogger.getDebugLogger((String)"DebugIIOPTransport");
    private static final boolean tracingEnabled = Kernel.isTracingEnabled();
    private IOR ior;
    private transient IOR locatedIOR;
    private transient boolean rmiType = true;
    private HostID hostID = null;
    private transient boolean timedOut;
    private transient long timeStamp;

    public IIOPRemoteRef(IOR iOR) {
        this(iOR, null);
    }

    public IIOPRemoteRef(IOR iOR, RemoteInfo remoteInfo) {
        this.ior = iOR;
        if (remoteInfo != null && remoteInfo.isIDLInterface() || iOR.getTypeId().isIDLType()) {
            this.rmiType = false;
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            IIOPRemoteRef.p("typeid: " + iOR.getTypeId() + ", interface: " + (remoteInfo == null ? "<null>" : remoteInfo.getClassName()) + " is " + (this.rmiType ? "" : "not ") + "RMI-style");
        }
        iOR.getProfile();
    }

    private OutboundRequestImpl getOutboundRequestInternal(RuntimeMethodDescriptor runtimeMethodDescriptor) throws IOException {
        try {
            boolean bl = this.rmiType;
            String string = runtimeMethodDescriptor.getMangledName();
            if (bl && Object.class.isAssignableFrom(runtimeMethodDescriptor.getDeclaringClass())) {
                bl = false;
            }
            if (this.locatedIOR == null) {
                this.locateRequest(this.ior);
            }
            EndPoint endPoint = EndPointManager.findOrCreateEndPoint(this.locatedIOR);
            OutboundRequestImpl outboundRequestImpl = new OutboundRequestImpl(endPoint, new RequestMessage(endPoint, this.locatedIOR, string, runtimeMethodDescriptor.isOneway()), bl, runtimeMethodDescriptor);
            return outboundRequestImpl;
        }
        catch (IOException iOException) {
            if (this.rmiType) {
                throw Utils.mapToRemoteException(iOException);
            }
            throw Utils.mapToCORBAException(iOException);
        }
    }

    public OutboundRequest getOutboundRequest(RuntimeMethodDescriptor runtimeMethodDescriptor) throws IOException {
        OutboundRequestImpl outboundRequestImpl = this.getOutboundRequestInternal(runtimeMethodDescriptor);
        this.associateTxContext(outboundRequestImpl);
        if (tracingEnabled) {
            outboundRequestImpl.setContext(4, Trace.currentTrace());
        }
        outboundRequestImpl.transferThreadLocalContext();
        return outboundRequestImpl;
    }

    public java.lang.Object invoke(Remote remote, RuntimeMethodDescriptor runtimeMethodDescriptor, java.lang.Object[] objectArray, Method method) throws Throwable {
        try {
            if (this.locatedIOR == null) {
                this.locateRequest(this.ior);
            }
            for (int i = 0; i < 5; ++i) {
                try {
                    return this.invokeInternal(remote, runtimeMethodDescriptor, objectArray);
                }
                catch (LocationForwardException locationForwardException) {
                    continue;
                }
            }
        }
        catch (IOException iOException) {
            if (this.rmiType) {
                throw Utils.mapToRemoteException(iOException);
            }
            throw Utils.mapToCORBAException(iOException);
        }
        ConnectIOException connectIOException = new ConnectIOException("Too many forwards");
        if (this.rmiType) {
            throw Utils.mapToRemoteException(connectIOException);
        }
        throw Utils.mapToCORBAException(connectIOException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.lang.Object invokeInternal(Remote remote, RuntimeMethodDescriptor runtimeMethodDescriptor, java.lang.Object[] objectArray) throws Throwable {
        OutboundRequestImpl outboundRequestImpl = this.getOutboundRequestInternal(runtimeMethodDescriptor);
        if (runtimeMethodDescriptor.isTransactional()) {
            this.associateTxContext(outboundRequestImpl);
        }
        if (tracingEnabled) {
            outboundRequestImpl.setContext(4, Trace.currentTrace());
        }
        outboundRequestImpl.transferThreadLocalContext();
        InboundResponse inboundResponse = null;
        try {
            outboundRequestImpl.marshalArgs(objectArray);
            if (runtimeMethodDescriptor.isOneway()) {
                outboundRequestImpl.sendOneWay();
                java.lang.Object var6_6 = null;
                return var6_6;
            }
            inboundResponse = outboundRequestImpl.sendReceive();
            IOR iOR = null;
            if (inboundResponse instanceof InboundResponseImpl && (iOR = ((InboundResponseImpl)inboundResponse).needsForwarding()) != null) {
                this.redirect(iOR);
                throw new LocationForwardException();
            }
            java.lang.Object object = inboundResponse.unmarshalReturn();
            return object;
        }
        finally {
            try {
                if (inboundResponse != null) {
                    inboundResponse.close();
                }
                if (outboundRequestImpl != null) {
                    outboundRequestImpl.close();
                }
            }
            catch (IOException iOException) {
                throw new UnmarshalException("failed to close response stream", iOException);
            }
        }
    }

    private void associateTxContext(OutboundRequest outboundRequest) throws RemoteException {
        if (Kernel.isServer()) {
            OTSHelper.forceLocalCoordinator();
        }
        TransactionManager transactionManager = (TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager();
        ServerTransactionInterceptor serverTransactionInterceptor = (ServerTransactionInterceptor)transactionManager.getInterceptor();
        outboundRequest.setTxContext(serverTransactionInterceptor.sendRequest((java.lang.Object)outboundRequest.getEndPoint()));
    }

    public int getObjectID() {
        ObjectKey objectKey = this.ior.getProfile().getObjectKey();
        if (objectKey.isWLSKey()) {
            return objectKey.getObjectID();
        }
        return -1;
    }

    public java.lang.Object getActivationID() {
        return this.ior.getProfile().getObjectKey().getActivationID();
    }

    public String getCodebase() {
        String string = this.ior.getCodebase();
        return string == null ? "" : string;
    }

    public synchronized void setRequestTimedOut(boolean bl) {
        if (Kernel.getConfig().getTimedOutRefIsolationTime() <= 0L) {
            return;
        }
        this.timedOut = bl;
        this.timeStamp = System.currentTimeMillis();
    }

    public synchronized boolean hasRequestTimedOut() {
        if (!this.timedOut) {
            return false;
        }
        if (System.currentTimeMillis() - this.timeStamp > Kernel.getConfig().getTimedOutRefIsolationTime()) {
            this.setRequestTimedOut(false);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostID getHostID() {
        if (this.hostID == null) {
            IIOPRemoteRef iIOPRemoteRef = this;
            synchronized (iIOPRemoteRef) {
                if (this.hostID == null) {
                    IOPProfile iOPProfile = this.ior.getProfile();
                    this.hostID = !iOPProfile.getObjectKey().isWLSKey() || iOPProfile.getObjectKey().getTarget() == null ? new HostIDImpl(iOPProfile.getHost(), iOPProfile.getPort()) : iOPProfile.getObjectKey().getTarget();
                }
            }
        }
        return this.hostID;
    }

    public Channel getChannel() {
        return (Channel)this.getHostID();
    }

    public final IOR getIOR() {
        return this.ior;
    }

    public final int hashCode() {
        return this.ior.hashCode();
    }

    public final boolean equals(java.lang.Object object) {
        if (object instanceof IIOPRemoteRef) {
            return this.ior.equals(((IIOPRemoteRef)object).getIOR());
        }
        return false;
    }

    public IIOPRemoteRef() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.ior);
    }

    public final void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ior = (IOR)objectInput.readObject();
    }

    protected synchronized void locateRequest(IOR iOR) throws IOException {
        if (this.locatedIOR != null) {
            return;
        }
        this.locatedIOR = IIOPRemoteRef.locateIORForRequest(iOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOR locateIORForRequest(IOR iOR) throws IOException {
        IOR iOR2 = iOR;
        EndPoint endPoint = EndPointManager.findOrCreateEndPoint(iOR);
        if (IIOPClientService.useLocateRequest && endPoint.supportsForwarding()) {
            Message message = null;
            Message message2 = null;
            try {
                iOR.getProfile();
                message = new LocateRequestMessage(endPoint, iOR);
                if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                    IIOPLogger.logDebugTransport((String)("LOCATE_REQUEST(" + message.getRequestID() + ")"));
                }
                if ((iOR2 = ((LocateReplyMessage)(message2 = endPoint.sendReceive((SequencedRequestMessage)message))).needsForwarding()) == null) {
                    iOR2 = iOR;
                }
            }
            finally {
                if (message != null) {
                    message.getOutputStream().close();
                }
                if (message2 != null) {
                    message2.getInputStream().close();
                }
            }
        }
        return iOR2;
    }

    protected synchronized void redirect(IOR iOR) throws IOException {
        this.locatedIOR = iOR;
    }

    static void p(String string) {
        System.err.println("<IIOPRemoteRef> " + string);
    }

    public void handleRedirect(InboundResponse inboundResponse) throws Exception {
        IOR iOR = null;
        if (inboundResponse instanceof InboundResponseImpl && (iOR = ((InboundResponseImpl)inboundResponse).needsForwarding()) != null) {
            this.redirect(iOR);
            throw new weblogic.rmi.extensions.server.LocationForwardException();
        }
    }

    private final class LocationForwardException
    extends Exception {
        private static final long serialVersionUID = 6831758778588685685L;

        LocationForwardException() {
        }

        LocationForwardException(String string) {
            super(string);
        }
    }
}

