/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.corba.cos.naming.RootNamingContextImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.ClusterServices;
import weblogic.iiop.IIOPClientService;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IORManager;
import weblogic.iiop.InitialReferences;
import weblogic.iiop.MuxableSocketIIOP;
import weblogic.jndi.Environment;
import weblogic.kernel.Kernel;
import weblogic.security.acl.internal.SecurityServiceImpl;
import weblogic.server.ServerService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class IIOPService
implements ServerService {
    private static final String FALSE_PROP = "false";
    public static final int TX_DISABLED_MECHANISM = 0;
    public static final int TX_OTS_MECHANISM = 1;
    public static final int TX_JTA_MECHANISM = 2;
    public static final int TX_OTS11_MECHANISM = 3;
    public static int txMechanism = 1;
    private static final DebugCategory debugStartup = Debug.getCategory((String)"weblogic.iiop.startup");
    private static final DebugLogger debugIIOPStartup = DebugLogger.getDebugLogger((String)"DebugIIOPStartup");
    private static volatile boolean enabled = false;

    public static boolean load() {
        return IIOPClientService.load();
    }

    public static void setTGIOPEnabled(boolean bl) {
        enabled = bl;
    }

    public static boolean isTGIOPEnabled() {
        return enabled;
    }

    public void stop() throws ServiceFailureException {
        this.halt();
    }

    public void halt() throws ServiceFailureException {
        MuxableSocketIIOP.disable();
    }

    public String getName() {
        return "CorbaService";
    }

    public String getVersion() {
        return "CORBA 2.3, IIOP 1.2, RMI-IIOP SFV2, OTS 1.2, CSIv2 Level 0 + Stateful";
    }

    public void start() throws ServiceFailureException {
        block20: {
            Object object;
            boolean bl;
            block19: {
                if (FALSE_PROP.equals(System.getProperty("weblogic.system.iiop.enableTxInterop"))) {
                    txMechanism = 0;
                }
                bl = debugStartup.isEnabled() || debugIIOPStartup.isDebugEnabled();
                try {
                    InitialReferences.initializeServerInitialReferences();
                }
                catch (RemoteException remoteException) {
                    throw new ServiceFailureException((Throwable)remoteException);
                }
                catch (IOException iOException) {
                    throw new ServiceFailureException((Throwable)iOException);
                }
                IORManager.initialize();
                if (txMechanism > 0) {
                    object = Kernel.getConfig().getIIOP().getTxMechanism();
                    if (((String)object).equalsIgnoreCase("JTA")) {
                        txMechanism = 2;
                    } else if (((String)object).equalsIgnoreCase("OTSv11")) {
                        txMechanism = 3;
                    } else if (((String)object).equalsIgnoreCase("none")) {
                        txMechanism = 0;
                    }
                    if (bl) {
                        IIOPLogger.logJTAEnabled((String)object);
                    }
                } else if (bl) {
                    IIOPLogger.logJTAEnabled((String)"none");
                }
                ClusterServices.initialize();
                object = new Environment();
                ((Environment)object).setCreateIntermediateContexts(true);
                try {
                    ((Environment)object).getInitialContext().bind("weblogic.cosnaming.NameService", (Object)RootNamingContextImpl.getRootNamingContext());
                    if (bl) {
                        IIOPLogger.logCosNamingService((String)"weblogic.cosnaming.NameService");
                    }
                }
                catch (NamingException namingException) {
                    if (!bl) break block19;
                    IIOPLogger.logCosNamingServiceFailed((Exception)namingException);
                }
            }
            try {
                ((Environment)object).setReplicateBindings(false);
                Context context = ((Environment)object).getInitialContext();
                context.bind("weblogic/security/SecurityManager", (Object)SecurityServiceImpl.getSingleton());
                if (bl) {
                    IIOPLogger.logSecurityService((String)"weblogic/security/SecurityManager");
                }
            }
            catch (NamingException namingException) {
                if (!bl) break block20;
                IIOPLogger.logSecurityServiceFailed((Exception)namingException);
            }
        }
    }
}

