/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import weblogic.corba.cos.transactions.TransactionPolicyComponent;
import weblogic.corba.idl.poa.PolicyImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.ClusterComponent;
import weblogic.iiop.CodeSetsComponent;
import weblogic.iiop.CodebaseComponent;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.IIOPClientService;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.ObjectKey;
import weblogic.iiop.Profile;
import weblogic.iiop.SFVComponent;
import weblogic.iiop.SSLSecTransComponent;
import weblogic.iiop.TaggedComponent;
import weblogic.iiop.TargetAddress;
import weblogic.iiop.csi.CompoundSecMechList;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.collections.NumericKeyHashMap;

public final class IOPProfile
extends Profile {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    public static final int PORT_DISABLED = 0;
    private byte major;
    private byte minor;
    private String host;
    private InetAddress canonicalHost;
    private transient ConnectionKey address = null;
    private int port;
    private boolean readSecurely = false;
    private boolean clusterable = false;
    int securePort = -1;
    private ObjectKey key;
    private TargetAddress targetAddress;
    private TaggedComponent[] taggedComponents;
    private int ncomps;
    private static final int MAX_COMPONENTS = 16;

    public IOPProfile(String string, int n, ObjectKey objectKey) {
        this(string, n, objectKey, null);
    }

    public IOPProfile(String string, int n, ObjectKey objectKey, String string2) {
        this(string, n, objectKey, string2, 1, IIOPClientService.defaultGIOPMinorVersion, null, null);
    }

    IOPProfile(String string, int n, ObjectKey objectKey, String string2, byte by, byte by2, ClusterComponent clusterComponent, RuntimeDescriptor runtimeDescriptor) {
        this(string, n, objectKey, string2, by, by2, clusterComponent, runtimeDescriptor, null);
    }

    IOPProfile(String string, int n, ObjectKey objectKey, String string2, byte by, byte by2, ClusterComponent clusterComponent, RuntimeDescriptor runtimeDescriptor, NumericKeyHashMap numericKeyHashMap) {
        super(0);
        this.host = string;
        this.port = n;
        this.key = objectKey;
        this.targetAddress = new TargetAddress(objectKey);
        this.major = by;
        this.minor = by2;
        this.ncomps = 0;
        if (by >= 1 && by2 >= 1) {
            this.taggedComponents = new TaggedComponent[16];
            this.taggedComponents[this.ncomps++] = CodeSetsComponent.getDefault();
            if (IIOPClientService.useSerialFormatVersion2) {
                this.taggedComponents[this.ncomps++] = SFVComponent.VERSION_2;
            }
            if (Kernel.isServer() && objectKey.isWLSKey()) {
                this.taggedComponents[this.ncomps++] = new CodebaseComponent(objectKey.getTarget(), string2);
                if (runtimeDescriptor != null && runtimeDescriptor.getMethodsAreTransactional()) {
                    this.taggedComponents[this.ncomps++] = TransactionPolicyComponent.EJB_OTS_POLICY;
                } else if (numericKeyHashMap != null && numericKeyHashMap.get(55L) != null) {
                    this.taggedComponents[this.ncomps++] = TransactionPolicyComponent.getInvocationPolicy(((PolicyImpl)((Object)numericKeyHashMap.get(55L))).policy_value());
                }
                if (numericKeyHashMap == null) {
                    this.taggedComponents[this.ncomps++] = TransactionPolicyComponent.EJB_INV_POLICY;
                } else if (numericKeyHashMap.get(56L) != null) {
                    this.taggedComponents[this.ncomps++] = TransactionPolicyComponent.getOTSPolicy(((PolicyImpl)((Object)numericKeyHashMap.get(56L))).policy_value());
                }
                if (!KernelStatus.isServer() || SecurityServiceManager.isSecurityServiceInitialized()) {
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        IOPProfile.p("create compound secmechlist for IOR: " + string2);
                    }
                    this.taggedComponents[this.ncomps++] = new CompoundSecMechList(string, objectKey.getTarget(), runtimeDescriptor);
                }
                if (runtimeDescriptor != null && runtimeDescriptor.getIntegrity() != null && "required".equals(runtimeDescriptor.getIntegrity())) {
                    this.port = 0;
                }
                if (objectKey.isLocalKey()) {
                    this.securePort = SSLSecTransComponent.getSingleton().getPort();
                }
            }
            if (clusterComponent != null) {
                this.taggedComponents[this.ncomps++] = clusterComponent;
            }
        }
    }

    IOPProfile() {
        super(0);
    }

    IOPProfile(IOPProfile iOPProfile) {
        super(0);
        this.major = iOPProfile.major;
        this.minor = iOPProfile.minor;
        this.host = iOPProfile.host;
        this.port = iOPProfile.port;
        this.readSecurely = iOPProfile.readSecurely;
        this.securePort = iOPProfile.securePort;
        this.key = iOPProfile.key;
        this.targetAddress = iOPProfile.targetAddress;
        this.ncomps = iOPProfile.ncomps;
        this.taggedComponents = new TaggedComponent[iOPProfile.taggedComponents.length];
        for (int i = 0; i < this.taggedComponents.length; ++i) {
            this.taggedComponents[i] = iOPProfile.taggedComponents[i];
        }
    }

    void setClusterComponent(ClusterComponent clusterComponent) {
        int n = 0;
        for (int i = 0; i < this.ncomps; ++i) {
            if (this.taggedComponents[i] instanceof ClusterComponent) continue;
            this.taggedComponents[n++] = this.taggedComponents[i];
        }
        if (clusterComponent != null) {
            if (n + 1 >= this.taggedComponents.length) {
                TaggedComponent[] taggedComponentArray = new TaggedComponent[n + 1];
                System.arraycopy(this.taggedComponents, 0, taggedComponentArray, 0, n);
                this.taggedComponents = taggedComponentArray;
            }
            this.taggedComponents[n++] = clusterComponent;
        }
    }

    public final String getHost() {
        return this.host;
    }

    public final InetAddress getHostAddress() throws UnknownHostException {
        if (this.canonicalHost == null) {
            this.canonicalHost = InetAddress.getByName(this.host);
        }
        return this.canonicalHost;
    }

    final boolean isSecure() {
        return (this.readSecurely() || this.getPort() <= 0) && this.getSecurePort() > 0;
    }

    public final void makeSecure() {
        if (this.getSecurePort() > 0 && this.getPort() > 0) {
            this.port = 0;
        }
    }

    public final ConnectionKey getConnectionKey() {
        if (this.address == null) {
            try {
                if (this.isSecure()) {
                    String string = this.getSecureHost() == null ? this.getHost() : this.getSecureHost();
                    this.address = new ConnectionKey(InetAddress.getByName(string).getHostAddress(), this.getSecurePort());
                } else {
                    this.address = new ConnectionKey(this.getHostAddress().getHostAddress(), this.getPort());
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (this.isSecure()) {
                    String string = this.getSecureHost() == null ? this.getHost() : this.getSecureHost();
                    this.address = new ConnectionKey(string, this.getSecurePort());
                }
                this.address = new ConnectionKey(this.getHost(), this.getPort());
            }
        }
        return this.address;
    }

    public final int getPort() {
        return this.port;
    }

    public final int getSecurePort() {
        if (this.securePort < 0) {
            SSLSecTransComponent sSLSecTransComponent;
            TaggedComponent taggedComponent = this.getComponent(33);
            if (taggedComponent != null) {
                this.securePort = ((CompoundSecMechList)taggedComponent).getSecurePort();
            }
            if (this.securePort < 0 && (sSLSecTransComponent = (SSLSecTransComponent)this.getComponent(20)) != null) {
                this.securePort = sSLSecTransComponent.getPort();
            }
        }
        return this.securePort;
    }

    public final String getSecureHost() {
        TaggedComponent taggedComponent = this.getComponent(33);
        if (taggedComponent != null) {
            return ((CompoundSecMechList)taggedComponent).getSecureHost();
        }
        return null;
    }

    public final boolean readSecurely() {
        return this.readSecurely;
    }

    public final byte getMinorVersion() {
        return this.minor;
    }

    public final byte getMajorVersion() {
        return this.major;
    }

    public final ObjectKey getObjectKey() {
        return this.key;
    }

    public final boolean isTransactional() {
        TransactionPolicyComponent transactionPolicyComponent = (TransactionPolicyComponent)this.getComponent(31);
        return transactionPolicyComponent != null && transactionPolicyComponent.getPolicy() != 2;
    }

    public final boolean isClusterable() {
        if (!this.clusterable && this.getComponent(1111834883) != null) {
            this.clusterable = true;
        }
        return this.clusterable;
    }

    public final TaggedComponent getComponent(int n) {
        if (this.taggedComponents == null) {
            return null;
        }
        for (int i = 0; i < this.ncomps; ++i) {
            if (this.taggedComponents[i].tag != n) continue;
            return this.taggedComponents[i];
        }
        return null;
    }

    public final void removeComponent(int n) {
        TaggedComponent taggedComponent = this.getComponent(n);
        if (taggedComponent != null) {
            List<Object> list = Arrays.asList((Object[])this.taggedComponents);
            list.remove(taggedComponent);
            this.taggedComponents = list.toArray(this.taggedComponents);
            --this.ncomps;
        }
    }

    final TargetAddress getTargetAddress() {
        return this.targetAddress;
    }

    public final boolean useSAS() {
        TaggedComponent taggedComponent = this.getComponent(33);
        if (taggedComponent != null) {
            return ((CompoundSecMechList)taggedComponent).useSAS();
        }
        return false;
    }

    public final byte[] getGSSUPTarget() {
        TaggedComponent taggedComponent = this.getComponent(33);
        if (taggedComponent != null) {
            return ((CompoundSecMechList)taggedComponent).getGSSUPTarget();
        }
        return null;
    }

    public final boolean isGSSUPTargetStateful() {
        TaggedComponent taggedComponent = this.getComponent(33);
        if (taggedComponent != null) {
            return ((CompoundSecMechList)taggedComponent).isGSSUPTargetStateful();
        }
        return false;
    }

    public byte getMaxStreamFormatVersion() {
        SFVComponent sFVComponent = (SFVComponent)this.getComponent(38);
        if (sFVComponent != null) {
            return sFVComponent.getMaxFormatVersion();
        }
        return 1;
    }

    public void read(IIOPInputStream iIOPInputStream) {
        long l = iIOPInputStream.startEncapsulation();
        if (iIOPInputStream.isSecure()) {
            this.readSecurely = true;
        }
        this.major = iIOPInputStream.read_octet();
        this.minor = iIOPInputStream.read_octet();
        ConnectionKey connectionKey = new ConnectionKey(iIOPInputStream);
        this.key = new ObjectKey(iIOPInputStream);
        this.targetAddress = new TargetAddress(this.key);
        if (this.key.isLocalKey()) {
            connectionKey = connectionKey.readResolve(iIOPInputStream);
        }
        this.host = connectionKey.getAddress();
        this.port = connectionKey.getPort();
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            IOPProfile.p("read() preamble: " + this.major + "." + this.minor + " profile to " + this.host + ":" + this.port + " @" + iIOPInputStream.pos());
        }
        if (this.major >= 1 && this.minor >= 1) {
            this.ncomps = iIOPInputStream.read_long();
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                IOPProfile.p("read() " + this.ncomps + " components @" + iIOPInputStream.pos());
            }
            this.taggedComponents = new TaggedComponent[this.ncomps];
            for (int i = 0; i < this.ncomps; ++i) {
                this.taggedComponents[i] = TaggedComponent.readComponent(iIOPInputStream, this.key.getTarget());
                switch (this.taggedComponents[i].getTag()) {
                    case 1111834883: {
                        this.clusterable = true;
                    }
                }
            }
        }
        iIOPInputStream.endEncapsulation(l);
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            IOPProfile.p("read " + this);
        }
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_long(0);
        long l = iIOPOutputStream.startEncapsulation();
        iIOPOutputStream.write_octet(this.major);
        iIOPOutputStream.write_octet(this.minor);
        ConnectionKey connectionKey = new ConnectionKey(this.host, this.port);
        if (this.key.getTarget() != null) {
            connectionKey.writeForChannel(iIOPOutputStream, this.key.getTarget());
        } else {
            connectionKey.write(iIOPOutputStream);
        }
        this.key.write(iIOPOutputStream);
        if (this.major >= 1 && this.minor >= 1) {
            if (iIOPOutputStream.isSecure() && this.key.isLocalKey() && Kernel.isServer()) {
                iIOPOutputStream.write_long(this.ncomps + 1);
            } else {
                iIOPOutputStream.write_long(this.ncomps);
            }
            for (int i = 0; i < this.ncomps; ++i) {
                this.taggedComponents[i].write(iIOPOutputStream);
            }
            if (iIOPOutputStream.isSecure() && this.key.isLocalKey() && Kernel.isServer()) {
                SSLSecTransComponent.getSingleton().write(iIOPOutputStream);
            }
        }
        iIOPOutputStream.endEncapsulation(l);
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            IOPProfile.p("wrote " + this);
        }
    }

    public final int hashCode() {
        return this.port ^ this.host.hashCode() ^ this.key.hashCode();
    }

    public final boolean equals(Object object) {
        try {
            IOPProfile iOPProfile = (IOPProfile)object;
            if (this.key.isLocalKey() && !Kernel.isServer() && this.key.equals(iOPProfile.key)) {
                return true;
            }
            return this.port == iOPProfile.port && (this.host == iOPProfile.host || this.host.hashCode() == iOPProfile.host.hashCode() || this.host.equals(iOPProfile.host)) && (this.key == iOPProfile.key || this.key.equals(iOPProfile.key));
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        String string = "IOP Profile (ver = " + this.major + "." + this.minor + ", host = " + this.host + ",port = " + this.port + ",key = " + this.key + ", taggedComponents = ";
        if (this.taggedComponents != null) {
            for (int i = 0; i < this.taggedComponents.length; ++i) {
                string = string + this.taggedComponents[i];
            }
        }
        return string + ")";
    }

    private static void p(String string) {
        System.err.println("<IOPProfile> " + string);
    }
}

